/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class ArExRateUpgradePlugin
implements IUpgradeService {
    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return resultMap;
        }
        boolean success = true;
        String log = "Ar ExRate Upgrade SUCCESS!";
        String info = "Ar ExRate Upgrade SUCCESS!";
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return resultMap;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return new UpgradeResult(this.beforeExecuteSql(ver, iteration, dbKey, sqlFileName));
    }

    public void upgrade() {
        DynamicObject[] arbusbills;
        DynamicObject[] finarbills2;
        DynamicObject[] finarbills;
        String baddebtlossQuerySql = "SELECT fsourcebillid FROM t_ar_baddebtlossbill";
        DataSet baddebtlossDataSet = DB.queryDataSet((String)"AR.QUERYUPDATEEXRATE", (DBRoute)DBRouteConst.AR, (String)baddebtlossQuerySql);
        LinkedList<Long> baddebtlossIds = new LinkedList<Long>();
        for (Row row : baddebtlossDataSet) {
            baddebtlossIds.add(row.getLong("fsourcebillid"));
        }
        QFilter filter = new QFilter("id", "in", baddebtlossIds);
        String baddebtlosssql = "UPDATE t_ar_baddebtlossbill SET fexratetableid=?,fexratedate=? WHERE fsourcebillid=?";
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        for (DynamicObject finarbill : finarbills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"exratetable,exratedate", (QFilter[])filter.toArray())) {
            Date exratedate;
            DynamicObject exratetable = finarbill.getDynamicObject("exratetable");
            if (exratetable == null || (exratedate = finarbill.getDate("exratedate")) == null) continue;
            long exratetableid = exratetable.getLong("id");
            Object[] param = new Object[]{exratetableid, exratedate, finarbill.getLong("id")};
            params.add(param);
        }
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AR, (String)baddebtlosssql, params);
        }
        String revcfmbillQuerySql = "SELECT fsourcebillid FROM t_ar_revcfmbill";
        DataSet revcfmbillDataSet = DB.queryDataSet((String)"AR.QUERYUPDATEEXRATE", (DBRoute)DBRouteConst.AR, (String)revcfmbillQuerySql);
        LinkedList<Long> revcfmbillIds = new LinkedList<Long>();
        for (Row row : revcfmbillDataSet) {
            revcfmbillIds.add(row.getLong("fsourcebillid"));
        }
        QFilter filter2 = new QFilter("id", "in", revcfmbillIds);
        String revcfmbillSql = "UPDATE t_ar_revcfmbill SET fexratetableid=?,fexratedate=? WHERE fsourcebillid=?";
        LinkedList<Object[]> params2 = new LinkedList<Object[]>();
        for (DynamicObject finarbill : finarbills2 = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"exratetable,exratedate", (QFilter[])filter2.toArray())) {
            Date exratedate;
            DynamicObject exratetable = finarbill.getDynamicObject("exratetable");
            if (exratetable == null || (exratedate = finarbill.getDate("exratedate")) == null) continue;
            long exratetableid = exratetable.getLong("id");
            Object[] param = new Object[]{exratetableid, exratedate, finarbill.getLong("id")};
            params2.add(param);
        }
        for (DynamicObject arbusbill : arbusbills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"exratetable,exratedate", (QFilter[])filter2.toArray())) {
            Date exratedate;
            DynamicObject exratetable = arbusbill.getDynamicObject("exratetable");
            if (exratetable == null || (exratedate = arbusbill.getDate("exratedate")) == null) continue;
            long exratetableid = exratetable.getLong("id");
            Object[] param = new Object[]{exratetableid, exratedate, arbusbill.getLong("id")};
            params2.add(param);
        }
        if (params2.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AR, (String)revcfmbillSql, params2);
        }
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

