/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class ArInvoiceBuyerNameUpgradePlugin
implements IUpgradeService {
    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("info", "is not need Upgrade");
            return resultMap;
        }
        boolean success = true;
        String log = "Ar Invoice BuyerName Upgrade SUCCESS!";
        String info = "Ar Invoice BuyerName Upgrade SUCCESS!";
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return resultMap;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return new UpgradeResult(this.beforeExecuteSql(ver, iteration, dbKey, sqlFileName));
    }

    public void upgrade() {
        DynamicObject[] updateableInvoices;
        String invoiceQuerySql = "SELECT FID FROM T_AR_INVOICE WHERE FBUYERNAME in ('',' ')";
        DataSet invoiceDataSet = DB.queryDataSet((String)"AR.QUERYUPDATEABLEINVOICE", (DBRoute)DBRouteConst.AR, (String)invoiceQuerySql);
        LinkedList<Long> invoiceIds = new LinkedList<Long>();
        for (Row row : invoiceDataSet) {
            invoiceIds.add(row.getLong("FID"));
        }
        QFilter filter = new QFilter("id", "in", invoiceIds);
        String sql = "UPDATE T_AR_INVOICE SET FBUYERNAME=? WHERE FID=?";
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        for (DynamicObject invoice : updateableInvoices = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"asstacttype,buyer", (QFilter[])filter.toArray())) {
            String buyerName;
            ILocaleString localeName;
            DynamicObject buyer = invoice.getDynamicObject("buyer");
            if (buyer == null || (localeName = buyer.getLocaleString("name")) == null || (buyerName = localeName.getLocaleValue()) == null || buyerName.length() >= 255) continue;
            Object[] param = new Object[]{buyerName, invoice.getPkValue()};
            params.add(param);
        }
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AR, (String)sql, params);
        }
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

