/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArInvoiceLocalAmtP1UpgradePlugin
implements IUpgradeService {
    private static final int MAX_PROCESSNUMBER = 10000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgradeFinBills();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    public void upgradeFinBills() {
        String sql = "select fid,FAmtPrecision from T_BD_Currency ";
        DataSet currencyDataSet = DB.queryDataSet((String)"ArInvoiceLocalAmtP1UpgradePlugin", (DBRoute)new DBRoute("sys"), (String)sql, (Object[])new Object[0]);
        HashMap<Long, Integer> currencyMap = new HashMap<Long, Integer>(16);
        for (Row currency : currencyDataSet) {
            Long currencyId = currency.getLong("fid");
            Integer amtPrecision = currency.getInteger("FAmtPrecision");
            currencyMap.put(currencyId, amtPrecision);
        }
        this.updateRateIsOneBlls();
        this.queryAndUpdateArEntry(currencyMap);
    }

    private void updateRateIsOneBlls() {
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        String updateHeadSql = "update t_ar_finarbill_e set finvoicedlocalamt=finvoicedamt,funinvoicedlocalamt=funinvoicedamt,fissueinvreclocalamt=fissueinvrecamt where fid in(select fid from t_ar_finarbill where fexchangerate=1 and fbizdate > ?) and funinvoicedlocalamt=0 and finvoicedlocalamt=0";
        DB.execute((DBRoute)DBRouteConst.AR, (String)updateHeadSql, (Object[])new Object[]{beginDate});
        String updateEntrySql = "update t_ar_finarbillentry_e set finvoicedlocalamt=finvoicedamt,funinvoicedlocalamt=funinvoicedamt,fissueinvlocalamt=fissueinvamt,fissueinvlocaltax=fissueinvtax,fissueinvreclocalamt=fissueinvrecamt where fid in(select fid from t_ar_finarbill where fexchangerate=1 and fbizdate > ?) and finvoicedlocalamt=0 and funinvoicedlocalamt=0";
        DB.execute((DBRoute)DBRouteConst.AR, (String)updateEntrySql, (Object[])new Object[]{beginDate});
    }

    private void queryAndUpdateArEntry(Map<Long, Integer> currencyMap) {
        ArrayList<Date> queryArgs = new ArrayList<Date>(1);
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        queryArgs.add(beginDate);
        String queryFinArIdsSql = "select a.fid from t_ar_finarbill a left join t_ar_finarbill_e b on a.fid=b.fid  where a.fbizdate >? and a.fexchangerate !=1 and b.funinvoicedlocalamt=0 and b.finvoicedlocalamt=0";
        DataSet allFinIdsDataSet = DB.queryDataSet((String)"ArInvoiceLocalAmtP1UpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)queryFinArIdsSql, (Object[])queryArgs.toArray());
        HashSet<Long> billIdSet = new HashSet<Long>(10);
        for (Row finRow : allFinIdsDataSet) {
            billIdSet.add(finRow.getLong("fid"));
            if (billIdSet.size() != 10000) continue;
            this.batchSelectAndUpdatearEntry(billIdSet, currencyMap);
            billIdSet.clear();
        }
        if (!billIdSet.isEmpty()) {
            this.batchSelectAndUpdatearEntry(billIdSet, currencyMap);
        }
    }

    private void batchSelectAndUpdatearEntry(Set<Long> billIdSet, Map<Long, Integer> currencyMap) {
        String queryEntrySql = "select a.fid,a.fquotation,a.fbasecurrencyid,a.fexchangerate,c.frecamount,c.freclocalamt,b.fentryid,b.finvoicedamt,b.funinvoicedamt,b.fissueinvamt,b.fissueinvtax,b.fissueinvrecamt from t_ar_finarbill a left join t_ar_finarbillentry c on a.fid=c.fid left join t_ar_finarbillentry_e b on c.fentryid=b.fentryid where a.fid in (" + StringUtils.join((Object[])billIdSet.toArray(), (String)",") + ")";
        DataSet allFinDataSet = DB.queryDataSet((String)"ArInvoiceLocalAmtP1UpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)queryEntrySql);
        HashMap<Long, Map<String, BigDecimal>> directQuoMap = new HashMap<Long, Map<String, BigDecimal>>(64);
        for (Row finRow : allFinDataSet) {
            BigDecimal issueinvrecLocAmt;
            BigDecimal issueinvLocTax;
            BigDecimal issueinvLocAmt;
            BigDecimal invoicedLocAmt;
            BigDecimal uninvoicedLocAmt;
            HashMap<String, BigDecimal> entryLocAmtMap = new HashMap<String, BigDecimal>(8);
            String quotation = finRow.getString("fquotation");
            BigDecimal exchangeRate = finRow.getBigDecimal("fexchangerate");
            long baseCurrencyId = finRow.getLong("fbasecurrencyid");
            if (currencyMap.get(baseCurrencyId) == null || EmptyUtils.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ZERO) == 0) continue;
            int localPrecision = currencyMap.get(baseCurrencyId);
            BigDecimal invoicedAmt = finRow.getBigDecimal("finvoicedamt");
            invoicedAmt = EmptyUtils.isEmpty((Object)invoicedAmt) ? BigDecimal.ZERO : invoicedAmt;
            BigDecimal uninvoicedAmt = finRow.getBigDecimal("funinvoicedamt");
            uninvoicedAmt = EmptyUtils.isEmpty((Object)uninvoicedAmt) ? BigDecimal.ZERO : uninvoicedAmt;
            BigDecimal issueinvAmt = finRow.getBigDecimal("fissueinvamt");
            issueinvAmt = EmptyUtils.isEmpty((Object)issueinvAmt) ? BigDecimal.ZERO : issueinvAmt;
            BigDecimal issueinvTax = finRow.getBigDecimal("fissueinvtax");
            issueinvTax = EmptyUtils.isEmpty((Object)issueinvTax) ? BigDecimal.ZERO : issueinvTax;
            BigDecimal issueinvrecAmt = finRow.getBigDecimal("fissueinvrecamt");
            issueinvrecAmt = EmptyUtils.isEmpty((Object)issueinvrecAmt) ? BigDecimal.ZERO : issueinvrecAmt;
            BigDecimal recAmount = finRow.getBigDecimal("frecamount");
            BigDecimal recLocalAmount = finRow.getBigDecimal("freclocalamt");
            if (this.amtIsZero(invoicedAmt) && this.amtIsZero(uninvoicedAmt) && this.amtIsZero(issueinvAmt) && this.amtIsZero(issueinvTax) && this.amtIsZero(issueinvrecAmt)) continue;
            long entryId = finRow.getLong("fentryid");
            if ("1".equals(quotation)) {
                if (uninvoicedAmt.compareTo(recAmount) == 0) {
                    uninvoicedLocAmt = recLocalAmount;
                    invoicedLocAmt = BigDecimal.ZERO;
                } else if (invoicedAmt.compareTo(recAmount) == 0) {
                    invoicedLocAmt = recLocalAmount;
                    uninvoicedLocAmt = BigDecimal.ZERO;
                } else {
                    invoicedLocAmt = invoicedAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                    uninvoicedLocAmt = recLocalAmount.subtract(invoicedLocAmt);
                }
                issueinvLocAmt = issueinvAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                issueinvLocTax = issueinvTax.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                issueinvrecLocAmt = issueinvrecAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
            } else {
                if (uninvoicedAmt.compareTo(recAmount) == 0) {
                    uninvoicedLocAmt = recLocalAmount;
                    invoicedLocAmt = BigDecimal.ZERO;
                } else if (invoicedAmt.compareTo(recAmount) == 0) {
                    invoicedLocAmt = recLocalAmount;
                    uninvoicedLocAmt = BigDecimal.ZERO;
                } else {
                    invoicedLocAmt = invoicedAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                    uninvoicedLocAmt = recLocalAmount.subtract(invoicedLocAmt);
                }
                issueinvLocAmt = issueinvAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                issueinvLocTax = issueinvTax.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                issueinvrecLocAmt = issueinvrecAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
            }
            entryLocAmtMap.put("invoicedLocAmt", invoicedLocAmt);
            entryLocAmtMap.put("uninvoicedLocAmt", uninvoicedLocAmt);
            entryLocAmtMap.put("issueinvLocAmt", issueinvLocAmt);
            entryLocAmtMap.put("issueinvLocTax", issueinvLocTax);
            entryLocAmtMap.put("issueinvrecLocAmt", issueinvrecLocAmt);
            directQuoMap.put(entryId, entryLocAmtMap);
            if (directQuoMap.size() != 10000) continue;
            this.updateEntryInvLocAmt(directQuoMap);
            directQuoMap.clear();
        }
        if (!directQuoMap.isEmpty()) {
            this.updateEntryInvLocAmt(directQuoMap);
        }
        this.updateHeadInvAmt(billIdSet);
    }

    private boolean amtIsZero(BigDecimal amt) {
        return EmptyUtils.isEmpty((Object)amt) ? true : amt.compareTo(BigDecimal.ZERO) == 0;
    }

    private void updateEntryInvLocAmt(Map<Long, Map<String, BigDecimal>> directQuoMap) {
        if (directQuoMap == null || directQuoMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(directQuoMap.size());
        for (Map.Entry<Long, Map<String, BigDecimal>> m : directQuoMap.entrySet()) {
            Map<String, BigDecimal> localAmtMap = m.getValue();
            Object[] param = new Object[]{localAmtMap.get("invoicedLocAmt"), localAmtMap.get("uninvoicedLocAmt"), localAmtMap.get("issueinvLocAmt"), localAmtMap.get("issueinvLocTax"), localAmtMap.get("issueinvrecLocAmt"), m.getKey()};
            updateFinBillParams.add(param);
        }
        String updateSql = "update t_ar_finarbillentry_e set finvoicedlocalamt=? ,funinvoicedlocalamt=?,fissueinvlocalamt=?,fissueinvlocaltax=?,fissueinvreclocalamt=? where fentryid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateFinBillParams);
    }

    private void updateHeadInvAmt(Set<Long> billIdSet) {
        Iterator<Long> it = billIdSet.iterator();
        ArrayList<Object[]> updateHeadParams = new ArrayList<Object[]>(10);
        while (it.hasNext()) {
            long billId = it.next();
            Object[] param = new Object[]{billId};
            updateHeadParams.add(param);
        }
        if (!updateHeadParams.isEmpty()) {
            this.exeUpdateHeadAmtSql(updateHeadParams);
        }
    }

    private void exeUpdateHeadAmtSql(List<Object[]> updateHeadParams) {
        String updateInvLocAmtSql = "update t_ar_finarbill_e set finvoicedlocalamt=(select sum(finvoicedlocalamt) from t_ar_finarbillentry_e where t_ar_finarbillentry_e.fid=t_ar_finarbill_e.fid) where fid = ?";
        DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateInvLocAmtSql, updateHeadParams);
        String updateUnInvLocAmtSql = "update t_ar_finarbill_e set funinvoicedlocalamt=(select sum(funinvoicedlocalamt) from t_ar_finarbillentry_e where t_ar_finarbillentry_e.fid=t_ar_finarbill_e.fid) where fid=  ?";
        DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateUnInvLocAmtSql, updateHeadParams);
        String updateInvRecLocAmtSql = "update t_ar_finarbill_e set fissueinvreclocalamt=(select sum(fissueinvreclocalamt) from t_ar_finarbillentry_e where t_ar_finarbillentry_e.fid=t_ar_finarbill_e.fid) where fid= ?";
        DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateInvRecLocAmtSql, updateHeadParams);
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

