/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public class ArInvoiceLocalAmtUpgradePlugin
implements IUpgradeService {
    private static final int MAX_PROCESSNUMBER = 10000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgradeFinBills();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    public void upgradeFinBills() {
        String sql = "select fid,FAmtPrecision from T_BD_Currency ";
        DataSet currencyDataSet = DB.queryDataSet((String)"ArInvoiceLocalAmtUpgradePlugin", (DBRoute)new DBRoute("sys"), (String)sql, (Object[])new Object[0]);
        HashMap<Long, Integer> currencyMap = new HashMap<Long, Integer>(16);
        for (Row currency : currencyDataSet) {
            Long currencyId = currency.getLong("fid");
            Integer amtPrecision = currency.getInteger("FAmtPrecision");
            currencyMap.put(currencyId, amtPrecision);
        }
        this.queryAndUpdateArEntry(currencyMap);
    }

    private void queryAndUpdateArEntry(Map<Long, Integer> currencyMap) {
        ArrayList<Date> queryArgs = new ArrayList<Date>(1);
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        queryArgs.add(beginDate);
        String queryEntrySql = "select a.fid,a.fquotation,a.fbasecurrencyid,a.fexchangerate,b.fentryid,b.finvoicedamt,b.funinvoicedamt,b.fissueinvamt,b.fissueinvtax,b.fissueinvrecamt from t_ar_finarbill a  left join t_ar_finarbillentry_e b on a.fid=b.fid and a.fbizdate >?";
        DataSet allFinDataSet = DB.queryDataSet((String)"ArInvoiceLocalAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)queryEntrySql, (Object[])queryArgs.toArray());
        HashMap<Long, Map<String, BigDecimal>> directQuoMap = new HashMap<Long, Map<String, BigDecimal>>(64);
        HashSet<Long> billIdSet = new HashSet<Long>(10);
        for (Row finRow : allFinDataSet) {
            BigDecimal issueinvrecLocAmt;
            BigDecimal issueinvLocTax;
            BigDecimal issueinvLocAmt;
            BigDecimal uninvoicedLocAmt;
            BigDecimal invoicedLocAmt;
            HashMap<String, BigDecimal> entryLocAmtMap = new HashMap<String, BigDecimal>(8);
            String quotation = finRow.getString("fquotation");
            BigDecimal exchangeRate = finRow.getBigDecimal("fexchangerate");
            long baseCurrencyId = finRow.getLong("fbasecurrencyid");
            if (currencyMap.get(baseCurrencyId) == null || EmptyUtils.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ZERO) == 0) continue;
            int localPrecision = currencyMap.get(baseCurrencyId);
            BigDecimal invoicedAmt = finRow.getBigDecimal("finvoicedamt");
            invoicedAmt = EmptyUtils.isEmpty((Object)invoicedAmt) ? BigDecimal.ZERO : invoicedAmt;
            BigDecimal uninvoicedAmt = finRow.getBigDecimal("funinvoicedamt");
            uninvoicedAmt = EmptyUtils.isEmpty((Object)uninvoicedAmt) ? BigDecimal.ZERO : uninvoicedAmt;
            BigDecimal issueinvAmt = finRow.getBigDecimal("fissueinvamt");
            issueinvAmt = EmptyUtils.isEmpty((Object)issueinvAmt) ? BigDecimal.ZERO : issueinvAmt;
            BigDecimal issueinvTax = finRow.getBigDecimal("fissueinvtax");
            issueinvTax = EmptyUtils.isEmpty((Object)issueinvTax) ? BigDecimal.ZERO : issueinvTax;
            BigDecimal issueinvrecAmt = finRow.getBigDecimal("fissueinvrecamt");
            BigDecimal bigDecimal = issueinvrecAmt = EmptyUtils.isEmpty((Object)issueinvrecAmt) ? BigDecimal.ZERO : issueinvrecAmt;
            if (this.amtIsZero(invoicedAmt) && this.amtIsZero(uninvoicedAmt) && this.amtIsZero(issueinvAmt) && this.amtIsZero(issueinvTax) && this.amtIsZero(issueinvrecAmt)) continue;
            long entryId = finRow.getLong("fentryid");
            billIdSet.add(finRow.getLong("fid"));
            if (exchangeRate.compareTo(BigDecimal.ONE) == 0) {
                entryLocAmtMap.put("invoicedLocAmt", invoicedAmt);
                entryLocAmtMap.put("uninvoicedLocAmt", uninvoicedAmt);
                entryLocAmtMap.put("issueinvLocAmt", issueinvAmt);
                entryLocAmtMap.put("issueinvLocTax", issueinvTax);
                entryLocAmtMap.put("issueinvrecLocAmt", issueinvrecAmt);
                directQuoMap.put(entryId, entryLocAmtMap);
                continue;
            }
            if ("1".equals(quotation)) {
                invoicedLocAmt = invoicedAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                uninvoicedLocAmt = uninvoicedAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                issueinvLocAmt = issueinvAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                issueinvLocTax = issueinvTax.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                issueinvrecLocAmt = issueinvrecAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
            } else {
                invoicedLocAmt = invoicedAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                uninvoicedLocAmt = uninvoicedAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                issueinvLocAmt = issueinvAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                issueinvLocTax = issueinvTax.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                issueinvrecLocAmt = issueinvrecAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
            }
            entryLocAmtMap.put("invoicedLocAmt", invoicedLocAmt);
            entryLocAmtMap.put("uninvoicedLocAmt", uninvoicedLocAmt);
            entryLocAmtMap.put("issueinvLocAmt", issueinvLocAmt);
            entryLocAmtMap.put("issueinvLocTax", issueinvLocTax);
            entryLocAmtMap.put("issueinvrecLocAmt", issueinvrecLocAmt);
            directQuoMap.put(entryId, entryLocAmtMap);
            if (directQuoMap.size() != 10000) continue;
            this.updateEntryInvLocAmt(directQuoMap);
            directQuoMap.clear();
        }
        if (!directQuoMap.isEmpty()) {
            this.updateEntryInvLocAmt(directQuoMap);
        }
        this.updateHeadInvAmt(billIdSet);
    }

    private boolean amtIsZero(BigDecimal amt) {
        return EmptyUtils.isEmpty((Object)amt) ? true : amt.compareTo(BigDecimal.ZERO) == 0;
    }

    private void updateEntryInvLocAmt(Map<Long, Map<String, BigDecimal>> directQuoMap) {
        if (directQuoMap == null || directQuoMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(directQuoMap.size());
        for (Map.Entry<Long, Map<String, BigDecimal>> m : directQuoMap.entrySet()) {
            Map<String, BigDecimal> localAmtMap = m.getValue();
            Object[] param = new Object[]{localAmtMap.get("invoicedLocAmt"), localAmtMap.get("uninvoicedLocAmt"), localAmtMap.get("issueinvLocAmt"), localAmtMap.get("issueinvLocTax"), localAmtMap.get("issueinvrecLocAmt"), m.getKey()};
            updateFinBillParams.add(param);
        }
        String updateSql = "update t_ar_finarbillentry_e set finvoicedlocalamt=? ,funinvoicedlocalamt=?,fissueinvlocalamt=?,fissueinvlocaltax=?,fissueinvreclocalamt=? where fentryid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateFinBillParams);
    }

    private void updateHeadInvAmt(Set<Long> billIdSet) {
        Iterator<Long> it = billIdSet.iterator();
        ArrayList<Object[]> updateHeadParams = new ArrayList<Object[]>(10);
        while (it.hasNext()) {
            long billId = it.next();
            Object[] param = new Object[]{billId};
            updateHeadParams.add(param);
            if (updateHeadParams.size() != 10000) continue;
            this.exeUpdateHeadAmtSql(updateHeadParams);
            updateHeadParams.clear();
        }
        if (!updateHeadParams.isEmpty()) {
            this.exeUpdateHeadAmtSql(updateHeadParams);
        }
    }

    private void exeUpdateHeadAmtSql(List<Object[]> updateHeadParams) {
        String updateInvLocAmtSql = "update t_ar_finarbill_e set finvoicedlocalamt=(select sum(finvoicedlocalamt) from t_ar_finarbillentry_e where t_ar_finarbillentry_e.fid=t_ar_finarbill_e.fid) where fid = ?";
        DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateInvLocAmtSql, updateHeadParams);
        String updateUnInvLocAmtSql = "update t_ar_finarbill_e set funinvoicedlocalamt=(select sum(funinvoicedlocalamt) from t_ar_finarbillentry_e where t_ar_finarbillentry_e.fid=t_ar_finarbill_e.fid) where fid=  ?";
        DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateUnInvLocAmtSql, updateHeadParams);
        String updateInvRecLocAmtSql = "update t_ar_finarbill_e set fissueinvreclocalamt=(select sum(fissueinvreclocalamt) from t_ar_finarbillentry_e where t_ar_finarbillentry_e.fid=t_ar_finarbill_e.fid) where fid= ?";
        DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateInvRecLocAmtSql, updateHeadParams);
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

