/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class ArInvoiceUnitUpgradePlugin
implements IUpgradeService {
    public Map<String, Object> afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("info", "is not need Upgrade");
            return resultMap;
        }
        boolean success = true;
        String log = "Ar Invoice invoiceUnit Upgrade SUCCESS!";
        String info = "Ar Invoice invoiceUnit Upgrade SUCCESS!";
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return resultMap;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return new UpgradeResult(this.afterExecuteSql(ver, iteration, dbKey, sqlFileName));
    }

    public void upgrade() {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ar_invoice");
        BasedataProp basedataProp = (BasedataProp)dt.findProperty("hihn_e_invunit");
        if (ObjectUtils.isEmpty((Object)basedataProp)) {
            DynamicObject[] arinvoices = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"e_measureunit, e_invoiceunit", (QFilter[])new QFilter[0]);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (DynamicObject arinvoice : arinvoices) {
                DynamicObjectCollection entryCollection = arinvoice.getDynamicObjectCollection("entry");
                for (DynamicObject entryObject : entryCollection) {
                    DynamicObject measureunit = entryObject.getDynamicObject("e_measureunit");
                    String invoiceunit = entryObject.getString("e_invoiceunit");
                    if (ObjectUtils.isEmpty((Object)measureunit) || !ObjectUtils.isEmpty((Object)invoiceunit)) continue;
                    ILocaleString localeName = measureunit.getLocaleString("name");
                    String measureunitName = localeName.getLocaleValue();
                    paramList.add(new Object[]{measureunitName, entryObject.getPkValue()});
                }
            }
            if (!paramList.isEmpty()) {
                String sql = "update t_ar_invoiceentry set finvoiceunit=? where fentryid=?";
                DB.executeBatch((DBRoute)DBRouteConst.AR, (String)sql, paramList);
            }
        }
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

