/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ArRevcfRuleAndParamUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String info = "ArRevcfRuleAndParamUpgradePlugin Upgrade doing!";
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("info", info);
        resultMap.put("success", Boolean.TRUE);
        try (TXHandle txHandle = TX.required();){
            try {
                if (ArApHelper.queryArIsNotInit()) {
                    this.upgradeArRevcfCodeRule();
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                String log = ArApHelper.getStackTraceMessage((Throwable)e);
                resultMap.put("log", log);
                resultMap.put("el", "");
            }
        }
        return new UpgradeResult(resultMap);
    }

    private void upgradeArRevcfCodeRule() {
        try (TXHandle txHandle = TX.required();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)"DELETE FROM T_CR_CODERULEENTRY WHERE FENTRYID = '09YRMTV3/HWZ'");
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)"INSERT INTO T_CR_CODERULEENTRY (FENTRYID, FID, FSEQ, FATTRIBUTETYPE, FATTUSINGMODE, FVALUEATRIBUTE, FFORMAT, FSETTINGVALUE, FLENGTH, FINITIAL, FSTEP, FADDCHAR, FISSPLITSIGN, FADDSTYLE, FCUTSTYLE, FISSORTITEM, FSPLITSIGN, FISVISABLE) VALUES ('09YRMTV3/HWZ', '09YRMTIC8MHN', '2', '16', '1', ' ', ' ', ' ', '6', '1', '1', ' ', '1', '1', '1', '0', '-', '1')");
            }
            catch (Exception e) {
                txHandle.markRollback();
            }
        }
    }

    private void upgradeArApParam(boolean isAr) {
        HashMap<String, Boolean> paramMap;
        String initTable = isAr ? "t_ar_init" : "t_ap_init";
        DataSet arInitDataSet = DB.queryDataSet((String)"queryArApInit", (DBRoute)DBRoute.of((String)(isAr ? "ar" : "ap")), (String)("select forgid from " + initTable));
        if (!arInitDataSet.hasNext()) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(64);
        for (Row arInit : arInitDataSet) {
            orgIds.add(arInit.getLong("forgid"));
        }
        String sb = "select forgid from t_bas_sysparameter where fdata like " + (isAr ? "'%\"ar_001\"%'" : "'%\"ap_001\"%' ") + "and forgid in " + StringUtils.longSetToString(orgIds);
        DataSet hasArParamDataSet = DB.queryDataSet((String)"queryArApSysInvParam", (DBRoute)DBRoute.of((String)"sys"), (String)sb);
        HashSet needChangeInvParams = new HashSet(orgIds);
        for (Row row : hasArParamDataSet) {
            needChangeInvParams.remove(row.getLong("forgid"));
        }
        sb = "select forgid from t_bas_sysparameter where fdata like " + (isAr ? "'%\"ar_014\"%'" : "'%\"ap_020\"%' ") + "and forgid in " + StringUtils.longSetToString(orgIds);
        hasArParamDataSet = DB.queryDataSet((String)"queryArApSysVerifyParam", (DBRoute)DBRoute.of((String)"sys"), (String)sb);
        HashSet needChangeVerifyParams = new HashSet(orgIds);
        for (Row row : hasArParamDataSet) {
            needChangeVerifyParams.remove(row.getLong("forgid"));
        }
        if (EmptyUtils.isNotEmpty(needChangeInvParams)) {
            for (Long orgId : needChangeInvParams) {
                paramMap = new HashMap<String, Boolean>(2);
                paramMap.put(isAr ? "ar_001" : "ap_001", Boolean.TRUE);
                if (needChangeVerifyParams.contains(orgId)) {
                    paramMap.put(isAr ? "ar_014" : "ap_020", Boolean.TRUE);
                    needChangeVerifyParams.remove(orgId);
                }
                SystemParameterHelper.setSystemParameterForce((boolean)isAr, (long)orgId, paramMap);
            }
        }
        if (EmptyUtils.isNotEmpty(needChangeVerifyParams)) {
            for (Long orgId : needChangeVerifyParams) {
                paramMap = new HashMap(2);
                paramMap.put(isAr ? "ar_014" : "ap_020", Boolean.TRUE);
                SystemParameterHelper.setSystemParameterForce((boolean)isAr, (long)orgId, paramMap);
            }
        }
    }
}

