/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;

public class ArVerifyBillTypeUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        String log = "ArVerifyBillType Upgrade SUCCESS!";
        String info = "ArVerifyBillType Upgrade SUCCESS!";
        resultMap.put("log", log);
        resultMap.put("info", info);
        try {
            this.upgrade(resultMap);
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade(Map<String, Object> resultMap) {
        try (TXHandle tx = TX.requiresNew((String)"upgrade_arverifybilltype");){
            DynamicObject arBillTypeParam = BusinessDataServiceHelper.loadSingle((String)"ap_stdconfig", (String)"key,value,desc", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"verify.arbilltype")});
            List<String> arVerifyBillTypes = this.arVerifyBillTypes();
            List<String> arAllBillTypes = this.arAllBillTypes();
            DynamicObject[] arBillTypes = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"number", (QFilter[])new QFilter[]{new QFilter("billformid", "=", (Object)"ar_revcfmbill")});
            if (arBillTypeParam == null) {
                arBillTypeParam = BusinessDataServiceHelper.newDynamicObject((String)"ap_stdconfig");
            }
            for (DynamicObject arBillType : arBillTypes) {
                String number = arBillType.getString("number");
                if (arAllBillTypes.contains(number)) continue;
                arVerifyBillTypes.add(number);
            }
            arBillTypeParam.set("key", (Object)"verify.arbilltype");
            arBillTypeParam.set("value", (Object)String.join((CharSequence)",", arVerifyBillTypes));
            arBillTypeParam.set("desc", (Object)ResManager.loadKDString((String)"\u6536\u5165\u786e\u8ba4\u5355\u53c2\u4e0e\u6838\u9500\u7684\u5355\u636e\u7c7b\u578b", (String)"ArVerifyBillTypeUpgradePlugin_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arBillTypeParam});
        }
        catch (Exception e) {
            resultMap.put("log", this.getStackTraceMessage(e));
            resultMap.put("el", "");
            resultMap.put("info", this.getStackTraceMessage(e));
        }
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }

    private List<String> arAllBillTypes() {
        ArrayList<String> arAllBillTypes = new ArrayList<String>(4);
        arAllBillTypes.add("ar_revcfmbill_other_BT_S");
        arAllBillTypes.add("ar_revcfmbill_sale_BT_S");
        arAllBillTypes.add("ar_revcfmbill_service_BT_S");
        arAllBillTypes.add("ar_revcfmbill_standard_BT_S");
        return arAllBillTypes;
    }

    private List<String> arVerifyBillTypes() {
        ArrayList<String> arVerifyBillTypes = new ArrayList<String>(2);
        arVerifyBillTypes.add("ar_revcfmbill_standard_BT_S");
        arVerifyBillTypes.add("ar_revcfmbill_service_BT_S");
        return arVerifyBillTypes;
    }
}

