/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.ar.mservice.upgrade.NewBusArBookDateUpgradePlugin;
import kd.fi.ar.mservice.upgrade.NewFinArBookDateUpgradePlugin;
import kd.fi.ar.mservice.upgrade.NewRevCfmBookDateUpgradePlugin;
import kd.fi.arapcommon.helper.ArApHelper;

public class BookDateUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        NewFinArBookDateUpgradePlugin finUpgradePlugin = new NewFinArBookDateUpgradePlugin();
        UpgradeResult upgradeResult = finUpgradePlugin.beforeExecuteSqlWithResult(ver, iteration, dbKey, sqlFileName);
        if (!upgradeResult.isSuccess()) {
            return upgradeResult;
        }
        NewBusArBookDateUpgradePlugin busUpgradePlugin = new NewBusArBookDateUpgradePlugin();
        UpgradeResult busUpgradeResult = busUpgradePlugin.beforeExecuteSqlWithResult(ver, iteration, dbKey, sqlFileName);
        if (!busUpgradeResult.isSuccess()) {
            return busUpgradeResult;
        }
        NewRevCfmBookDateUpgradePlugin upgradePlugin = new NewRevCfmBookDateUpgradePlugin();
        return upgradePlugin.beforeExecuteSqlWithResult(ver, iteration, dbKey, sqlFileName);
    }

    private void upgradeFinBills() {
        String queryFinBillSql = "SELECT FID,FBIZDATE FROM T_AR_FINARBILL WHERE FBILLSTATUS = 'C' AND FBOOKDATE IS NULL";
        DataSet finBills = DB.queryDataSet((String)"ar.BookDateUpgradePlugin", (DBRoute)new DBRoute("ar"), (String)queryFinBillSql);
        LinkedList<Object[]> updateFinBillParams = new LinkedList<Object[]>();
        for (Row finBill : finBills) {
            Object[] param = new Object[]{finBill.getDate("FBIZDATE"), finBill.getLong("FID")};
            updateFinBillParams.add(param);
        }
        String updateSql = "UPDATE T_AR_FINARBILL SET FBOOKDATE=? WHERE FID=?";
        if (!ObjectUtils.isEmpty(updateFinBillParams)) {
            DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateFinBillParams);
        }
    }

    private void upgradeBusBills() {
        String queryBusBillSql = "SELECT FID,FBIZDATE FROM T_AR_BUSBILL WHERE FBILLSTATUS = 'C' AND FBOOKDATE IS NULL";
        DataSet busBills = DB.queryDataSet((String)"ar.BookDateUpgradePlugin", (DBRoute)new DBRoute("ar"), (String)queryBusBillSql);
        LinkedList<Object[]> updateBusBillParams = new LinkedList<Object[]>();
        for (Row busBill : busBills) {
            Object[] param = new Object[]{busBill.getDate("FBIZDATE"), busBill.getLong("FID")};
            updateBusBillParams.add(param);
        }
        String updateSql = "UPDATE T_AR_BUSBILL SET FBOOKDATE=? WHERE FID=?";
        if (!ObjectUtils.isEmpty(updateBusBillParams)) {
            DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateBusBillParams);
        }
    }

    private void upgradeRevCfmBills() {
        String queryRevCfmBillSql = "SELECT FID,FBIZDATE FROM T_AR_REVCFMBILL WHERE FBILLSTATUS = 'C' AND FBOOKDATE IS NULL";
        DataSet revCfmBills = DB.queryDataSet((String)"ar.BookDateUpgradePlugin", (DBRoute)new DBRoute("ar"), (String)queryRevCfmBillSql);
        LinkedList<Object[]> updateRevCfmBillParams = new LinkedList<Object[]>();
        for (Row revCfmBill : revCfmBills) {
            Object[] param = new Object[]{revCfmBill.getDate("FBIZDATE"), revCfmBill.getLong("FID")};
            updateRevCfmBillParams.add(param);
        }
        String updateSql = "UPDATE T_AR_REVCFMBILL SET FBOOKDATE=? WHERE FID=?";
        if (!ObjectUtils.isEmpty(updateRevCfmBillParams)) {
            DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateRevCfmBillParams);
        }
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

