/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;

public class BusArBillInvApplyUpgradeHandle
extends AbstractUpgradeHandle {
    private static final int MAX_PROCESSNUMBER = 10000;
    private static final Log logger = LogFactory.getLog(BusArBillInvApplyUpgradeHandle.class);

    protected void upgrade(List<Long> billIds) {
        String queryEntrySql = "select fid,fentryid from t_ar_busbillentry_e where fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ")";
        HashSet<Long> upgradeIdSet = new HashSet<Long>(billIds.size());
        HashSet<Long> upgradeEntryIds = new HashSet<Long>(billIds.size());
        Long isSame = 0L;
        DataSet queryEntrySet = DB.queryDataSet((String)"selectentry", (DBRoute)DBRouteConst.AR, (String)queryEntrySql);
        for (Row row : queryEntrySet) {
            Long fentryid = row.getLong("fentryid");
            upgradeEntryIds.add(fentryid);
            Long fid = row.getLong("fid");
            if (isSame.equals(fid)) continue;
            isSame = fid;
            upgradeIdSet.add(fid);
            if (upgradeEntryIds.size() <= 10000) continue;
            this.upgradeRelateField(upgradeIdSet);
            upgradeIdSet.clear();
            upgradeEntryIds.clear();
        }
        if (!ObjectUtils.isEmpty(upgradeIdSet)) {
            this.upgradeRelateField(upgradeIdSet);
            upgradeIdSet.clear();
        }
    }

    private void upgradeRelateField(Set<Long> upgradeIdSet) {
        String selectSql = "select a.fid as fid ,a.fentryid as fentryid,a.fquantity as fquantity,a.frecamount as frecamount ,a.freclocalamt as freclocalamt ,b.frelateinvamt as frelateinvamt ,b.funrelateinvamt as funrelateinvamt,b.frelateinvlocamt as frelateinvlocamt,b.funrelateinvlocamt as funrelateinvlocamt,b.frelateinvqty as frelateinvqty,b.funrelateinvqty as funrelateinvqty from t_ar_busbillentry a inner join t_ar_busbillentry_e b on a.fentryid = b.fentryid where a.fid in (" + StringUtils.join((Object[])upgradeIdSet.toArray(), (String)",") + ");";
        DataSet entrySet = DB.queryDataSet((String)"selectentry", (DBRoute)DBRouteConst.AR, (String)selectSql);
        DataSet headSet = entrySet.copy();
        ArrayList<Object[]> entryParamsList = new ArrayList<Object[]>(8);
        for (Row row : entrySet) {
            Object[] params = new Object[4];
            Long entryId = row.getLong("fentryid");
            BigDecimal qty = row.getBigDecimal("fquantity");
            BigDecimal recAmount = row.getBigDecimal("frecamount");
            BigDecimal recLocAmt = row.getBigDecimal("freclocalamt");
            BigDecimal relateInvAmt = row.getBigDecimal("frelateinvamt");
            BigDecimal unrelateInvAmt = recAmount.subtract(relateInvAmt);
            BigDecimal relateinvlocamt = row.getBigDecimal("frelateinvlocamt");
            BigDecimal unrelateInvLocAmt = recLocAmt.subtract(relateinvlocamt);
            BigDecimal relateinvqty = row.getBigDecimal("frelateinvqty");
            BigDecimal unrelateinvqty = qty.subtract(relateinvqty);
            params[0] = unrelateInvAmt;
            params[1] = unrelateInvLocAmt;
            params[2] = unrelateinvqty;
            params[3] = entryId;
            entryParamsList.add(params);
        }
        String updateEntrySql = " update t_ar_busbillentry_e set funrelateinvamt = ?, funrelateinvlocamt = ?, funrelateinvqty = ? where fentryid = ?";
        try (TXHandle tx = TX.requiresNew((String)"updateRelateField");){
            try {
                if (entryParamsList.size() > 0) {
                    DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateEntrySql, entryParamsList);
                }
                DataSet finishHead = headSet.groupBy(new String[]{"fid"}).sum("frelateinvamt").sum("frelateinvlocamt").finish();
                ArrayList<Object[]> headParamList = new ArrayList<Object[]>(8);
                for (Row row : finishHead) {
                    Object[] params = new Object[]{row.getBigDecimal("frelateinvamt"), row.getBigDecimal("frelateinvamt"), row.getBigDecimal("frelateinvlocamt"), row.getBigDecimal("frelateinvlocamt"), row.getBigDecimal("fid")};
                    headParamList.add(params);
                }
                String updateHeadSql = "update t_ar_busbill set frelateinvamt = ? ,funrelateinvamt = frecamount - ?,frelateinvlocamt = ? , funrelateinvlocamt = freclocalamt - ? where fid = ? ";
                if (headParamList.size() > 0) {
                    DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateHeadSql, headParamList);
                }
            }
            catch (Throwable t) {
                tx.markRollback();
                logger.error("-----\u5347\u7ea7\u672a\u5173\u8054\u5b57\u6bb5\u5931\u8d25----", t);
            }
        }
    }
}

