/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public class BusArBillInvoicedAmtUpgradePlugin
implements IUpgradeService {
    private static final int MAX_PROCESSNUMBER = 5000;
    private static final int MAX_PROCESSENTRYNUMBER = 20000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        try {
            this.doUpgrade();
        }
        catch (Exception e) {
            String log = ArApHelper.getStackTraceMessage((Throwable)e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", log);
        }
        return new UpgradeResult(resultMap);
    }

    public void doUpgrade() {
        for (int i = 1; i < 7; ++i) {
            Date beginDate = DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)new Date(), (int)(-30 * i)), (boolean)true);
            Date endDate = i == 1 ? null : DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)new Date(), (int)(-30 * (i - 1))), (boolean)false);
            this.batchUpdateBusBillByMonth(beginDate, endDate);
        }
    }

    private void batchUpdateBusBillByMonth(Date beginDate, Date endDate) {
        String allIinvoicedSql;
        ArrayList<Date> queryArgs = new ArrayList<Date>(2);
        queryArgs.add(beginDate);
        ArrayList<Map<String, Object>> busBillEntrys = new ArrayList<Map<String, Object>>(2);
        if (endDate == null) {
            allIinvoicedSql = "select a.fid,b.fentryid,b.famount,b.flocalamt from t_ar_busbill a,t_ar_busbillentry b where a.fid = b.fid and a.fbizdate >= ?";
        } else {
            queryArgs.add(endDate);
            allIinvoicedSql = "select a.fid,b.fentryid,b.famount,b.flocalamt from t_ar_busbill a,t_ar_busbillentry b where a.fid = b.fid and a.fbizdate >= ? and a.fbizdate < ?";
        }
        DataSet invoiceDataSet = DB.queryDataSet((String)"BusApInvoicedAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)allIinvoicedSql, (Object[])queryArgs.toArray());
        HashSet<Long> busBillIds = new HashSet<Long>(2);
        HashSet<Long> BusEntryIds = new HashSet<Long>(2);
        for (Row busRow : invoiceDataSet) {
            HashMap<String, Number> busBillEntry = new HashMap<String, Number>(2);
            busBillIds.add(busRow.getLong("fid"));
            BusEntryIds.add(busRow.getLong("fentryid"));
            busBillEntry.put("entryid", busRow.getLong("fentryid"));
            busBillEntry.put("invamt", BigDecimal.ZERO);
            busBillEntry.put("invlocamt", BigDecimal.ZERO);
            busBillEntry.put("uninvamt", busRow.getBigDecimal("famount"));
            busBillEntry.put("unInvlocamt", busRow.getBigDecimal("flocalamt"));
            busBillEntrys.add(busBillEntry);
            if (busBillEntrys.size() != 20000) continue;
            this.executeUpdate(busBillEntrys);
            busBillEntrys.clear();
            this.sameSrcBusBillUp(busBillIds, BusEntryIds);
            this.directIsFinBillUp(busBillIds, BusEntryIds);
            busBillIds.clear();
            busBillEntrys.clear();
        }
        if (busBillEntrys.size() > 0) {
            this.executeUpdate(busBillEntrys);
            busBillEntrys.clear();
            this.sameSrcBusBillUp(busBillIds, BusEntryIds);
            this.directIsFinBillUp(busBillIds, BusEntryIds);
            busBillIds.clear();
            busBillEntrys.clear();
        }
    }

    private void directIsFinBillUp(Set<Long> busBillIds, Set<Long> BusEntryIds) {
        HashMap<Long, Tuple<BigDecimal, BigDecimal>> busBillEntrys = new HashMap<Long, Tuple<BigDecimal, BigDecimal>>(2);
        String directFinSql = "select b.fsrcentryid,b.famount,b.flocalamt from t_ar_finarbill a,t_ar_finarbillentry b where a.fid = b.fid and b.fsrcid in" + StringUtils.longSetToString(busBillIds) + "and b.fsrcentryid in" + StringUtils.longSetToString(BusEntryIds) + "and a.fhadwrittenoff = '0'";
        DataSet directFin = DB.queryDataSet((String)"BusApInvoicedAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)directFinSql);
        for (Row finRow : directFin) {
            Long busEntryId = finRow.getLong("fsrcentryid");
            BigDecimal amount = finRow.getBigDecimal("famount");
            BigDecimal localamt = finRow.getBigDecimal("flocalamt");
            Tuple tuple = (Tuple)busBillEntrys.get(busEntryId);
            if (tuple == null) {
                tuple = Tuple.create((Object)amount, (Object)localamt);
                busBillEntrys.put(busEntryId, (Tuple<BigDecimal, BigDecimal>)tuple);
                continue;
            }
            BigDecimal sumAmt = ((BigDecimal)tuple.item1).add(amount);
            BigDecimal sumLocAmt = ((BigDecimal)tuple.item2).add(localamt);
            busBillEntrys.put(busEntryId, (Tuple<BigDecimal, BigDecimal>)Tuple.create((Object)sumAmt, (Object)sumLocAmt));
        }
        if (busBillEntrys.size() > 0) {
            this.batchUpdateDirFinBill(busBillEntrys);
            busBillEntrys.clear();
        }
    }

    private void batchUpdateDirFinBill(Map<Long, Tuple<BigDecimal, BigDecimal>> busBillEntrys) {
        ArrayList<Map<String, Object>> busBillEntryMap = new ArrayList<Map<String, Object>>(2);
        for (Map.Entry<Long, Tuple<BigDecimal, BigDecimal>> entrySet : busBillEntrys.entrySet()) {
            Long busEntryId = entrySet.getKey();
            Tuple<BigDecimal, BigDecimal> tuple = busBillEntrys.get(busEntryId);
            HashMap<String, Object> busBillEntry = new HashMap<String, Object>(2);
            busBillEntry.put("entryid", busEntryId);
            busBillEntry.put("invamt", tuple.item1);
            busBillEntry.put("invlocamt", tuple.item2);
            busBillEntry.put("uninvamt", tuple.item1);
            busBillEntry.put("unInvlocamt", tuple.item2);
            busBillEntryMap.add(busBillEntry);
        }
        if (busBillEntryMap.size() > 0) {
            this.executeIncrement(busBillEntryMap);
        }
    }

    private void sameSrcBusBillUp(Set<Long> busBillIds, Set<Long> BusEntryIds) {
        HashSet<Long> sameSrcBusIds = new HashSet<Long>(2);
        String allIinvoicedSql = "select a.fsourcebillid from t_ar_busbill a,t_ar_finarbill b where a.fsourcebillid in" + StringUtils.setToString(busBillIds) + "and a.fsrcfinbillid = b.fid and a.fisadjust = '1' and a.funwoffamt <> 0 and b.fsourcebilltype not in('ar_busbill')";
        DataSet sameSrcBus = DB.queryDataSet((String)"BusArInvoicedAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)allIinvoicedSql);
        for (Row busRow : sameSrcBus) {
            Long busId = Long.valueOf(busRow.getString("fsourcebillid"));
            sameSrcBusIds.add(busId);
        }
        if (sameSrcBusIds.size() > 0) {
            this.sameSrcBusUpdate(sameSrcBusIds, BusEntryIds);
        }
    }

    private void sameSrcBusUpdate(Set<Long> busBillIds, Set<Long> busEntryIds) {
        if (busBillIds.size() == 0) {
            return;
        }
        Set busIdStrs = busBillIds.stream().map(String::valueOf).collect(Collectors.toSet());
        String busEntrySql = "select b.fentryid,b.fsrcentryid from t_ar_busbill a,t_ar_busbillentry b where a.fid = b.fid and a.fid in" + StringUtils.longSetToString(busBillIds) + "and b.fentryid in" + StringUtils.longSetToString(busEntryIds) + "and a.fisadjust = '0'";
        DataSet busEntrys = DB.queryDataSet((String)"BusArInvoicedAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)busEntrySql);
        ArrayList<Map<String, Object>> busBillEntrys = new ArrayList<Map<String, Object>>(2);
        for (Row busRow : busEntrys) {
            HashMap<String, Number> busBillEntry = new HashMap<String, Number>(2);
            busBillEntry.put("entryid", busRow.getLong("fentryid"));
            busBillEntry.put("srcentryid", busRow.getLong("fsrcentryid"));
            busBillEntry.put("invamt", BigDecimal.ZERO);
            busBillEntry.put("invlocamt", BigDecimal.ZERO);
            busBillEntry.put("uninvamt", BigDecimal.ZERO);
            busBillEntry.put("unInvlocamt", BigDecimal.ZERO);
            busBillEntrys.add(busBillEntry);
        }
        HashSet<Long> finIds = new HashSet<Long>(2);
        String woffBillSql = "select fsrcfinbillid from t_ar_busbill where fsourcebillid in" + StringUtils.setToString(busIdStrs) + " and fisadjust = '1' and funwoffamt <> 0 and fsrcfinbillid <> 0";
        DataSet woffBillFinIds = DB.queryDataSet((String)"BusApInvoicedAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)woffBillSql);
        for (Row woffFin : woffBillFinIds) {
            finIds.add(woffFin.getLong("fsrcfinbillid"));
        }
        if (finIds.size() == 0) {
            return;
        }
        String finEntrySql = "select b.fsrcentryid,sum(b.famount) as amount,sum(b.flocalamt) as localamt from t_ar_finarbill a,t_ar_finarbillentry b where a.fid = b.fid and a.fid in" + StringUtils.longSetToString(finIds) + "group by  b.fsrcentryid";
        DataSet finBillEntrys = DB.queryDataSet((String)"BusApInvoicedAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)finEntrySql);
        for (Row finRow : finBillEntrys) {
            Long srcEntryId = Long.valueOf(finRow.getString("fsrcentryid"));
            for (Map map : busBillEntrys) {
                Long busEntrySrcId = (Long)map.get("srcentryid");
                if (!srcEntryId.equals(busEntrySrcId)) continue;
                map.put("invamt", finRow.getBigDecimal("amount"));
                map.put("invlocamt", finRow.getBigDecimal("localamt"));
                map.put("uninvamt", finRow.getBigDecimal("amount"));
                map.put("unInvlocamt", finRow.getBigDecimal("localamt"));
            }
        }
        if (busBillEntrys.size() > 0) {
            this.executeIncrement(busBillEntrys);
        }
    }

    private void executeUpdate(List<Map<String, Object>> busBillEntrys) {
        ArrayList<Object[]> updateBusBillParams = new ArrayList<Object[]>(busBillEntrys.size());
        for (Map<String, Object> busBillEntry : busBillEntrys) {
            Object[] param = new Object[]{busBillEntry.get("invamt"), busBillEntry.get("invlocamt"), busBillEntry.get("uninvamt"), busBillEntry.get("unInvlocamt"), (Long)busBillEntry.get("entryid")};
            updateBusBillParams.add(param);
        }
        String updateSql = "update t_ar_busbillentry_e set finvoicednotaxamt = ?,finvnotaxlocalamt = ?,funinvnotaxamt = ?,funinvnotaxlocalamt = ? where fentryid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateBusBillParams);
    }

    private void executeIncrement(List<Map<String, Object>> busBillEntrys) {
        if (busBillEntrys.size() == 0) {
            return;
        }
        ArrayList<Object[]> updateBusBillParams = new ArrayList<Object[]>(busBillEntrys.size());
        for (Map<String, Object> busBillEntry : busBillEntrys) {
            Object[] param = new Object[]{busBillEntry.get("invamt"), busBillEntry.get("invlocamt"), busBillEntry.get("uninvamt"), busBillEntry.get("unInvlocamt"), busBillEntry.get("entryid")};
            updateBusBillParams.add(param);
        }
        String updateSql = "update t_ar_busbillentry_e set finvoicednotaxamt = finvoicednotaxamt + ?,finvnotaxlocalamt = finvnotaxlocalamt + ?,funinvnotaxamt = funinvnotaxamt - ?,funinvnotaxlocalamt = funinvnotaxlocalamt - ? where fentryid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateBusBillParams);
    }
}

