/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.UpgradeDataRangeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.vo.BatchUpdateParam;

public class BusArBillRelateFieldUpgradePlugin
implements IUpgradeService {
    private static final Integer UPGRADESIZE = 5000;
    private static final Log logger = LogFactory.getLog(BusArBillRelateFieldUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        String log = "";
        try {
            try (TXHandle tx = TX.requiresNew((String)"updateTime");){
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String upgradeDate = sdf.format(new Date());
                    String desc = ResManager.loadKDString((String)"2023\u5e74Q1\u53d1\u5e03\u7248\u672c\u53f7BIZ_V5.0.018\u5bf9\u5e94\u66f4\u65b0\u65f6\u95f4\u3002", (String)"BusArBillRelateFieldUpgradePlugin_0", (String)"fi-ar-mservice", (Object[])new Object[0]);
                    String insertSql = " IF NOT EXISTS (SELECT 1 FROM T_AP_STDCONFIG WHERE FID = 1629800659152979968) INSERT INTO t_ap_stdconfig(FID,FVALUE,FKEY,FDESC) VALUES (1629800659152979968,'" + upgradeDate + "','BIZ_V5.0.018_DataUpgrade','" + desc + "');";
                    DB.execute((DBRoute)new DBRoute("fi"), (String)insertSql);
                }
                catch (Throwable t) {
                    tx.markRollback();
                    logger.error("--\u5168\u5c40\u914d\u7f6e\u65b0\u589e\u66f4\u65b0\u65f6\u95f4\u5931\u8d25--", t);
                }
            }
            this.updateAlreadyFiled();
            this.updateNoAlreadyFiled();
        }
        catch (Exception e) {
            log = this.getStackTraceMessage(e);
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    public void begin() {
        try (TXHandle tx = TX.requiresNew((String)"updateTime");){
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String upgradeDate = sdf.format(new Date());
                String desc = ResManager.loadKDString((String)"2023\u5e74Q1\u53d1\u5e03\u7248\u672c\u53f7BIZ_V5.0.018\u5bf9\u5e94\u66f4\u65b0\u65f6\u95f4\u3002", (String)"BusArBillRelateFieldUpgradePlugin_0", (String)"fi-ar-mservice", (Object[])new Object[0]);
                String insertSql = " IF NOT EXISTS (SELECT 1 FROM T_AP_STDCONFIG WHERE FID = 1629800659152979968) INSERT INTO t_ap_stdconfig(FID,FVALUE,FKEY,FDESC) VALUES (1629800659152979968,'" + upgradeDate + "','BIZ_V5.0.018_DataUpgrade','" + desc + "');";
                DB.execute((DBRoute)new DBRoute("fi"), (String)insertSql);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("--\u5168\u5c40\u914d\u7f6e\u65f6\u95f4\u5931\u8d25--", (Throwable)e);
            }
        }
        this.updateAlreadyFiled();
        this.updateNoAlreadyFiled();
    }

    public void updateNoAlreadyFiled() {
        BatchUpdateParam paramVO = new BatchUpdateParam();
        paramVO.setUpgradeDataRange(UpgradeDataRangeEnum.HALFYEAR);
        paramVO.setBizObj("ar_busbill");
        paramVO.setPlugin("kd.fi.ar.mservice.upgrade.BusArBillInvApplyUpgradeHandle");
        UpgradeConfigHelper.batchExecute((BatchUpdateParam)paramVO);
    }

    private Object[] updateSqlParams(Map<String, Object> busMap, Map<String, Object> invMap) {
        BigDecimal relateInvQty = BigDecimal.ZERO;
        BigDecimal relateInvAmt = BigDecimal.ZERO;
        BigDecimal relateInvLocAmt = BigDecimal.ZERO;
        Object[] params = new Object[4];
        String closestatus = (String)invMap.get("closestatus");
        String confirmstate = (String)invMap.get("confirmstate");
        BigDecimal oldRelateInvQty = (BigDecimal)busMap.get("relateinvqty");
        BigDecimal oldRelateInvAmt = (BigDecimal)busMap.get("relateinvamt");
        BigDecimal oldRelateInvLocAmt = (BigDecimal)busMap.get("relateinvlocamt");
        Object currencyIdObj = busMap.get("currencyid");
        Long currencyid = 0L;
        if (!ObjectUtils.isEmpty((Object)currencyIdObj)) {
            currencyid = (Long)currencyIdObj;
        }
        if ("1".equals(closestatus)) {
            if ("1".equals(confirmstate)) {
                relateInvAmt = currencyid == 1L ? (BigDecimal)invMap.get("issuedtotaltaxamount") : (BigDecimal)invMap.get("fromissuedtaxamount");
                relateInvLocAmt = (BigDecimal)invMap.get("issuedtotaltaxamount");
            }
            if ("2".equals(confirmstate)) {
                relateInvLocAmt = (BigDecimal)invMap.get("combinelocalamount");
                relateInvAmt = (BigDecimal)invMap.get("combineamount");
            }
        } else {
            relateInvLocAmt = (BigDecimal)invMap.get("combinelocalamount");
            relateInvAmt = (BigDecimal)invMap.get("combineamount");
        }
        BigDecimal busEntryRecLocAmt = (BigDecimal)busMap.get("reclocalamt");
        if ("1".equals(invMap.get("benchmark"))) {
            if (!"1".equals(closestatus) || !"0".equals(confirmstate)) {
                BigDecimal busEntryQty = (BigDecimal)busMap.get("quantity");
                if (relateInvAmt.abs().compareTo(busEntryRecLocAmt.abs()) >= 0) {
                    relateInvQty = busEntryQty;
                }
            }
        } else if ("1".equals(closestatus)) {
            if ("1".equals(confirmstate)) {
                relateInvQty = (BigDecimal)invMap.get("issuednum");
            }
            if ("2".equals(confirmstate)) {
                relateInvQty = (BigDecimal)invMap.get("combinenum");
            }
        } else {
            relateInvQty = (BigDecimal)invMap.get("combinenum");
        }
        busMap.put("relateinvqty", relateInvQty.add(oldRelateInvQty));
        busMap.put("relateinvamt", relateInvAmt.add(oldRelateInvAmt));
        busMap.put("relateinvlocamt", relateInvLocAmt.add(oldRelateInvLocAmt));
        params[0] = relateInvQty.add(oldRelateInvQty);
        params[1] = relateInvAmt.add(oldRelateInvAmt);
        params[2] = relateInvLocAmt.add(oldRelateInvLocAmt);
        params[3] = busMap.get("entry.id");
        return params;
    }

    private void updateAlreadyFiled() {
        String selectSql = "select fid from t_sim_original_bill where fsystemsource = 'AR_FINARBILL'";
        DBRoute taxcRoute = new DBRoute("taxc");
        DataSet dataSet = DB.queryDataSet((String)"selectInvApplyId", (DBRoute)taxcRoute, (String)selectSql);
        HashSet<Long> idSet = new HashSet<Long>(8);
        for (Row row : dataSet) {
            idSet.add(row.getLong("fid"));
            if (idSet.size() < UPGRADESIZE) continue;
            try {
                this.upgrade(idSet);
            }
            catch (Throwable t) {
                logger.error("--------\u6682\u4f30\u5355\u5df2\u76f8\u5173\u5b57\u6bb5\u6570\u636e\u5347\u7ea7--------", t);
            }
            idSet.clear();
        }
        if (idSet.size() > 0) {
            try {
                this.upgrade(idSet);
            }
            catch (Throwable t) {
                logger.error("--------\u6682\u4f30\u5355\u5df2\u76f8\u5173\u5b57\u6bb5\u6570\u636e\u5347\u7ea7--------", t);
            }
        }
    }

    public void upgrade(Set<Long> idSet) {
        String selectInvSql = "select a.fconfirmstate as fconfirmstate,ae.fclosestatus as fclosestatus,item.fentryid as fentryid ,item.fcombinelocalamount as fcombinelocalamount ,item.fcombineamount as fcombineamount,item.fcombinenum as fcombinenum,item.fbenchmark as fbenchmark,item.fissuedtotaltaxamount as fissuedtotaltaxamount,item.ffromissuedtaxamount as ffromissuedtaxamount,item.fissuednum as fissuednum from t_sim_original_bill_item item inner join t_sim_original_bill_e ae on item.fid = ae.fid inner join t_sim_original_bill a on a.fid = item.fid where a.fid in (" + StringUtils.join((Object[])idSet.toArray(new Long[0]), (String)",") + ")";
        DBRoute taxcRoute = new DBRoute("taxc");
        DataSet invDataSet = DB.queryDataSet((String)"selectInvApplyId", (DBRoute)taxcRoute, (String)selectInvSql);
        HashMap<Long, Map<String, Object>> invEntryIdMap = new HashMap<Long, Map<String, Object>>(8);
        HashSet<Long> entryIdSet = new HashSet<Long>(8);
        for (Row row : invDataSet) {
            HashMap<String, Object> invEntryValueMap = new HashMap<String, Object>(8);
            invEntryValueMap.put("combinelocalamount", row.getBigDecimal("fcombinelocalamount"));
            invEntryValueMap.put("combineamount", row.getBigDecimal("fcombineamount"));
            invEntryValueMap.put("combinenum", row.getBigDecimal("fcombinenum"));
            invEntryValueMap.put("benchmark", row.getString("fbenchmark"));
            invEntryValueMap.put("issuedtotaltaxamount", row.getBigDecimal("fissuedtotaltaxamount"));
            invEntryValueMap.put("issuednum", row.getBigDecimal("fissuednum"));
            invEntryValueMap.put("fromissuedtaxamount", row.getBigDecimal("ffromissuedtaxamount"));
            invEntryValueMap.put("closestatus", row.getString("fclosestatus"));
            invEntryValueMap.put("confirmstate", row.getString("fconfirmstate"));
            Long entryId = row.getLong("fentryid");
            invEntryIdMap.put(entryId, invEntryValueMap);
            entryIdSet.add(entryId);
        }
        Map invBusMap = BOTPNewHelper.loadNearSourceRowIds((String)"sim_original_bill", (String)"sim_original_bill_item", (Long[])idSet.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)"ar_busbill");
        logger.info("invBusMap size is " + invBusMap.size());
        HashSet busIdSet = new HashSet(invBusMap.values());
        if (ObjectUtils.isEmpty(busIdSet)) {
            return;
        }
        String selectSql = "select a.fentryid as fentryid, a.frelateinvamt as frelateinvamt, a.frelateinvlocamt as frelateinvlocamt, a.frelateinvqty as frelateinvqty, b.fquantity as fquantity ,b.freclocalamt as freclocalamt ,c.fcurrencyid as fcurrencyid from t_ar_busbillentry_e a inner join t_ar_busbillentry b on a.fentryid = b.fentryid inner join t_ar_busbill c on c.fid = a.fid where a.fentryid in (" + StringUtils.join((Object[])busIdSet.toArray(new Long[0]), (String)",") + ")  and b.fquantity != a.frelateinvqty ;";
        DataSet dataSet = DB.queryDataSet((String)"selectBus", (DBRoute)DBRouteConst.AR, (String)selectSql);
        HashMap<Long, Map<String, Object>> busEntryIdMap = new HashMap<Long, Map<String, Object>>(8);
        for (Row row : dataSet) {
            Long entryId = row.getLong("fentryid");
            HashMap<String, Number> busEntryValueMap = new HashMap<String, Number>();
            busEntryValueMap.put("quantity", row.getBigDecimal("fquantity"));
            busEntryValueMap.put("relateinvamt", row.getBigDecimal("frelateinvamt"));
            busEntryValueMap.put("relateinvlocamt", row.getBigDecimal("frelateinvlocamt"));
            busEntryValueMap.put("relateinvqty", row.getBigDecimal("frelateinvqty"));
            busEntryValueMap.put("reclocalamt", row.getBigDecimal("freclocalamt"));
            busEntryValueMap.put("currencyid", row.getLong("fcurrencyid"));
            busEntryValueMap.put("entry.id", entryId);
            busEntryIdMap.put(entryId, busEntryValueMap);
        }
        this.updateParams(invEntryIdMap, busEntryIdMap, invBusMap);
    }

    private void updateParams(Map<Long, Map<String, Object>> invEntryIdMap, Map<Long, Map<String, Object>> busEntryIdmap, Map<Long, Long> invBusMap) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(8);
        String updateSql = "update t_ar_busbillentry_e set frelateinvqty  = ?, frelateinvamt = ? , frelateinvlocamt = ? where fentryid = ?;";
        for (Map.Entry<Long, Map<String, Object>> entry : invEntryIdMap.entrySet()) {
            Long key = entry.getKey();
            Map<String, Object> invMap = invEntryIdMap.get(key);
            Map<String, Object> busMap = busEntryIdmap.get(invBusMap.get(key));
            if (ObjectUtils.isEmpty(invMap) || ObjectUtils.isEmpty(busMap)) continue;
            Object[] params = this.updateSqlParams(busMap, invMap);
            updateParams.add(params);
            if (updateParams.size() < UPGRADESIZE) continue;
            this.execute(updateSql, updateParams);
            updateParams.clear();
        }
        if (updateParams.size() > 0) {
            this.execute(updateSql, updateParams);
        }
    }

    private void execute(String updateSql, List<Object[]> updateParams) {
        try (TXHandle tx = TX.requiresNew((String)"updateUnRelateField");){
            try {
                DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateSql, updateParams);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("--\u5347\u7ea7\u5df2\u76f8\u5173\u7684\u5b57\u6bb5\u5931\u8d25--", (Throwable)e);
            }
        }
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

