/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;

public class BusArUnwoffAmtUpgradePlugin
implements IUpgradeService {
    private static final int MAX_PROCESSNUMBER = 10000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.busWoffUpgrade();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    public void test() {
        this.busWoffUpgrade();
    }

    public void busWoffUpgrade() {
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        ArrayList<Date> queryArgs = new ArrayList<Date>(2);
        queryArgs.add(beginDate);
        String qrySql = "select distinct a.fid from t_ar_busbill a left join t_ar_busbillentry b on a.fid =b.fid where b.funwoffamt<>0 and a.fbizdate>=?";
        DataSet needUpgradeBills = DB.queryDataSet((String)"BusApUnwoffAmtUpgradePlugin", (DBRoute)new DBRoute("fi"), (String)qrySql, (Object[])queryArgs.toArray());
        HashSet<Long> needUpgradeBillIds = new HashSet<Long>(64);
        for (Row row : needUpgradeBills) {
            long id = row.getLong("fid");
            needUpgradeBillIds.add(id);
            if (needUpgradeBillIds.size() != 10000) continue;
            this.updateWoffBills(needUpgradeBillIds);
            needUpgradeBillIds.clear();
        }
        if (!needUpgradeBillIds.isEmpty()) {
            this.updateWoffBills(needUpgradeBillIds);
        }
    }

    private void updateWoffBills(Set<Long> needUpgradeBillIds) {
        String qrySql1 = "select funwoffamt,frecamount,fentryid from t_ar_busbillentry where funwoffamt<>0 and fid in (" + StringUtils.join((Object[])needUpgradeBillIds.toArray(), (String)",") + ");";
        DataSet needUpgradeBillentrys = DB.queryDataSet((String)"BusApUnwoffAmtUpgradePlugin", (DBRoute)new DBRoute("fi"), (String)qrySql1);
        HashSet<Long> allUnWoffBillEntryIds = new HashSet<Long>(64);
        HashSet<Long> partWoffBillEntryIds = new HashSet<Long>(64);
        for (Row row : needUpgradeBillentrys) {
            BigDecimal unwoffamt = row.getBigDecimal("funwoffamt");
            BigDecimal pricetaxtotal = row.getBigDecimal("frecamount");
            long entryid = row.getLong("fentryid");
            if (unwoffamt.compareTo(pricetaxtotal) == 0) {
                allUnWoffBillEntryIds.add(entryid);
                if (allUnWoffBillEntryIds.size() != 10000) continue;
                this.updateAllUnWoffEntry(allUnWoffBillEntryIds);
                allUnWoffBillEntryIds.clear();
                continue;
            }
            partWoffBillEntryIds.add(entryid);
            if (partWoffBillEntryIds.size() != 10000) continue;
            this.updatePartWoffEntry(partWoffBillEntryIds);
            partWoffBillEntryIds.clear();
        }
        if (!allUnWoffBillEntryIds.isEmpty()) {
            this.updateAllUnWoffEntry(allUnWoffBillEntryIds);
        }
        if (!partWoffBillEntryIds.isEmpty()) {
            this.updatePartWoffEntry(partWoffBillEntryIds);
        }
        String updatesql1 = "update t_ar_busbill a set funwoffnotaxamt=(select sum(funwoffnotaxamt) from t_ar_busbillentry b where a.fid=b.fid),funwoffnotaxlocamt=(select sum(funwoffnotaxlocamt) from t_ar_busbillentry c where a.fid =c.fid),funwofftax=(select sum(funwofftax) from t_ar_busbillentry d where a.fid =d.fid),funwofftaxlocal=(select sum(funwofftaxlocal) from t_ar_busbillentry e where a.fid =e.fid) where fid in (" + StringUtils.join((Object[])needUpgradeBillIds.toArray(), (String)",") + ");";
        DB.execute((DBRoute)new DBRoute("fi"), (String)updatesql1);
    }

    private void updatePartWoffEntry(Set<Long> partWoffBillEntryIds) {
        String qrySql = "select fsrcentryid,famount,flocalamt,ftax,ftaxlocalamt from t_ar_busbillentry where fiswriteoff='0' and fsrcentryid in (" + StringUtils.join((Object[])partWoffBillEntryIds.toArray(), (String)",") + ");";
        DataSet busBillinfo = DB.queryDataSet((String)"BusApUnwoffAmtUpgradePlugin", (DBRoute)new DBRoute("fi"), (String)qrySql);
        busBillinfo = busBillinfo.groupBy(new String[]{"fsrcentryid"}).sum("famount").sum("flocalamt").sum("ftax").sum("ftaxlocalamt").finish();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(8);
        for (Row row1 : busBillinfo) {
            Object[] param = new Object[]{row1.getBigDecimal("famount"), row1.getBigDecimal("flocalamt"), row1.getBigDecimal("ftax"), row1.getBigDecimal("ftaxlocalamt"), row1.getLong("fsrcentryid")};
            updateParams.add(param);
        }
        String updatesql = "update t_ar_busbillentry set funwoffnotaxamt=famount+?,funwoffnotaxlocamt=flocalamt+?,funwofftax=ftax+?,funwofftaxlocal=ftaxlocalamt+? where fentryid = ?;";
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updatesql, updateParams);
        }
    }

    private void updateAllUnWoffEntry(Set<Long> allUnWoffBillEntryIds) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(allUnWoffBillEntryIds.size());
        for (Long id : allUnWoffBillEntryIds) {
            Object[] param = new Object[]{id};
            updateParams.add(param);
        }
        String updateEntrySql = "update t_ar_busbillentry set funwoffnotaxamt=famount,funwoffnotaxlocamt=flocalamt,funwofftax=ftax,funwofftaxlocal=ftaxlocalamt where fentryid = ?;";
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateEntrySql, updateParams);
        }
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

