/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;

public class FinArBillConfirmFieldUpgradeHandle
extends AbstractUpgradeHandle {
    private Map<Object, DynamicObject> precisionMap = new HashMap<Object, DynamicObject>(64);

    protected void upgrade(List<Long> billIds) {
        DataSet entryids;
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ar_finarbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, billIds)});){
            String queryEntrySql = "select fid,fentryid from t_ar_finarbillentry where fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ")";
            entryids = DB.queryDataSet((String)"FinArBillConfirmFieldUpgradeHandle", (DBRoute)DBRouteConst.AR, (String)queryEntrySql);
        }
        HashSet<Long> needUpgradeEntryIds = new HashSet<Long>(64);
        HashSet<Long> needUpgradeIds = new HashSet<Long>(64);
        for (Row entry : entryids) {
            long fid = entry.getLong("fid");
            long entryid = entry.getLong("fentryid");
            needUpgradeIds.add(fid);
            needUpgradeEntryIds.add(entryid);
            if (needUpgradeEntryIds.size() != this.UPGRADE_ENTRY_NUMBER) continue;
            this.updateCfmBaseQty(needUpgradeEntryIds, needUpgradeIds);
            needUpgradeEntryIds.clear();
            needUpgradeIds.clear();
        }
        if (!needUpgradeEntryIds.isEmpty()) {
            this.updateCfmBaseQty(needUpgradeEntryIds, needUpgradeIds);
        }
    }

    private void updateCfmBaseQty(Set<Long> needUpgradeEntryIds, Set<Long> billIds) {
        long entryid;
        HashMap<String, BigDecimal> infoMap;
        DataSet upgradeDatas;
        HashSet<Long> needQueryBaseUnitIds = new HashSet<Long>(64);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ar_finarbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, billIds)});){
            String queryEntrySql = "select fentryid,fconfirmedqty,fquantity,famount,fconfirmedamt,fbaseunitqty,fmeasureunitid,funitcoefficient,fbaseunit from t_ar_finarbillentry where fentryid in (" + StringUtils.join((Object[])needUpgradeEntryIds.toArray(), (String)",") + ")";
            upgradeDatas = DB.queryDataSet((String)"FinArBillConfirmFieldUpgradeHandle", (DBRoute)DBRouteConst.AR, (String)queryEntrySql);
        }
        HashMap<Long, Map<String, BigDecimal>> needUpdateEntryIdToInfoMap = new HashMap<Long, Map<String, BigDecimal>>(64);
        HashMap needResolveBaseUnitEntryInfoMap = new HashMap(64);
        for (Row row : upgradeDatas) {
            infoMap = new HashMap<String, BigDecimal>(8);
            entryid = row.getLong("fentryid");
            BigDecimal e_confirmedamt = row.getBigDecimal("fconfirmedamt");
            BigDecimal e_confirmedqty = row.getBigDecimal("fconfirmedqty");
            BigDecimal e_quantity = row.getBigDecimal("fquantity");
            BigDecimal e_recamount = row.getBigDecimal("famount");
            BigDecimal e_baseunitqty = row.getBigDecimal("fbaseunitqty");
            long measureunitid = row.getLong("fmeasureunitid");
            long baseunitid = row.getLong("fbaseunit");
            BigDecimal e_unitcoefficient = row.getBigDecimal("funitcoefficient");
            if (e_confirmedqty.compareTo(e_quantity) == 0) {
                infoMap.put("e_confirmedbaseqty", e_baseunitqty);
                infoMap.put("e_unconfirmbaseqty", BigDecimal.ZERO);
            } else if (e_confirmedqty.compareTo(BigDecimal.ZERO) == 0) {
                infoMap.put("e_confirmedbaseqty", BigDecimal.ZERO);
                infoMap.put("e_unconfirmbaseqty", e_baseunitqty);
            } else if (measureunitid == baseunitid) {
                infoMap.put("e_confirmedbaseqty", e_confirmedqty);
                infoMap.put("e_unconfirmbaseqty", e_baseunitqty.subtract(e_confirmedqty));
            } else {
                HashMap<String, Number> needResolveBaseUnitInfoMap = new HashMap<String, Number>(8);
                needResolveBaseUnitInfoMap.put("confirmedqty", e_confirmedqty);
                needResolveBaseUnitInfoMap.put("unitcoefficient", e_unitcoefficient);
                needResolveBaseUnitInfoMap.put("baseunit", baseunitid);
                needResolveBaseUnitInfoMap.put("baseunitqty", e_baseunitqty);
                needResolveBaseUnitEntryInfoMap.put(entryid, needResolveBaseUnitInfoMap);
                if (ObjectUtils.isEmpty((Object)this.precisionMap.get(baseunitid))) {
                    needQueryBaseUnitIds.add(baseunitid);
                }
            }
            needUpdateEntryIdToInfoMap.put(entryid, infoMap);
        }
        if (needQueryBaseUnitIds.size() > 0) {
            Map measureunitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"precisionaccount,precision", (QFilter[])new QFilter[]{new QFilter("id", "in", needQueryBaseUnitIds)});
            this.precisionMap.putAll(measureunitMap);
        }
        for (Map.Entry entry : needResolveBaseUnitEntryInfoMap.entrySet()) {
            infoMap = new HashMap(8);
            entryid = (Long)entry.getKey();
            long baseunitId = (Long)((Map)entry.getValue()).get("baseunit");
            BigDecimal confirmedqty = (BigDecimal)((Map)entry.getValue()).get("confirmedqty");
            BigDecimal unitcoefficient = (BigDecimal)((Map)entry.getValue()).get("unitcoefficient");
            BigDecimal baseunitqty = (BigDecimal)((Map)entry.getValue()).get("baseunitqty");
            DynamicObject e_baseunit = this.precisionMap.get(baseunitId);
            BigDecimal e_confirmedbaseqty = !ObjectUtils.isEmpty((Object)e_baseunit) ? UnitConvertHelper.getBaseunitqty((BigDecimal)confirmedqty, (BigDecimal)unitcoefficient, (DynamicObject)e_baseunit) : confirmedqty;
            infoMap.put("e_confirmedbaseqty", e_confirmedbaseqty);
            infoMap.put("e_unconfirmbaseqty", baseunitqty.subtract(e_confirmedbaseqty));
            needUpdateEntryIdToInfoMap.put(entryid, infoMap);
        }
        if (needUpdateEntryIdToInfoMap.size() > 0) {
            this.executeUpdate(needUpdateEntryIdToInfoMap, billIds);
        }
    }

    private void executeUpdate(Map<Long, Map<String, BigDecimal>> updateInfoMap, Set<Long> needUpdateIds) {
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(updateInfoMap.size());
        for (Map.Entry<Long, Map<String, BigDecimal>> m : updateInfoMap.entrySet()) {
            Map<String, BigDecimal> info = m.getValue();
            Object[] param = new Object[]{info.get("e_confirmedbaseqty"), info.get("e_unconfirmbaseqty"), m.getKey()};
            updateFinBillParams.add(param);
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ar_finarbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, needUpdateIds)});){
            String updateSql = "update t_ar_finarbillentry set fconfirmedbaseqty=? ,funconfirmbaseqty=? where fentryid = ?";
            DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateFinBillParams);
        }
    }
}

