/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;

public class FinArBillConfirmQtyUpgradeNewPluginHandle
extends AbstractUpgradeHandle {
    private final List<Long> payPropertyIds = new ArrayList<Long>(8);

    protected void upgrade(List<Long> billIds) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(1024);
        for (Long billId : billIds) {
            Object[] param = new Object[]{billId};
            params.add(param);
        }
        this.preExecuteSql(params);
        ArrayList<Long> arbillIdEntrySet = new ArrayList<Long>(64);
        String queryQtyFinArSql = "select fid from t_ar_finarbill where fpaypropertyid in (" + StringUtils.join((Object[])this.payPropertyIds.toArray(), (String)",") + ") and fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ");";
        DataSet qtyFinArDataSet = DB.queryDataSet((String)"queryqtyfinar", (DBRoute)DBRoute.of((String)"ar"), (String)queryQtyFinArSql);
        HashSet<Long> qtyFinArBillIds = new HashSet<Long>(64);
        for (Row row : qtyFinArDataSet) {
            qtyFinArBillIds.add(row.getLong("fid"));
        }
        if (!qtyFinArBillIds.isEmpty()) {
            String queryEntryIdSql = "select fentryid from t_ar_finarbillentry where famount <> fconfirmedamt and fconfirmedamt <> 0 and fid in (" + StringUtils.join((Object[])qtyFinArBillIds.toArray(), (String)",") + ");";
            DataSet finArEntryDataSet = DB.queryDataSet((String)"queryFinArEntry", (DBRoute)DBRoute.of((String)"ar"), (String)queryEntryIdSql);
            for (Row row : finArEntryDataSet) {
                arbillIdEntrySet.add(row.getLong("fentryid"));
            }
        }
        String queryZeroAmtEntrySql = "select fentryid from t_ar_finarbillentry where famount = 0 and fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ");";
        DataSet finArZeroEntryDataSet = DB.queryDataSet((String)"queryFinArZeroEntry", (DBRoute)DBRoute.of((String)"ar"), (String)queryZeroAmtEntrySql);
        for (Row row : finArZeroEntryDataSet) {
            arbillIdEntrySet.add(row.getLong("fentryid"));
        }
        HashSet<Long> tempFinArEntryIds = new HashSet<Long>(64);
        for (Long arEntryId : arbillIdEntrySet) {
            tempFinArEntryIds.add(arEntryId);
            if (tempFinArEntryIds.size() <= this.UPGRADE_ENTRY_NUMBER) continue;
            this.executeUpgradeLogic(tempFinArEntryIds);
            tempFinArEntryIds.clear();
        }
        if (!tempFinArEntryIds.isEmpty()) {
            this.executeUpgradeLogic(tempFinArEntryIds);
        }
    }

    private void executeUpgradeLogic(Set<Long> finArEntryIds) {
        String queryRevcfmSql = "select fconfirmqty,fsourcebillentryid from t_ar_revcfmbillentry where fsourcebillentryid in (" + StringUtils.join((Object[])finArEntryIds.toArray(), (String)",") + ");";
        DataSet revcfmData = DB.queryDataSet((String)"queryFinArZeroEntry", (DBRoute)DBRoute.of((String)"ar"), (String)queryRevcfmSql);
        revcfmData = revcfmData.groupBy(new String[]{"fsourcebillentryid"}).sum("fconfirmqty").finish();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1024);
        for (Row row : revcfmData) {
            paramList.add(new Object[]{row.getBigDecimal("fconfirmqty"), row.getBigDecimal("fconfirmqty"), row.getLong("fsourcebillentryid")});
        }
        String sql = "update t_ar_finarbillentry set fconfirmedqty = ?, funconfirmqty = fquantity - ? where fentryid = ?;";
        DB.executeBatch((DBRoute)DBRouteConst.AR, (String)sql, paramList);
    }

    private void preExecuteSql(List<Object[]> params) {
        String sql1 = "update t_ar_finarbillentry set fconfirmedqty = fquantity, funconfirmqty = 0 where famount=fconfirmedamt and famount<>0 and fid = ? ;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"ar"), (String)sql1, params);
        String sql2 = "update t_ar_finarbillentry set fconfirmedqty = 0, funconfirmqty = fquantity where fconfirmedamt=0 and famount<>0 and fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"ar"), (String)sql2, params);
    }

    protected void initUpgradeArgs() {
        String querySql = "select fid from t_ar_payproperty where fisbasedonamt = '0';";
        DataSet payPropertyDataSet = DB.queryDataSet((String)"queryPayProerty", (DBRoute)DBRoute.of((String)"ar"), (String)querySql);
        for (Row row : payPropertyDataSet) {
            this.payPropertyIds.add(row.getLong("fid"));
        }
    }

    public String getUpgradeEntryName() {
        return "t_ar_finarbillentry";
    }
}

