/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;

public class FinArTaxLocUpgradePlugin
implements IUpgradeService {
    private static final int MAX_PROCESSNUMBER = 10000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        try {
            this.doUpgrade();
        }
        catch (Exception e) {
            String log = ArApHelper.getStackTraceMessage((Throwable)e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", log);
        }
        return new UpgradeResult(resultMap);
    }

    private void doUpgrade() {
        HashMap<Long, BigDecimal> billToTaxLoc = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, BigDecimal> entryToTaxLoc = new HashMap<Long, BigDecimal>(64);
        ArrayList<Date> queryArgs = new ArrayList<Date>(2);
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        queryArgs.add(beginDate);
        String queryIsTaxSql = "select a.fid,b.fentryid,a.freclocalamt,a.flocalamt,a.ftax,a.fexchangerate,b.freclocalamt as entrytotal,b.flocalamt as entryamount,b.ftax as entrytax from t_ar_finarbill a,t_ar_finarbillentry b where a.fid = b.fid and fbizdate > ? and a.ftax <> 0";
        DataSet allFinDataSet = DB.queryDataSet((String)"FinArTaxLocUpgradePlugin", (DBRoute)DBRoute.of((String)"ar"), (String)queryIsTaxSql, (Object[])queryArgs.toArray());
        for (Row finRow : allFinDataSet) {
            BigDecimal exchangerate = finRow.getBigDecimal("fexchangerate");
            if (exchangerate.compareTo(BigDecimal.ONE) == 0) {
                billToTaxLoc.put(finRow.getLong("fid"), finRow.getBigDecimal("ftax"));
                entryToTaxLoc.put(finRow.getLong("fentryid"), finRow.getBigDecimal("entrytax"));
            } else {
                billToTaxLoc.put(finRow.getLong("fid"), finRow.getBigDecimal("freclocalamt").subtract(finRow.getBigDecimal("flocalamt")));
                entryToTaxLoc.put(finRow.getLong("fentryid"), finRow.getBigDecimal("entrytotal").subtract(finRow.getBigDecimal("entryamount")));
            }
            if (billToTaxLoc.size() == 10000) {
                this.updateBill(billToTaxLoc);
                billToTaxLoc.clear();
            }
            if (entryToTaxLoc.size() != 10000) continue;
            this.updateBillEntry(entryToTaxLoc);
            entryToTaxLoc.clear();
        }
        if (billToTaxLoc.size() > 0) {
            this.updateBill(billToTaxLoc);
        }
        if (entryToTaxLoc.size() > 0) {
            this.updateBillEntry(entryToTaxLoc);
        }
    }

    private void updateBill(Map<Long, BigDecimal> billToTaxLoc) {
        if (billToTaxLoc.size() == 0) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(billToTaxLoc.size());
        for (Map.Entry<Long, BigDecimal> entrySet : billToTaxLoc.entrySet()) {
            Object[] param = new Object[]{entrySet.getValue(), entrySet.getKey()};
            updateFinBillParams.add(param);
        }
        String updateSql = "update t_ar_finarbill a set ftaxlocamt = ? where fid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateFinBillParams);
    }

    private void updateBillEntry(Map<Long, BigDecimal> entryToTaxLoc) {
        if (entryToTaxLoc.size() == 0) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(entryToTaxLoc.size());
        for (Map.Entry<Long, BigDecimal> entrySet : entryToTaxLoc.entrySet()) {
            Object[] param = new Object[]{entrySet.getValue(), entrySet.getKey()};
            updateFinBillParams.add(param);
        }
        String updateSql = "update t_ar_finarbillentry set ftaxlocalamt = ? where fentryid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateFinBillParams);
    }
}

