/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class GLTInvNameUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        boolean success = true;
        String info = "Ar GLTInvName Data Upgrade SUCCESS!";
        try {
            info = this.upgrade();
        }
        catch (Exception e) {
            info = this.getStackTraceMessage(e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", info);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return new UpgradeResult(resultMap);
    }

    private String upgrade() {
        QFilter qf = new QFilter("materiel", "!=", (Object)0);
        qf.or("expenseitem", "!=", (Object)0);
        DynamicObject[] goodslinktaxtypes = BusinessDataServiceHelper.load((String)"ar_goodslinktaxtype", (String)"materiel, expenseitem", (QFilter[])new QFilter[]{qf});
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(goodslinktaxtypes.length);
        for (DynamicObject goodslinktaxtype : goodslinktaxtypes) {
            DynamicObject materiel = goodslinktaxtype.getDynamicObject("materiel");
            DynamicObject expenseitem = goodslinktaxtype.getDynamicObject("expenseitem");
            String invName = ObjectUtils.isEmpty((Object)materiel) ? expenseitem.getLocaleString("name").getLocaleValue() : materiel.getLocaleString("name").getLocaleValue();
            paramList.add(new Object[]{invName, goodslinktaxtype.getPkValue()});
        }
        if (!paramList.isEmpty()) {
            String sql = "update t_ar_goodslinktaxtype set finvname=? where fid=?";
            DB.executeBatch((DBRoute)DBRouteConst.AR, (String)sql, paramList);
        }
        return "success";
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

