/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class LqdDataUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        boolean success = true;
        String info = "Ar Liquidation Data Upgrade SUCCESS!";
        try {
            info = this.upgrade();
        }
        catch (Exception e) {
            info = this.getStackTraceMessage(e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", info);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return new UpgradeResult(resultMap);
    }

    public String upgrade() {
        Object[] param;
        String info = "Ar Liquidation Data Upgrade SUCCESS!";
        String lqdQuerySql = "select fid,fentryid,fsourcebillid,funsettleamt from t_ar_liquidationentry where fpaypropertyid=0";
        DataSet lqdDataSetTemp = DB.queryDataSet((String)"AR.QUERYUPDATELQD", (DBRoute)DBRouteConst.AR, (String)lqdQuerySql);
        DataSet lqdDataSet = lqdDataSetTemp.copy();
        if (lqdDataSetTemp.isEmpty()) {
            info = "No data to upgrade was found.";
            return info;
        }
        DataSet lqdDataSet2 = lqdDataSet.copy();
        HashMap<Long, Long> lqdIdsExist = new HashMap<Long, Long>();
        HashMap<DynamicObject[], DynamicObject[]> srcIdsExist = new HashMap<DynamicObject[], DynamicObject[]>();
        LinkedList<Long> lqdIds = new LinkedList<Long>();
        LinkedList<DynamicObject[]> srcIds = new LinkedList<DynamicObject[]>();
        for (Row row : lqdDataSet) {
            Long fid = row.getLong("fid");
            DynamicObject[] fsourcebillid = row.getLong("fsourcebillid");
            if (!lqdIdsExist.containsKey(fid)) {
                lqdIdsExist.put(fid, fid);
                lqdIds.add(fid);
            }
            if (srcIdsExist.containsKey(fsourcebillid)) continue;
            srcIdsExist.put(fsourcebillid, fsourcebillid);
            srcIds.add(fsourcebillid);
        }
        QFilter filter = new QFilter("id", "in", lqdIds);
        DynamicObject[] arLqdBills = BusinessDataServiceHelper.load((String)"ar_liquidation", (String)"id,exchangerate,basecurrency", (QFilter[])filter.toArray());
        LinkedList<Object[]> lqdLocAmtParams = new LinkedList<Object[]>();
        for (DynamicObject arLqdBill : arLqdBills) {
            DynamicObject[] exchangerate = arLqdBill.getBigDecimal("exchangerate");
            DynamicObject bascur = arLqdBill.getDynamicObject("basecurrency");
            if (bascur == null || exchangerate == null) continue;
            int baseprecision = bascur.getInt("amtprecision");
            DataSet lqdDataSet3 = lqdDataSet2.copy();
            for (Row row : lqdDataSet3) {
                if (row.getLong("fid").longValue() != arLqdBill.getLong("id")) continue;
                BigDecimal lqdlocalamt = row.getBigDecimal("funsettleamt").multiply((BigDecimal)exchangerate).setScale(baseprecision, RoundingMode.HALF_UP);
                param = new Object[]{lqdlocalamt, row.getLong("fid"), row.getLong("fentryid")};
                lqdLocAmtParams.add(param);
            }
        }
        String updateLqdLocAmtSql = "update t_ar_liquidationentry set flqdlocalamt=? where fid=? and fentryid=?";
        if (lqdLocAmtParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateLqdLocAmtSql, lqdLocAmtParams);
        }
        QFilter finarFilter = new QFilter("id", "in", srcIds);
        DynamicObject[] finarBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,payproperty", (QFilter[])finarFilter.toArray());
        LinkedList<Object[]> paypropertyParams = new LinkedList<Object[]>();
        for (DynamicObject finarBill : finarBills) {
            DynamicObject payproperty = finarBill.getDynamicObject("payproperty");
            if (payproperty == null) continue;
            long paypropertyid = payproperty.getLong("id");
            param = new Object[]{paypropertyid, finarBill.getLong("id")};
            paypropertyParams.add(param);
        }
        String updateLqdPaypropertySql = "update t_ar_liquidationentry set fpaypropertyid=? where fsourcebillid=?";
        if (paypropertyParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateLqdPaypropertySql, paypropertyParams);
        }
        info = String.format("Ar Liquidation Data Upgrade flqdlocalamt[%s],fpaypropertyid[%s] SUCCESS!", lqdLocAmtParams.size(), paypropertyParams.size());
        return info;
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

