/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;
import kd.fi.arapcommon.util.EmptyUtils;

public class RevcfmBillConfirmFieldUpgradeHandle
extends AbstractUpgradeHandle {
    private Map<Long, Integer> currencyMap = new HashMap<Long, Integer>(64);
    private Map<Object, DynamicObject> precisionMap = new HashMap<Object, DynamicObject>(64);

    protected void upgrade(List<Long> billIds) {
        Object updateSql;
        Object param;
        ArrayList<Object> updateParams;
        this.buildCurrencyMap();
        String qrySql = "select fid,famount,fconfirmamt,fsourcebilltype from t_ar_revcfmbill where fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ");";
        DataSet upgradeDatas = DB.queryDataSet((String)"RevcfmBillConfirmFieldUpgradeHandle", (DBRoute)DBRouteConst.AR, (String)qrySql);
        HashSet<Long> allConfirmids = new HashSet<Long>(billIds.size());
        HashSet<Long> unConfirmids = new HashSet<Long>(billIds.size());
        HashSet<Long> partConfirmids = new HashSet<Long>(billIds.size());
        HashSet<Long> srcBillTypeIsArIds = new HashSet<Long>(billIds.size());
        HashSet<Long> srcBillTypeIsOtherIds = new HashSet<Long>(billIds.size());
        for (Object row : upgradeDatas) {
            long id = row.getLong("fid");
            BigDecimal confirmamt = row.getBigDecimal("fconfirmamt");
            BigDecimal amount = row.getBigDecimal("famount");
            String srcBillType = row.getString("fsourcebilltype");
            if ("ar_finarbill".equals(srcBillType)) {
                srcBillTypeIsArIds.add(id);
            } else {
                srcBillTypeIsOtherIds.add(id);
            }
            if (confirmamt.compareTo(amount) == 0) {
                allConfirmids.add(id);
                continue;
            }
            if (confirmamt.compareTo(BigDecimal.ZERO) == 0) {
                unConfirmids.add(id);
                continue;
            }
            partConfirmids.add(id);
        }
        if (allConfirmids.size() > 0) {
            updateParams = new ArrayList<Object>(allConfirmids.size());
            for (Long id : allConfirmids) {
                param = new Object[]{id};
                updateParams.add(param);
            }
            updateSql = "update t_ar_revcfmbillentry set fconfirmlocamt = flocalamt,fconfirmbaseqty =fbaseunitqty where fid = ? ";
            if (updateParams.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("fi"), updateSql, updateParams);
            }
        }
        if (unConfirmids.size() > 0) {
            updateParams = new ArrayList(unConfirmids.size());
            for (Long id : unConfirmids) {
                param = new Object[]{id};
                updateParams.add(param);
            }
            updateSql = "update t_ar_revcfmbillentry set fconfirmlocamt = 0,fconfirmbaseqty =0 where fid = ? ";
            if (updateParams.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateSql, updateParams);
            }
        }
        if (partConfirmids.size() > 0) {
            String qryEntryIdSql = "select fentryid from t_ar_revcfmbillentry where fid in (" + StringUtils.join((Object[])partConfirmids.toArray(), (String)",") + ");";
            HashSet partConfirmEntryIds = new HashSet(64);
            DataSet entryids = DB.queryDataSet((String)"RevcfmBillConfirmFieldUpgradeHandle", (DBRoute)DBRouteConst.AR, (String)qryEntryIdSql);
            for (Row entry : entryids) {
                long entryid = entry.getLong("fentryid");
                partConfirmEntryIds.add(entryid);
                if (partConfirmEntryIds.size() != this.UPGRADE_ENTRY_NUMBER) continue;
                this.partCfmUpdate(partConfirmEntryIds);
                partConfirmEntryIds.clear();
            }
            if (!partConfirmEntryIds.isEmpty()) {
                this.partCfmUpdate(partConfirmEntryIds);
            }
        }
        if (srcBillTypeIsArIds.size() > 0) {
            updateParams = new ArrayList(srcBillTypeIsArIds.size());
            for (Long id : srcBillTypeIsArIds) {
                param = new Object[]{id};
                updateParams.add(param);
            }
            updateSql = "update t_ar_revcfmbillentry set funrecqty = 0,funrecbaseqty =0,funrecamt=0,frecqty=fconfirmqty,frecbaseqty=fconfirmbaseqty,frecamt=fconfirmamt where fid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateSql, updateParams);
        }
        if (srcBillTypeIsOtherIds.size() > 0) {
            updateParams = new ArrayList(srcBillTypeIsOtherIds.size());
            for (Long id : srcBillTypeIsOtherIds) {
                param = new Object[]{id};
                updateParams.add(param);
            }
            updateSql = "update t_ar_revcfmbillentry set funrecqty = fconfirmqty,funrecbaseqty =fconfirmbaseqty,funrecamt=fconfirmamt,frecqty=0,frecbaseqty=0,frecamt=0 where fid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateSql, updateParams);
        }
    }

    private void partCfmUpdate(Set<Long> partConfirmEntryIds) {
        String qryEntrySql = "select a.fid,a.fquotation,a.fbasecurrencyid,a.fexchangerate,b.fentryid,b.fconfirmamt,b.fconfirmrate,b.fmeasureunitid,b.fconfirmqty,b.funitcoefficient,b.fbaseunit from t_ar_revcfmbill a left join t_ar_revcfmbillentry b on a.fid=b.fid  where b.fentryid in (" + StringUtils.join((Object[])partConfirmEntryIds.toArray(), (String)",") + ");";
        DataSet partConfirmEntrys = DB.queryDataSet((String)"RevcfmBillConfirmFieldUpgradeHandle", (DBRoute)DBRouteConst.AR, (String)qryEntrySql);
        HashMap needResolveBaseUnitEntryInfoMap = new HashMap(64);
        HashSet<Long> needQueryBaseUnitIds = new HashSet<Long>(64);
        HashMap<Long, Map<String, BigDecimal>> needUpdateEntryIdToInfoMap = new HashMap<Long, Map<String, BigDecimal>>(64);
        for (Row entry : partConfirmEntrys) {
            HashMap<String, BigDecimal> updateEntryInfoMap = new HashMap<String, BigDecimal>(64);
            long entryid = entry.getLong("fentryid");
            String quotation = entry.getString("fquotation");
            long baseCurrencyId = entry.getLong("fbasecurrencyid");
            BigDecimal exchangeRate = entry.getBigDecimal("fexchangerate");
            BigDecimal confirmamt = entry.getBigDecimal("fconfirmamt");
            long measureunitid = entry.getLong("fmeasureunitid");
            long baseunitid = entry.getLong("fbaseunit");
            BigDecimal unitcoefficient = entry.getBigDecimal("funitcoefficient");
            BigDecimal confirmqty = entry.getBigDecimal("fconfirmqty");
            int localPrecision = this.currencyMap.get(baseCurrencyId);
            if (measureunitid == baseunitid) {
                updateEntryInfoMap.put("e_confirmbaseqty", confirmqty);
            } else {
                HashMap<String, Number> needResolveBaseUnitInfoMap = new HashMap<String, Number>(8);
                needResolveBaseUnitInfoMap.put("confirmedqty", confirmqty);
                needResolveBaseUnitInfoMap.put("unitcoefficient", unitcoefficient);
                needResolveBaseUnitInfoMap.put("baseunit", baseunitid);
                needResolveBaseUnitEntryInfoMap.put(entryid, needResolveBaseUnitInfoMap);
                if (ObjectUtils.isEmpty((Object)this.precisionMap.get(baseunitid))) {
                    needQueryBaseUnitIds.add(baseunitid);
                }
            }
            if (this.currencyMap.get(baseCurrencyId) == null || EmptyUtils.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal e_confirmedlocamt = BigDecimal.ZERO;
            e_confirmedlocamt = "1".equals(quotation) ? confirmamt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP) : confirmamt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
            updateEntryInfoMap.put("e_confirmlocamt", e_confirmedlocamt);
            needUpdateEntryIdToInfoMap.put(entryid, updateEntryInfoMap);
        }
        if (needQueryBaseUnitIds.size() > 0) {
            Map measureunitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"precisionaccount,precision", (QFilter[])new QFilter[]{new QFilter("id", "in", needQueryBaseUnitIds)});
            this.precisionMap.putAll(measureunitMap);
        }
        for (Map.Entry row : needResolveBaseUnitEntryInfoMap.entrySet()) {
            long entryid = (Long)row.getKey();
            long baseunitId = (Long)((Map)row.getValue()).get("baseunit");
            BigDecimal confirmedqty = (BigDecimal)((Map)row.getValue()).get("confirmedqty");
            BigDecimal unitcoefficient = (BigDecimal)((Map)row.getValue()).get("unitcoefficient");
            DynamicObject e_baseunit = this.precisionMap.get(baseunitId);
            BigDecimal e_confirmedbaseqty = !ObjectUtils.isEmpty((Object)e_baseunit) ? UnitConvertHelper.getBaseunitqty((BigDecimal)confirmedqty, (BigDecimal)unitcoefficient, (DynamicObject)e_baseunit) : confirmedqty;
            Map updateEntryInfoMap = (Map)needUpdateEntryIdToInfoMap.get(entryid);
            updateEntryInfoMap.put("e_confirmbaseqty", e_confirmedbaseqty);
            needUpdateEntryIdToInfoMap.put(entryid, updateEntryInfoMap);
        }
        if (needUpdateEntryIdToInfoMap.size() > 0) {
            this.updateEntry(needUpdateEntryIdToInfoMap);
        }
    }

    private void updateEntry(Map<Long, Map<String, BigDecimal>> needUpdateEntryIdToInfoMap) {
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(needUpdateEntryIdToInfoMap.size());
        for (Map.Entry<Long, Map<String, BigDecimal>> m : needUpdateEntryIdToInfoMap.entrySet()) {
            Map<String, BigDecimal> info = m.getValue();
            Object[] param = new Object[]{info.get("e_confirmbaseqty"), info.get("e_confirmlocamt"), m.getKey()};
            updateFinBillParams.add(param);
        }
        String updateSql = "update t_ar_revcfmbillentry set fconfirmbaseqty =?,fconfirmlocamt = ? where fentryid = ? ";
        DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateFinBillParams);
    }

    private void buildCurrencyMap() {
        if (this.currencyMap.isEmpty()) {
            String sql = "select fid,FAmtPrecision from T_BD_Currency ";
            DataSet currencyDataSet = DB.queryDataSet((String)"FinArBillConfirmFieldUpgradeHandle", (DBRoute)new DBRoute("sys"), (String)sql, (Object[])new Object[0]);
            for (Row currency : currencyDataSet) {
                Long currencyId = currency.getLong("fid");
                Integer amtPrecision = currency.getInteger("FAmtPrecision");
                this.currencyMap.put(currencyId, amtPrecision);
            }
        }
    }
}

