/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.journal.JournalService;

public class WoffBusBillPushJournalUpdatePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit() && ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        try {
            this.updateAr();
            this.updateAp();
        }
        catch (Exception e) {
            String traceMessage = ArApHelper.getStackTraceMessage((Throwable)e);
            result.setErrorInfo(traceMessage);
            result.setLog(traceMessage);
        }
        return result;
    }

    private void updateAr() throws ParseException {
        String sql = "select FID from T_AR_BUSBILL WHERE FID NOT IN(SELECT FSOURCEBILLID FROM T_AR_JOURNAL WHERE FSOURCEBILLTYPE = 'ar_busbill' and FBIZTYPE = 'BusAdjust' AND FBIZDATE>?) AND FBIZDATE>? and FISADJUST = '1'";
        Date date = new SimpleDateFormat("yyyy-MM-dd").parse("2020-09-01");
        DataSet busBillIdDataSet = DB.queryDataSet((String)"fi.ar.WoffBusBillPushJournalUpdatePlugin", (DBRoute)DBRouteConst.AR, (String)sql, (Object[])new Object[]{date, date});
        int batchCount = 100;
        ArrayList<Long> busBillIds = new ArrayList<Long>(batchCount);
        JournalService journalService = new JournalService();
        for (Row row : busBillIdDataSet) {
            busBillIds.add(row.getLong("FID"));
            if (busBillIds.size() != batchCount) continue;
            DynamicObject[] busBills = BusinessDataServiceHelper.load((Object[])busBillIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ar_busbill"));
            journalService.pushAndSaveJournals(busBills);
            busBillIds.clear();
        }
        if (!busBillIds.isEmpty()) {
            DynamicObject[] busBills = BusinessDataServiceHelper.load((Object[])busBillIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ar_busbill"));
            journalService.pushAndSaveJournals(busBills);
        }
    }

    private void updateAp() throws ParseException {
        String sql = "select FID from T_AP_BUSBILL WHERE FID NOT IN(SELECT FSOURCEBILLID FROM T_AP_JOURNAL WHERE FSOURCEBILLTYPE = 'ap_busbill' and FBIZTYPE = 'BusAdjust' AND FBIZDATE>?) AND FBIZDATE>? and FISADJUST = '1'";
        Date date = new SimpleDateFormat("yyyy-MM-dd").parse("2020-09-01");
        DataSet busBillIdDataSet = DB.queryDataSet((String)"fi.ar.WoffBusBillPushJournalUpdatePlugin", (DBRoute)DBRouteConst.AR, (String)sql, (Object[])new Object[]{date, date});
        int batchCount = 100;
        ArrayList<Long> busBillIds = new ArrayList<Long>(batchCount);
        JournalService journalService = new JournalService();
        for (Row row : busBillIdDataSet) {
            busBillIds.add(row.getLong("FID"));
            if (busBillIds.size() != batchCount) continue;
            DynamicObject[] busBills = BusinessDataServiceHelper.load((Object[])busBillIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ap_busbill"));
            journalService.pushAndSaveJournals(busBills);
            busBillIds.clear();
        }
        if (!busBillIds.isEmpty()) {
            DynamicObject[] busBills = BusinessDataServiceHelper.load((Object[])busBillIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ap_busbill"));
            journalService.pushAndSaveJournals(busBills);
        }
    }
}

