/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.mservice.helper.ArFinVerifyHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public abstract class AbstractArVerifyService
extends AbstractVerifyTemplate {
    protected List<BillVerifyVO> getAsstListVO(DynamicObject[] assts) {
        ArrayList<BillVerifyVO> asstList = new ArrayList<BillVerifyVO>();
        for (DynamicObject asst : assts) {
            DynamicObjectCollection asstEntrys = asst.getDynamicObjectCollection("entry");
            for (DynamicObject asstEntry : asstEntrys) {
                BigDecimal unVerifyQty = asstEntry.getBigDecimal("e_unverifyqty");
                if (unVerifyQty.compareTo(BigDecimal.ZERO) == 0) continue;
                BillVerifyVO vo = new BillVerifyVO();
                vo.setId(asst.getLong("id"));
                vo.setOrgId(asst.getLong("org.id"));
                vo.setBillNo(asst.getString("billno"));
                vo.setBillType("ar_revcfmbill");
                vo.setBizdate(asst.getDate("bizdate"));
                vo.setEntryId(asstEntry.getLong("id"));
                vo.setCurrencyId(asst.getLong("currency.id"));
                vo.setPrice(asstEntry.getBigDecimal("e_actunitprice"));
                vo.setEntryPayableAmt(asstEntry.getBigDecimal("e_confirmamt"));
                vo.setAsstActType(asst.getString("asstacttype"));
                vo.setAsstActId(asst.getLong("asstact.id"));
                vo.setEntryCoreBillNum(asstEntry.getString("e_corebillno"));
                vo.setEntryCoreBillseq(asstEntry.getString("e_corebillentryseq"));
                vo.setEntrySettledAmt(asstEntry.getBigDecimal("e_verifiedamt"));
                vo.setEntryUnSettleAmt(asstEntry.getBigDecimal("e_unverifyamt"));
                vo.setEntryMaterialId(asstEntry.getLong("e_material.id"));
                vo.setEntryMeasureUnitId(asstEntry.getLong("e_measureunit.id"));
                vo.setEntryMeasureUnit(asstEntry.getDynamicObject("e_measureunit"));
                BigDecimal confirmQty = asstEntry.getBigDecimal("e_confirmqty");
                vo.setEntryQty(confirmQty);
                BigDecimal confirmBaseQty = asstEntry.getBigDecimal("e_confirmbaseqty");
                BigDecimal unitCoefficent = asstEntry.getBigDecimal("e_unitcoefficient");
                DynamicObject baseUnit = asstEntry.getDynamicObject("e_material.baseunit");
                if (confirmBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                    confirmBaseQty = unitCoefficent.compareTo(BigDecimal.ONE) == 0 ? confirmQty : UnitConvertHelper.getBaseunitqty((BigDecimal)confirmQty, (BigDecimal)unitCoefficent, (DynamicObject)baseUnit);
                }
                vo.setBaseUnitQty(confirmBaseQty);
                vo.setEntrySettledQty(asstEntry.getBigDecimal("e_verifiedqty"));
                vo.setEntryUnSettleQty(asstEntry.getBigDecimal("e_unverifyqty"));
                vo.setUnitCoefficient(unitCoefficent);
                vo.setEntryBaseUnitId(asstEntry.getLong("e_material.baseunit.id"));
                vo.setEntryBaseUnit(baseUnit);
                vo.setEntrySouBillId(asstEntry.getLong("e_sourcebillentryid"));
                boolean isPresent = asstEntry.getBoolean("e_ispresent");
                vo.setPresent(isPresent);
                vo.setBaseCurrencyId(asst.getLong("basecurrency.id"));
                vo.setQuotation(asst.getString("quotation"));
                vo.setExchangeRate(asst.getBigDecimal("exchangerate"));
                vo.setPrecision(Integer.valueOf(asst.getInt("currency.amtprecision")));
                vo.setBasePrecision(Integer.valueOf(asst.getInt("basecurrency.amtprecision")));
                vo.setAllVerify(asstEntry.getBoolean("e_isallverify"));
                BigDecimal acttaxunitprice = asstEntry.getBigDecimal("e_acttaxunitprice");
                vo.setEntryEntityName(asstEntry.getDataEntityType().getName());
                vo.setEntryMaterialVersion(asstEntry.getLong("e_materialversion.id"));
                vo.setEntryMaterialSpecType(asstEntry.getString("e_material.modelnum") != null ? asstEntry.getString("e_material.modelnum") : "");
                vo.setEntryMaterialAuxProp(asstEntry.getString("e_assistantattr") != null ? asstEntry.getString("e_assistantattr") : "");
                vo.setEntryMaterialConfigNumber(asstEntry.getLong("configuredcode.id"));
                vo.setEntryMaterialTrackNumber(asstEntry.getLong("tracknumber.id"));
                if (isPresent || acttaxunitprice.compareTo(BigDecimal.ZERO) != 0) {
                    vo.setPriceTax(acttaxunitprice);
                } else {
                    DynamicObject bill;
                    QFilter filter;
                    if ("ar_finarbill".equals(asst.getString("sourcebilltype"))) {
                        filter = new QFilter("id", "=", (Object)asstEntry.getLong("e_sourcebillid"));
                        filter.and(new QFilter("entry.id", "=", (Object)asstEntry.getLong("e_sourcebillentryid")));
                        bill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"entry.e_acttaxunitprice", (QFilter[])filter.toArray());
                        vo.setPriceTax(bill.getBigDecimal("entry.e_acttaxunitprice"));
                    }
                    if ("ar_busbill".equals(asst.getString("sourcebilltype"))) {
                        filter = new QFilter("id", "=", (Object)asstEntry.getLong("e_sourcebillid"));
                        filter.and(new QFilter("entry.id", "=", (Object)asstEntry.getLong("e_sourcebillentryid")));
                        bill = QueryServiceHelper.queryOne((String)"ar_busbill", (String)"entry.e_acttaxunitprice", (QFilter[])filter.toArray());
                        vo.setPriceTax(bill.getBigDecimal("entry.e_acttaxunitprice"));
                    }
                }
                asstList.add(vo);
            }
        }
        return asstList;
    }

    protected List<VerifyRecordVO> doVerify(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList, SettleSchemeVO scheme, String settleType) {
        scheme.setSettle(true);
        if (scheme.isAllVerify()) {
            return VerifyServiceHelper.allVerify(mainList, asstList, scheme, settleType);
        }
        return VerifyServiceHelper.verify(mainList, asstList, scheme, settleType);
    }

    protected void afterVerify(List<VerifyRecordVO> resultList, SettleSchemeVO scheme) {
        if (resultList != null && resultList.size() > 0) {
            String settleRelation = this.getSettleRelation();
            if (VerifyRelationEnum.SALOUTWRITTENOFF.getValue().equals(settleRelation) || VerifyRelationEnum.SALRETURNWRITTENOFF.getValue().equals(settleRelation)) {
                scheme.setRedVerifyRecord(true);
            } else {
                scheme.setRedVerifyRecord(false);
            }
            for (VerifyRecordVO result : resultList) {
                result.setSettleRela(settleRelation);
            }
            DynamicObject[] resultArr = VerifyServiceHelper.converVO2Dyn(resultList);
            List<Object> pks = null;
            if (resultArr != null && resultArr.length > 0) {
                pks = VerifyServiceHelper.saveVerifyRecord(resultArr);
            }
            ArrayList<VerifyRecordEntryVO> entryList = new ArrayList<VerifyRecordEntryVO>();
            for (VerifyRecordVO result : resultList) {
                entryList.addAll(result.getVrEntrys());
            }
            scheme.setRecordPks(pks);
            this.disposeAsstBill(entryList, scheme);
            this.disposeMainBill(resultList, scheme);
            if (pks != null && pks.size() > 0 && !VerifyRelationEnum.ARFINSELF.getValue().equals(settleRelation)) {
                VerifyServiceHelper.verifyInvokeCal(pks);
            }
        }
    }

    protected VerifyRecordVO converDyn2VO(DynamicObject result) {
        return VerifyServiceHelper.converDyn2VO(result);
    }

    protected void disposeAsstBill(List<VerifyRecordEntryVO> entryList, SettleSchemeVO scheme) {
        HashSet<Long> billIdSet = new HashSet<Long>(entryList.size());
        for (VerifyRecordEntryVO entryVo : entryList) {
            billIdSet.add(entryVo.getBillId());
        }
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id,org,verifystatus,unverifyamt,exchangerate,amount,sourcebilltype,entry.id,entry.e_amount,entry.e_confirmamt,entry.e_verifiedamt,entry.e_unverifyamt,entry.e_verifiedqty,entry.e_unverifyqty,entry.e_sourcebillid,entry.e_sourcebillentryid,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillid,entry.e_corebillentryseq,entry.e_corebillentryid,entry.e_conbillentity,entry.e_conbillnumber,entry.e_conbillrownum,entry.e_conbillid,entry.e_conbillentryid,entry.e_inventorycost,inventorycost", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        ArrayList<VerifyRecordEntryVO> arPushList = new ArrayList<VerifyRecordEntryVO>(entryList.size());
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(apBills.length);
        HashMap<Long, DynamicObject> billEntryMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject bill : apBills) {
            billMap.put(bill.getLong("id"), bill);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                billEntryMap.put(entry.getLong("id"), entry);
            }
        }
        apBills = null;
        boolean isSettle = scheme.isSettle();
        long startTime3 = System.currentTimeMillis();
        for (VerifyRecordEntryVO entryVO : entryList) {
            long billId = entryVO.getBillId();
            long billEntryId = entryVO.getBillEntryId();
            entryVO.setRevcfmBillId(billId);
            entryVO.setRevcfmBillEntryId(billEntryId);
            BigDecimal settleAmt = entryVO.getSettleAmt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            DynamicObject bill = (DynamicObject)billMap.get(billId);
            DynamicObject asstEntry = (DynamicObject)billEntryMap.get(billEntryId);
            if (asstEntry == null) continue;
            long orgId = bill.getLong("org.id");
            entryVO.setOrgId(orgId);
            BigDecimal settleamt = entryVO.getSettleAmt();
            BigDecimal verifyQty = entryVO.getVerifyQty();
            BigDecimal unverifyamount = bill.getBigDecimal("unverifyamt");
            BigDecimal entryAmount = asstEntry.getBigDecimal("e_confirmamt");
            BigDecimal verifyquantity = asstEntry.getBigDecimal("e_verifiedqty");
            BigDecimal unverifyquantity = asstEntry.getBigDecimal("e_unverifyqty");
            BigDecimal verifyamount = asstEntry.getBigDecimal("e_verifiedamt");
            BigDecimal e_unverifyamount = asstEntry.getBigDecimal("e_unverifyamt");
            if (scheme.isSettle()) {
                verifyquantity = verifyquantity.add(verifyQty);
                if ((unverifyquantity = unverifyquantity.subtract(verifyQty)).compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = BigDecimal.ZERO;
                    verifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.subtract(settleamt);
                    verifyamount = verifyamount.add(settleamt);
                }
            } else {
                verifyquantity = verifyquantity.subtract(verifyQty);
                unverifyquantity = unverifyquantity.add(verifyQty);
                if (verifyquantity.compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = BigDecimal.ZERO;
                    e_unverifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = verifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.add(settleamt);
                }
                if (!scheme.isRedVerifyRecord()) {
                    asstEntry.set("e_inventorycost", (Object)BigDecimal.ZERO);
                }
            }
            bill.set("unverifyamt", (Object)unverifyamount);
            asstEntry.set("e_verifiedqty", (Object)verifyquantity);
            asstEntry.set("e_unverifyqty", (Object)unverifyquantity);
            asstEntry.set("e_verifiedamt", (Object)verifyamount);
            asstEntry.set("e_unverifyamt", (Object)e_unverifyamount);
            if (asstEntry.getLong("e_corebillid") == 0L && asstEntry.getLong("e_corebillentryid") == 0L && scheme.isManual() && scheme.isSettle() && (VerifyRelationEnum.ARSALOUT.getValue().equals(this.getSettleRelation()) || VerifyRelationEnum.ARSALRETURN.getValue().equals(this.getSettleRelation()))) {
                asstEntry.set("e_corebilltype", (Object)entryVO.getMainBillEntity());
                asstEntry.set("e_corebillno", (Object)entryVO.getMainBillNumber());
                asstEntry.set("e_corebillid", (Object)entryVO.getMainBillId());
                asstEntry.set("e_corebillentryseq", (Object)entryVO.getMainBillEntrySeq());
                asstEntry.set("e_corebillentryid", (Object)entryVO.getMainBillEntryId());
                if (StringUtils.isEmpty((String)asstEntry.getString("e_conbillnumber")) && asstEntry.getLong("e_conbillid") == 0L) {
                    asstEntry.set("e_conbillentity", (Object)entryVO.getConBillEntity());
                    asstEntry.set("e_conbillnumber", (Object)entryVO.getConBillNumber());
                    asstEntry.set("e_conbillrownum", (Object)entryVO.getConBillRowNum());
                    asstEntry.set("e_conbillid", (Object)entryVO.getConBillId());
                    asstEntry.set("e_conbillentryid", (Object)entryVO.getConBillEntryId());
                }
            }
            if (!"ar_finarbill".equals(bill.get("sourcebilltype"))) continue;
            entryVO.setBillId(asstEntry.getLong("e_sourcebillid"));
            entryVO.setBillEntryId(asstEntry.getLong("e_sourcebillentryid"));
            arPushList.add(entryVO);
        }
        if (!ObjectUtils.isEmpty(billMap)) {
            for (DynamicObject bill : billMap.values()) {
                bill.set("verifystatus", (Object)VerifyServiceHelper.getBillVerifyStatus(bill));
                if (scheme.isSettle() || scheme.isRedVerifyRecord()) continue;
                bill.set("inventorycost", (Object)BigDecimal.ZERO);
            }
        }
        long endTime3 = System.currentTimeMillis();
        logger.info("loop ar_revcfmbill spend " + (endTime3 - startTime3));
        Collection objColl = billMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
        if (arPushList != null && arPushList.size() != 0) {
            ArFinVerifyHelper.dispose4AsstBill(arPushList, scheme, this.getSettleRelation());
        }
        OpLogServiceHelper.addLog((String)(isSettle ? "verify" : "unverify"), (Object)scheme, (DynamicObject[])objColl.toArray(new DynamicObject[0]), (boolean)false);
    }

    protected String getCalPara() {
        return "SALEUNWRITEOFF";
    }
}

