/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.verify.VerifyServiceFactory;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.service.IManualVerifyService;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.ManualVerifyParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArSalManualVrifyService
implements IManualVerifyService {
    public void manualVerify(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualVerifyParam manualParam) throws KDBizException {
        AbstractVerifyTemplate service = this.getService(manualParam);
        List<BillVerifyVO> mainList = this.getMainVOList(mainRows, manualParam);
        List<BillVerifyVO> asstList = this.getAsstVOList(asstRows, manualParam);
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setAllVerify(manualParam.isAllVerify());
        service.verifyByVO(mainList, asstList, scheme, VerifyModeEnum.MANUAL.getValue());
        manualParam.setRecordPks(scheme.getRecordPks());
    }

    protected List<BillVerifyVO> getMainVOList(DynamicObject[] mainRows, ManualVerifyParam manualParam) {
        ArrayList<BillVerifyVO> mainList = new ArrayList<BillVerifyVO>();
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("main_id"));
            mainEntryIdSet.add(main.getLong("main_entryid"));
        }
        String selector = "id,billentry.id,billentry.qty,billentry.ispresent,billentry.amountandtax,billentry.baseqty,billentry.unverifyqty,billentry.actualtaxprice,billentry.mainbillentity,billentry.mainbillnumber,billentry.mainbillid,billentry.mainbillentryid,billentry.mainbillentryseq,billentry.conbillentity,billentry.conbillnumber,billentry.conbillrownum,billentry.conbillid,billentry.conbillentryid";
        String orderBy = "biztime,billentry.material";
        DataSet mainDS = QueryServiceHelper.queryDataSet((String)"manual_reloadmain", (String)"im_saloutbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIdSet), new QFilter("billstatus", "=", (Object)"C"), new QFilter("billentry.id", "in", mainEntryIdSet)}, (String)orderBy);
        if (mainDS.hasNext()) {
            for (Row dataSetRow : mainDS) {
                for (DynamicObject mainRow : mainRows) {
                    long entryId = mainRow.getLong("main_entryid");
                    if (entryId != dataSetRow.getLong("billentry.id")) continue;
                    BillVerifyVO vo = new BillVerifyVO();
                    vo.setOrgId(manualParam.getOrgId());
                    vo.setAsstActId(manualParam.getSupplierId());
                    vo.setAsstActType("bd_customer");
                    vo.setId(mainRow.getLong("main_id"));
                    vo.setBillNo(mainRow.getString("main_billno"));
                    vo.setCurrencyId(mainRow.getLong("main_currency.id"));
                    vo.setBizdate(mainRow.getDate("main_bizdate"));
                    vo.setPrice(mainRow.getBigDecimal("main_unitprice"));
                    vo.setEntryUnSettleQty(mainRow.getBigDecimal("main_curverifyqty"));
                    vo.setEntryUnSettleAmt(mainRow.getBigDecimal("main_curverifyamt"));
                    vo.setEntryId(entryId);
                    vo.setEntryMaterialId(mainRow.getLong("main_material.id"));
                    vo.setUnitCoefficient(mainRow.getBigDecimal("main_convertrate"));
                    vo.setEntryMeasureUnitId(mainRow.getLong("main_measureunit.id"));
                    vo.setEntryMeasureUnit(mainRow.getDynamicObject("main_measureunit"));
                    vo.setEntryBaseUnitId(mainRow.getLong("main_baseunit.id"));
                    vo.setEntryBaseUnit(mainRow.getDynamicObject("main_baseunit"));
                    vo.setEntryQty(dataSetRow.getBigDecimal("billentry.qty"));
                    vo.setBaseUnitQty(dataSetRow.getBigDecimal("billentry.baseqty"));
                    vo.setEntryPayableAmt(dataSetRow.getBigDecimal("billentry.amountandtax"));
                    BigDecimal curVerifyQty = mainRow.getBigDecimal("main_curverifyqty");
                    BigDecimal remainQty = dataSetRow.getBigDecimal("billentry.unverifyqty");
                    if (remainQty.abs().compareTo(curVerifyQty.abs()) < 0) {
                        curVerifyQty = remainQty;
                    }
                    vo.setEntryUnSettleQty(curVerifyQty);
                    vo.setBillType("im_saloutbill");
                    vo.setPresent(dataSetRow.getBoolean("billentry.ispresent").booleanValue());
                    vo.setQuotation(mainRow.getString("main_quotation"));
                    vo.setExchangeRate(mainRow.getBigDecimal("main_exchangerate"));
                    vo.setBaseCurrencyId(mainRow.getLong("main_basecurrency.id"));
                    vo.setPriceTax(dataSetRow.getBigDecimal("billentry.actualtaxprice"));
                    vo.setPrecision(Integer.valueOf(mainRow.getInt("main_currency.amtprecision")));
                    vo.setBasePrecision(Integer.valueOf(mainRow.getInt("main_basecurrency.amtprecision")));
                    vo.setEntryEntityName(mainRow.getDataEntityType().getName());
                    vo.setEntryMaterialVersion(mainRow.getLong("main_materialversion.id"));
                    vo.setEntryMaterialSpecType(mainRow.getString("main_modelnum"));
                    vo.setEntryMaterialAuxProp(mainRow.getString("main_assistantattr"));
                    vo.setEntryMaterialConfigNumber(mainRow.getLong("main_configuredcode.id"));
                    vo.setEntryMaterialTrackNumber(mainRow.getLong("main_tracknumber.id"));
                    vo.setMainBillEntity(dataSetRow.getString("billentry.mainbillentity"));
                    vo.setMainBillNumber(dataSetRow.getString("billentry.mainbillnumber"));
                    vo.setMainBillId(dataSetRow.getLong("billentry.mainbillid").longValue());
                    vo.setMainBillEntryId(dataSetRow.getLong("billentry.mainbillentryid").longValue());
                    vo.setMainBillEntrySeq(dataSetRow.getLong("billentry.mainbillentryseq").longValue());
                    vo.setConBillEntity(dataSetRow.getString("billentry.conbillentity"));
                    vo.setConBillNumber(dataSetRow.getString("billentry.conbillnumber"));
                    vo.setConBillRowNum(dataSetRow.getString("billentry.conbillrownum"));
                    vo.setConBillId(dataSetRow.getLong("billentry.conbillid").longValue());
                    vo.setConBillEntryId(dataSetRow.getLong("billentry.conbillentryid").longValue());
                    mainList.add(vo);
                }
            }
        }
        return mainList;
    }

    protected List<BillVerifyVO> getAsstVOList(DynamicObject[] asstRows, ManualVerifyParam manualParam) {
        ArrayList<BillVerifyVO> asstList = new ArrayList<BillVerifyVO>();
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstEntryIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            asstBillIdSet.add(asst.getLong("asst_id"));
            asstEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        String selector = "id,asstacttype,entry.id,entry.e_confirmamt,entry.e_confirmqty,entry.e_acttaxunitprice,entry.e_confirmbaseqty,entry.e_unverifyqty,entry.e_unverifyamt,entry.e_ispresent,sourcebilltype,entry.e_sourcebillid,entry.e_sourcebillentryid";
        DataSet asstDS = QueryServiceHelper.queryDataSet((String)"manual_reloadasst", (String)"ar_revcfmbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIdSet), new QFilter("entry.id", "in", asstEntryIdSet), new QFilter("billstatus", "=", (Object)"C")}, (String)"bizdate,entry.e_material");
        if (asstDS.hasNext()) {
            for (Row dataSetRow : asstDS) {
                for (DynamicObject asstRow : asstRows) {
                    long entryId = asstRow.getLong("asst_entryid");
                    if (entryId != dataSetRow.getLong("entry.id")) continue;
                    BillVerifyVO vo = new BillVerifyVO();
                    vo.setOrgId(manualParam.getOrgId());
                    vo.setAsstActType("bd_customer");
                    vo.setAsstActId(manualParam.getSupplierId());
                    vo.setEntryId(entryId);
                    vo.setBillType("ar_revcfmbill");
                    vo.setId(asstRow.getLong("asst_id"));
                    vo.setCurrencyId(asstRow.getLong("asst_currency.id"));
                    vo.setBillNo(asstRow.getString("asst_billno"));
                    vo.setBizdate(asstRow.getDate("asst_bizdate"));
                    vo.setEntryUnSettleAmt(asstRow.getBigDecimal("asst_curverifyamt"));
                    vo.setEntryMaterialId(asstRow.getLong("asst_material.id"));
                    vo.setEntryMeasureUnitId(asstRow.getLong("asst_measureunit.id"));
                    vo.setEntryMeasureUnit(asstRow.getDynamicObject("asst_measureunit"));
                    vo.setEntryBaseUnitId(asstRow.getLong("asst_baseunit.id"));
                    DynamicObject baseUnit = asstRow.getDynamicObject("asst_baseunit");
                    BigDecimal convertRate = asstRow.getBigDecimal("asst_convertrate");
                    vo.setEntryBaseUnit(baseUnit);
                    vo.setUnitCoefficient(convertRate);
                    vo.setPrice(asstRow.getBigDecimal("asst_unitprice"));
                    vo.setEntryUnSettleQty(asstRow.getBigDecimal("asst_curverifyqty"));
                    vo.setEntryPayableAmt(dataSetRow.getBigDecimal("entry.e_confirmamt"));
                    BigDecimal confirmQty = dataSetRow.getBigDecimal("entry.e_confirmqty");
                    vo.setEntryQty(confirmQty);
                    BigDecimal confirmBaseQty = dataSetRow.getBigDecimal("entry.e_confirmbaseqty");
                    if (confirmBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                        confirmBaseQty = convertRate.compareTo(BigDecimal.ONE) == 0 ? confirmQty : UnitConvertHelper.getBaseunitqty((BigDecimal)confirmQty, (BigDecimal)convertRate, (DynamicObject)baseUnit);
                    }
                    vo.setBaseUnitQty(confirmBaseQty);
                    BigDecimal curVerifyQty = asstRow.getBigDecimal("asst_curverifyqty");
                    BigDecimal remainQty = dataSetRow.getBigDecimal("entry.e_unverifyqty");
                    if (remainQty.abs().compareTo(curVerifyQty.abs()) < 0) {
                        curVerifyQty = remainQty;
                    }
                    vo.setEntryUnSettleQty(curVerifyQty);
                    vo.setPresent(dataSetRow.getBoolean("entry.e_ispresent").booleanValue());
                    vo.setQuotation(asstRow.getString("asst_quotation"));
                    vo.setExchangeRate(asstRow.getBigDecimal("asst_exchangerate"));
                    vo.setBaseCurrencyId(asstRow.getLong("asst_basecurrency.id"));
                    vo.setPrecision(Integer.valueOf(asstRow.getInt("asst_currency.amtprecision")));
                    vo.setBasePrecision(Integer.valueOf(asstRow.getInt("asst_basecurrency.amtprecision")));
                    vo.setEntryEntityName(asstRow.getDataEntityType().getName());
                    BigDecimal atup = dataSetRow.getBigDecimal("entry.e_acttaxunitprice");
                    vo.setEntryMaterialVersion(asstRow.getLong("asst_materialversion.id"));
                    vo.setEntryMaterialSpecType(asstRow.getString("asst_modelnum"));
                    vo.setEntryMaterialAuxProp(asstRow.getString("asst_assistantattr"));
                    vo.setEntryMaterialConfigNumber(asstRow.getLong("asst_configuredcode.id"));
                    vo.setEntryMaterialTrackNumber(asstRow.getLong("asst_tracknumber.id"));
                    if (atup.compareTo(BigDecimal.ZERO) != 0) {
                        vo.setPriceTax(atup);
                    } else {
                        DynamicObject bill;
                        QFilter filter;
                        if ("ar_finarbill".equals(dataSetRow.getString("sourcebilltype"))) {
                            filter = new QFilter("id", "=", (Object)dataSetRow.getLong("entry.e_sourcebillid"));
                            filter.and(new QFilter("entry.id", "=", (Object)dataSetRow.getLong("entry.e_sourcebillentryid")));
                            bill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"entry.e_acttaxunitprice", (QFilter[])filter.toArray());
                            vo.setPriceTax(bill.getBigDecimal("entry.e_acttaxunitprice"));
                        }
                        if ("ar_busbill".equals(dataSetRow.getString("sourcebilltype"))) {
                            filter = new QFilter("id", "=", (Object)dataSetRow.getLong("entry.e_sourcebillid"));
                            filter.and(new QFilter("entry.id", "=", (Object)dataSetRow.getLong("entry.e_sourcebillentryid")));
                            bill = QueryServiceHelper.queryOne((String)"ar_busbill", (String)"entry.e_acttaxunitprice", (QFilter[])filter.toArray());
                            vo.setPriceTax(bill.getBigDecimal("entry.e_acttaxunitprice"));
                        }
                    }
                    asstList.add(vo);
                }
            }
        }
        return asstList;
    }

    protected AbstractVerifyTemplate getService(ManualVerifyParam manualParam) {
        return VerifyServiceFactory.getService(manualParam.getVerifyRelation());
    }
}

