/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.verify;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.helper.ViewverHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.mservice.verify.ArSaloutVerifyService;
import kd.fi.ar.mservice.verify.ArSalreturnVerifyService;
import kd.fi.ar.mservice.verify.VerifyServiceFactory;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.service.IAutoVerifyService;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArSaloutAutoVerifyService
implements IAutoVerifyService {
    private static final Log logger = LogFactory.getLog(ArSaloutAutoVerifyService.class);
    private static final int BIZDIRECTION_IN = 0;
    private static final int BIZDIRECTION_OUT = 1;
    protected static final String MAIN_PURINBILL = "im_saloutbill";
    private String mainEntity;
    private Set<Long> botpIds;

    public ArSaloutAutoVerifyService() {
    }

    public ArSaloutAutoVerifyService(String mainEntity, Set<Long> botpIds) {
        this.mainEntity = mainEntity;
        this.botpIds = botpIds;
    }

    public void autoVerify(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        DynamicObject[] assts;
        DynamicObject[] mains;
        SettleSchemeVO scheme = new SettleSchemeVO();
        if (isMain) {
            mains = objArr;
            assts = this.getAsstObjs(objArr, scheme);
        } else {
            assts = objArr;
            mains = this.getMainObjs(objArr, scheme);
        }
        this.autoVerify(mains, assts, scheme);
    }

    public void autoVerify(Set<Long> mainIds, Set<Long> asstIds, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(mainIds) || ObjectUtils.isEmpty(asstIds) || ObjectUtils.isEmpty((Object)scheme)) {
            logger.info("ArSaloutAutoVerifyService autoVerify param is null;return;");
            return;
        }
        DynamicObject[] mains = BusinessDataServiceHelper.load((String)this.mainEntity, (String)this.getSalSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", mainIds), new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE)});
        DynamicObject[] assts = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)this.getArSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        this.autoVerify(mains, assts, scheme);
    }

    protected void autoVerify(DynamicObject[] mains, DynamicObject[] assts, SettleSchemeVO scheme) {
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            if (scheme.isOnlyByCoreBill() && !SystemParameterHelper.getParameterBoolean((long)assts[0].getLong("org.id"), (String)"ar_014")) {
                logger.info("ArSaloutAutoVerifyService not support verify by core bill.");
                return;
            }
            ArrayList<DynamicObject> inBills = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> outBills = new ArrayList<DynamicObject>();
            for (DynamicObject main : mains) {
                Long invschemePK = main.getDynamicObject("invscheme").getLong("id");
                DynamicObject invscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invschemePK, (String)"im_invscheme");
                int direction = invscheme.getDynamicObject("transceivertype").getInt("bizdirection");
                if (0 == direction) {
                    inBills.add(main);
                    continue;
                }
                outBills.add(main);
            }
            if (inBills.size() > 0) {
                this.getService(0).verify(inBills.toArray(new DynamicObject[0]), assts, scheme, VerifyModeEnum.AUTO.getValue());
            }
            if (outBills.size() > 0) {
                this.getService(1).verify(outBills.toArray(new DynamicObject[0]), assts, scheme, VerifyModeEnum.AUTO.getValue());
            }
        }
    }

    protected AbstractVerifyTemplate getService(int direction) {
        if (0 == direction) {
            return new ArSaloutVerifyService();
        }
        return new ArSalreturnVerifyService();
    }

    private DynamicObject[] getMainObjs(DynamicObject[] objArr, SettleSchemeVO scheme) {
        HashSet<String> coreBillNoSet = new HashSet<String>();
        HashSet<Long> coreBillEntrySeqSet = new HashSet<Long>(objArr.length);
        for (DynamicObject obj : objArr) {
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                String coreBillno = entry.getString("e_corebillno");
                if (ObjectUtils.isEmpty((Object)coreBillno)) continue;
                coreBillNoSet.add(coreBillno);
                coreBillEntrySeqSet.add(entry.getLong("e_corebillentryseq"));
            }
        }
        QFilter filter = null;
        if (!ObjectUtils.isEmpty(this.botpIds)) {
            filter = new QFilter("id", "in", this.botpIds);
            filter.and("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
            scheme.setOnlyByBotp(true);
        } else if (coreBillNoSet.size() > 0 && coreBillEntrySeqSet.size() > 0) {
            QFilter coreBillFilter = new QFilter("billentry.mainbillnumber", "in", coreBillNoSet);
            coreBillFilter.and("billentry.mainbillentryseq", "in", coreBillEntrySeqSet);
            coreBillFilter.and("billstatus", "=", (Object)"C");
            filter = coreBillFilter;
            filter.and("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
            scheme.setOnlyByCoreBill(true);
        }
        if (filter != null) {
            DynamicObject[] mainBills = BusinessDataServiceHelper.load((String)this.mainEntity, (String)this.getSalSelector(), (QFilter[])new QFilter[]{filter});
            return mainBills;
        }
        return null;
    }

    private DynamicObject[] getAsstObjs(DynamicObject[] objArr, SettleSchemeVO scheme) {
        return null;
    }

    public void unAutoVerify(Object[] pks, boolean isMain) throws KDBizException {
        String entityName = !isMain ? "ar_revcfmbill" : MAIN_PURINBILL;
        this.unAutoVerifyByEntity(pks, entityName);
    }

    public void unAutoVerifyByEntity(Object[] pks, String entityName) throws KDBizException {
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"unAutoVerify");){
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("/BBRH+122=39");
            appLogInfo.setBizObjID("ar_verifyrecord");
            appLogInfo.setOpName("arunAutoVerify");
            Set verifyRecordPKs = ViewverHelper.getBillVerifyRecordPKs((Object[])pks, (String)entityName);
            if (verifyRecordPKs.isEmpty()) {
                appLogInfo.setOpDescription("no records need to unverify ");
                return;
            }
            if (!CommonVerifyServiceHelper.isFiVerifyRecord((Set)verifyRecordPKs, (boolean)true)) {
                appLogInfo.setOpDescription("not fi verify ");
                return;
            }
            try {
                DynamicObject[] results = this.getVerifyRecords(new QFilter("id", "in", (Object)verifyRecordPKs), "ar_verifyrecord");
                appLogInfo.setOpDescription(results.length + " records need to unverify " + pks[0]);
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
                for (DynamicObject result : results) {
                    if (!result.getBoolean("isvoucher")) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"ArSaloutAutoVerifyService_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
                }
                Map<String, List<DynamicObject>> map = VerifyServiceHelper.classfyByRelation(results);
                for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
                    AbstractVerifyTemplate service = VerifyServiceFactory.getService(entry.getKey());
                    DynamicObject[] verifyRecords = entry.getValue().toArray(new DynamicObject[0]);
                    service.unVerify(verifyRecords);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject[] getVerifyRecords(QFilter filter, String entity) {
        DynamicObject[] results = BusinessDataServiceHelper.load((String)entity, (String)"org,billid,billno,billtype,billentryid,qty,measureunit,verifyqty,verifybaseqty,payableamount,verifyamount,verifytype,verifyrelation,isvoucher,e_billtype,e_qty,e_measureunit,e_verifyqty,e_verifybaseqty,e_payableamount,e_verifyamount,e_billid,e_billno,e_billentryid,currency,e_currency,verifytaxamount,e_verifytaxamount", (QFilter[])filter.toArray());
        return results;
    }

    protected String getArSelector() {
        return "org,asstacttype,asstact,currency,basecurrency,quotation,exchangerate,e_isallverify,billno,e_material,e_measureunit,e_confirmqty,e_baseunitqty,e_confirmbaseqty,bizdate,e_verifiedamt,e_unverifyamt,e_actunitprice,e_acttaxunitprice,e_quantity,e_verifiedqty,e_ispresent,e_baseunit,e_baseunitqty,e_unitcoefficient,e_confirmamt,e_corebillno,e_corebillentryseq,e_unverifyqty,sourcebilltype,e_sourcebillid,e_sourcebillentryid,e_materialversion,e_spectype,e_assistantattr,configuredcode,tracknumber";
    }

    protected String getSalSelector() {
        return "id,org,invscheme.transceivertype,billno,settlecurrency,currency,quotation,exchangerate,biztype,biztime,customer,billentry.actualprice,billentry.actualtaxprice,billentry.id,billentry.material,billentry.qty,billentry.amount,billentry.ispresent,billentry.mainbillnumber,billentry.baseqty,billentry.unverifyqty,billentry.unit,billentry.baseunit,billentry.entrysettleorg,billentry.mainbillentryseq,billentry.mversion,billentry.material.masterid.modelnum,billentry.auxpty,billentry.configuredcode,billentry.tracknumber,billentry.settlecustomer";
    }
}

