/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.mservice.verify.AbstractArVerifyService;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class ArSaloutVerifyService
extends AbstractArVerifyService {
    protected List<BillVerifyVO> getMainListVO(DynamicObject[] mains) {
        ArrayList<BillVerifyVO> mainList = new ArrayList<BillVerifyVO>();
        HashMap<String, BigDecimal> unitrateCache = new HashMap<String, BigDecimal>();
        for (DynamicObject main : mains) {
            BigDecimal mainAmount = BigDecimal.ZERO;
            DynamicObjectCollection mainEntrys = main.getDynamicObjectCollection("billentry");
            for (DynamicObject mainEntry : mainEntrys) {
                mainAmount = mainAmount.add(mainEntry.getBigDecimal("amount"));
            }
            for (DynamicObject mainEntry : mainEntrys) {
                if (BigDecimal.ZERO.compareTo(mainEntry.getBigDecimal("unverifyqty")) == 0) continue;
                BillVerifyVO vo = new BillVerifyVO();
                vo.setId(main.getLong("id"));
                vo.setOrgId(mainEntry.getLong("entrysettleorg.id"));
                vo.setBillNo(main.getString("billno"));
                vo.setCurrencyId(main.getLong("settlecurrency.id"));
                vo.setBillType(main.getDataEntityType().getName());
                vo.setBizdate(main.getDate("biztime"));
                vo.setPayableAmt(mainAmount);
                vo.setAsstActType("bd_customer");
                Long entryCustomerId = mainEntry.getLong("settlecustomer.id");
                if (entryCustomerId == null || entryCustomerId == 0L) {
                    vo.setAsstActId(main.getLong("customer.id"));
                } else {
                    vo.setAsstActId(entryCustomerId.longValue());
                }
                vo.setEntryId(mainEntry.getLong("id"));
                BigDecimal amount = mainEntry.getBigDecimal("amount");
                vo.setEntryPayableAmt(amount);
                vo.setEntryUnSettleAmt(amount);
                vo.setEntryMaterialId(mainEntry.getLong("material.masterid.id"));
                String key = vo.getEntryMaterialId() + "-" + mainEntry.getLong("unit.id") + "-" + mainEntry.getLong("baseunit.id");
                BigDecimal unitrate = (BigDecimal)unitrateCache.get(key);
                if (unitrate == null) {
                    unitrate = UnitConvertHelper.getUnitRateConv((Long)vo.getEntryMaterialId(), (Long)mainEntry.getLong("unit.id"), (Long)mainEntry.getLong("baseunit.id"));
                    unitrateCache.put(key, unitrate);
                }
                vo.setUnitCoefficient(unitrate);
                BigDecimal qty = mainEntry.getBigDecimal("qty");
                vo.setEntryQty(qty);
                vo.setBaseUnitQty(mainEntry.getBigDecimal("baseqty"));
                vo.setPrice(mainEntry.getBigDecimal("actualprice"));
                vo.setEntryMeasureUnitId(mainEntry.getLong("unit.id"));
                vo.setEntryMeasureUnit(mainEntry.getDynamicObject("unit"));
                vo.setEntryBaseUnitId(mainEntry.getLong("baseunit.id"));
                vo.setEntryBaseUnit(mainEntry.getDynamicObject("baseunit"));
                vo.setEntryUnSettleQty(mainEntry.getBigDecimal("unverifyqty"));
                vo.setPresent(mainEntry.getBoolean("ispresent"));
                vo.setBaseCurrencyId(main.getLong("currency.id"));
                vo.setQuotation(main.getString("quotation"));
                vo.setExchangeRate(main.getBigDecimal("exchangerate"));
                vo.setEntryCoreBillNum(mainEntry.getString("mainbillnumber"));
                vo.setEntryCoreBillseq(mainEntry.getString("mainbillentryseq"));
                vo.setPriceTax(mainEntry.getBigDecimal("actualtaxprice"));
                vo.setPrecision(Integer.valueOf(main.getInt("settlecurrency.amtprecision")));
                vo.setBasePrecision(Integer.valueOf(main.getInt("currency.amtprecision")));
                vo.setEntryMaterialVersion(mainEntry.getLong("mversion.id"));
                vo.setEntryMaterialSpecType(mainEntry.getString("material.masterid.modelnum") != null ? mainEntry.getString("material.masterid.modelnum") : "");
                vo.setEntryMaterialAuxProp(mainEntry.getString("auxpty") != null ? mainEntry.getString("auxpty") : "");
                vo.setEntryMaterialConfigNumber(mainEntry.getLong("configuredcode.id"));
                vo.setEntryMaterialTrackNumber(mainEntry.getLong("tracknumber.id"));
                vo.setEntryEntityName(mainEntry.getDataEntityType().getName());
                mainList.add(vo);
            }
        }
        return mainList;
    }

    protected void disposeMainBill(List<VerifyRecordVO> voList, SettleSchemeVO scheme) {
        if (voList != null && voList.size() > 0) {
            ArrayList<Long> revcfmBillIds = new ArrayList<Long>(16);
            ArrayList<Long> revcfmBillEntryIds = new ArrayList<Long>(16);
            HashMap<Long, Boolean> isVerifyByBotpMap = new HashMap<Long, Boolean>(16);
            HashMap<Long, Long> logisticBillIds = new HashMap<Long, Long>(16);
            ArrayList saloutBillIds = new ArrayList(16);
            for (VerifyRecordVO verifyRecordVO : voList) {
                List list = verifyRecordVO.getVrEntrys();
                for (VerifyRecordEntryVO entryVo : list) {
                    revcfmBillIds.add(entryVo.getRevcfmBillId());
                    revcfmBillEntryIds.add(entryVo.getRevcfmBillEntryId());
                }
            }
            if (!scheme.isSettle()) {
                Map upBillMaps = BOTPHelper.loadNearUpBillIds((String)"ar_revcfmbill", (String)"entry", (Long[])revcfmBillIds.toArray(new Long[0]), (Long[])revcfmBillEntryIds.toArray(new Long[0]), (String)"im_saloutbill");
                if (upBillMaps.size() == 0) {
                    for (Long l : revcfmBillIds) {
                        isVerifyByBotpMap.put(l, false);
                    }
                } else {
                    for (Map.Entry entry : upBillMaps.entrySet()) {
                        saloutBillIds.addAll((Collection)entry.getValue());
                    }
                    if (saloutBillIds.size() > 0) {
                        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"im_saloutbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", saloutBillIds), new QFilter("billentry.logisticsbill", "=", (Object)Boolean.TRUE)});
                        for (DynamicObject saloutBill : dynamicObjectCollection) {
                            logisticBillIds.put(saloutBill.getLong("id"), saloutBill.getLong("id"));
                        }
                        for (Map.Entry entrySet : upBillMaps.entrySet()) {
                            boolean isVerifyByBotp = true;
                            List upSalOutBillIds = (List)entrySet.getValue();
                            for (Long id : upSalOutBillIds) {
                                if (logisticBillIds.get(id) == null) continue;
                                isVerifyByBotp = false;
                                break;
                            }
                            isVerifyByBotpMap.put((Long)entrySet.getKey(), isVerifyByBotp);
                        }
                    }
                }
            }
            ArrayList<Long> orgIds = new ArrayList<Long>(8);
            for (VerifyRecordVO verifyRecordVO : voList) {
                orgIds.add(verifyRecordVO.getOrgId());
            }
            Map map = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, orgIds, (String)"ar_005");
            Map map2 = BOTPHelper.loadNearUpBillIds((String)"ar_revcfmbill", (String)"entry", (Long[])revcfmBillIds.toArray(new Long[0]), (Long[])revcfmBillEntryIds.toArray(new Long[0]), (String)"ar_finarbill");
            ArrayList<Map<String, Object>> disposeList = new ArrayList<Map<String, Object>>(voList.size());
            for (VerifyRecordVO vo : voList) {
                Object ar_005;
                HashMap<String, Object> rowMap = new HashMap<String, Object>(64);
                rowMap.put("entity", vo.getBillType());
                long orgId = vo.getOrgId();
                rowMap.put("orgid", orgId);
                long mainBillId = vo.getMainBillId();
                rowMap.put("pk", mainBillId);
                rowMap.put("entrypk", vo.getMainBillEntryId());
                rowMap.put("measureunit", vo.getMeasureunitId());
                rowMap.put("verifyqty", vo.getVerifyQty());
                rowMap.put("verifybaseqty", vo.getVerifyBaseQty());
                boolean needDisposeRemain = !VerifyModeEnum.AUTO.getValue().equals(vo.getSettleType());
                rowMap.put("needDisposeRemain", needDisposeRemain);
                rowMap.put("verifyrelation", this.getSettleRelation());
                rowMap.put("verifytype", vo.getSettleType());
                rowMap.put("verifyamt", vo.getVerifyAmt());
                String verifyRelation = vo.getSettleRela();
                if (VerifyRelationEnum.SALOUTWRITTENOFF.getValue().equals(verifyRelation) || VerifyRelationEnum.SALSELF.getValue().equals(verifyRelation) || VerifyRelationEnum.SALRETURNWRITTENOFF.getValue().equals(verifyRelation)) {
                    rowMap.put("confirmamt", BigDecimal.ZERO);
                } else {
                    rowMap.put("confirmamt", ((VerifyRecordEntryVO)vo.getVrEntrys().get(0)).getSettleAmt());
                }
                if (scheme.isRedVerifyRecord()) {
                    rowMap.put("iswrittenoffverify", Boolean.TRUE);
                } else {
                    rowMap.put("iswrittenoffverify", Boolean.FALSE);
                }
                List vrEntrys = vo.getVrEntrys();
                ArrayList asstDataList = new ArrayList(vrEntrys.size());
                for (VerifyRecordEntryVO entryVO : vrEntrys) {
                    HashMap<String, Object> asstData = new HashMap<String, Object>();
                    Long revcfmId = entryVO.getRevcfmBillId();
                    Long revcfmBillEntryId = entryVO.getRevcfmBillEntryId();
                    asstData.put("asstentity", entryVO.getBillType());
                    asstData.put("asstentrypk", revcfmBillEntryId);
                    asstData.put("asstmeasureunit", entryVO.getMeasureunitId());
                    asstData.put("asstverifyqty", entryVO.getVerifyQty());
                    asstData.put("asstverifybaseqty", entryVO.getVerifyBaseQty());
                    if (map2.containsKey(revcfmId)) {
                        asstData.put("hasfinar", Boolean.TRUE);
                    } else {
                        asstData.put("hasfinar", Boolean.FALSE);
                    }
                    asstDataList.add(asstData);
                    if (scheme.isSettle()) continue;
                    boolean isVerifyByBotp = isVerifyByBotpMap.getOrDefault(revcfmId, true);
                    rowMap.put("isbotp", isVerifyByBotp);
                }
                rowMap.put("asstdata", asstDataList);
                if (scheme.isSettle()) {
                    rowMap.put("isbotp", scheme.isOnlyByBotp());
                }
                if ((ar_005 = map.get(orgId)) != null && !((Boolean)ar_005).booleanValue()) {
                    rowMap.put("noupdjoinqty", Boolean.TRUE);
                } else {
                    rowMap.put("noupdjoinqty", Boolean.FALSE);
                }
                disposeList.add(rowMap);
            }
            VerifyServiceHelper.invokeDisposeScmc(voList, disposeList, scheme);
        }
    }

    protected String getSettleRelation() {
        return VerifyRelationEnum.ARSALOUT.getValue();
    }
}

