/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.verify.ArSalManualVrifyService;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.ManualVerifyParam;

public class ArSelfManualVerifyService
extends ArSalManualVrifyService {
    @Override
    protected List<BillVerifyVO> getMainVOList(DynamicObject[] mainRows, ManualVerifyParam manualParam) {
        ArrayList<BillVerifyVO> mainList = new ArrayList<BillVerifyVO>();
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("main_id"));
            mainEntryIdSet.add(main.getLong("main_entryid"));
        }
        String selector = "id,asstacttype,entry.id,entry.e_confirmamt,entry.e_confirmqty,entry.e_unverifyqty,entry.e_unverifyamt,entry.e_ispresent,entry.e_confirmbaseqty";
        DataSet mainDS = QueryServiceHelper.queryDataSet((String)"manual_reloadmain", (String)"ar_revcfmbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIdSet), new QFilter("entry.id", "in", mainEntryIdSet), new QFilter("billstatus", "=", (Object)"C")}, (String)"bizdate,entry.e_material");
        if (mainDS.hasNext()) {
            for (Row dataSetRow : mainDS) {
                for (DynamicObject mainRow : mainRows) {
                    long entryId = mainRow.getLong("main_entryid");
                    if (entryId != dataSetRow.getLong("entry.id")) continue;
                    BillVerifyVO vo = new BillVerifyVO();
                    vo.setOrgId(manualParam.getOrgId());
                    vo.setAsstActType("bd_customer");
                    vo.setAsstActId(manualParam.getSupplierId());
                    vo.setEntryId(entryId);
                    vo.setBillType("ar_revcfmbill");
                    vo.setId(mainRow.getLong("main_id"));
                    vo.setBillNo(mainRow.getString("main_billno"));
                    vo.setBizdate(mainRow.getDate("main_bizdate"));
                    vo.setCurrencyId(mainRow.getLong("main_currency.id"));
                    vo.setEntryUnSettleAmt(mainRow.getBigDecimal("main_curverifyamt"));
                    vo.setEntryMaterialId(mainRow.getLong("main_material.id"));
                    vo.setEntryMeasureUnitId(mainRow.getLong("main_measureunit.id"));
                    vo.setEntryMeasureUnit(mainRow.getDynamicObject("main_measureunit"));
                    vo.setEntryBaseUnitId(mainRow.getLong("main_baseunit.id"));
                    DynamicObject baseUnit = mainRow.getDynamicObject("main_baseunit");
                    vo.setEntryBaseUnit(baseUnit);
                    BigDecimal convertRate = mainRow.getBigDecimal("main_convertrate");
                    vo.setUnitCoefficient(convertRate);
                    vo.setPrice(mainRow.getBigDecimal("main_unitprice"));
                    vo.setEntryUnSettleQty(mainRow.getBigDecimal("main_curverifyamt"));
                    vo.setEntryPayableAmt(dataSetRow.getBigDecimal("entry.e_confirmamt"));
                    BigDecimal confirmQty = dataSetRow.getBigDecimal("entry.e_confirmqty");
                    vo.setEntryQty(confirmQty);
                    BigDecimal confirmBaseQty = dataSetRow.getBigDecimal("entry.e_confirmbaseqty");
                    if (confirmBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                        confirmBaseQty = convertRate.compareTo(BigDecimal.ONE) == 0 ? confirmQty : UnitConvertHelper.getBaseunitqty((BigDecimal)confirmQty, (BigDecimal)convertRate, (DynamicObject)baseUnit);
                    }
                    vo.setBaseUnitQty(confirmBaseQty);
                    BigDecimal curVerifyQty = mainRow.getBigDecimal("main_curverifyqty");
                    BigDecimal remainQty = dataSetRow.getBigDecimal("entry.e_unverifyqty");
                    if (remainQty.abs().compareTo(curVerifyQty.abs()) < 0) {
                        curVerifyQty = remainQty;
                    }
                    vo.setEntryUnSettleQty(curVerifyQty);
                    vo.setPresent(dataSetRow.getBoolean("entry.e_ispresent").booleanValue());
                    vo.setQuotation(mainRow.getString("main_quotation"));
                    vo.setExchangeRate(mainRow.getBigDecimal("main_exchangerate"));
                    vo.setBaseCurrencyId(mainRow.getLong("main_basecurrency.id"));
                    vo.setPrecision(Integer.valueOf(mainRow.getInt("main_currency.amtprecision")));
                    vo.setBasePrecision(Integer.valueOf(mainRow.getInt("main_basecurrency.amtprecision")));
                    vo.setEntryEntityName(mainRow.getDataEntityType().getName());
                    vo.setEntryMaterialVersion(mainRow.getLong("main_materialversion.id"));
                    vo.setEntryMaterialSpecType(mainRow.getString("main_modelnum"));
                    vo.setEntryMaterialAuxProp(mainRow.getString("main_assistantattr"));
                    vo.setEntryMaterialConfigNumber(mainRow.getLong("main_configuredcode.id"));
                    vo.setEntryMaterialTrackNumber(mainRow.getLong("main_tracknumber.id"));
                    mainList.add(vo);
                }
            }
        }
        return mainList;
    }
}

