/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.mservice.helper.ArFinVerifyHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.mservice.verify.ArSaloutVerifyService;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class ArSelfVerifyService
extends ArSaloutVerifyService {
    public void autoVerifyById(List<Long> mainIds, List<Long> asstIds) {
        if (mainIds == null) {
            mainIds = new ArrayList<Long>(1);
        }
        if (asstIds == null) {
            asstIds = new ArrayList<Long>(1);
        }
        DynamicObject[] mains = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)VerifyServiceHelper.getRevcfmSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", mainIds)});
        DynamicObject[] assts = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)VerifyServiceHelper.getRevcfmSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        if (mains == null || assts == null || mains.length <= 0 || assts.length > 0) {
            // empty if block
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setOnlyByBotp(true);
        this.verify(mains, assts, scheme, VerifyModeEnum.AUTO.getValue());
    }

    @Override
    protected List<BillVerifyVO> getMainListVO(DynamicObject[] mains) {
        ArrayList<BillVerifyVO> asstList = new ArrayList<BillVerifyVO>();
        for (DynamicObject revcfmBill : mains) {
            DynamicObjectCollection entry = revcfmBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal unVerifyQty = row.getBigDecimal("e_unverifyqty");
                BigDecimal convertRate = row.getBigDecimal("e_unitcoefficient");
                if (unVerifyQty.compareTo(BigDecimal.ZERO) == 0 || convertRate.compareTo(BigDecimal.ZERO) == 0) continue;
                BillVerifyVO vo = new BillVerifyVO();
                vo.setId(revcfmBill.getLong("id"));
                vo.setOrgId(revcfmBill.getLong("org.id"));
                vo.setBillNo(revcfmBill.getString("billno"));
                vo.setBillType("ar_revcfmbill");
                vo.setBizdate(revcfmBill.getDate("bizdate"));
                vo.setEntryId(row.getLong("id"));
                vo.setCurrencyId(revcfmBill.getLong("currency.id"));
                vo.setPrice(row.getBigDecimal("e_actunitprice"));
                vo.setEntryPayableAmt(row.getBigDecimal("e_confirmamt"));
                vo.setAsstActType(revcfmBill.getString("asstacttype"));
                vo.setAsstActId(revcfmBill.getLong("asstact.id"));
                vo.setEntryCoreBillNum(row.getString("e_corebillno"));
                vo.setEntryCoreBillseq(row.getString("e_corebillentryseq"));
                vo.setEntrySettledAmt(row.getBigDecimal("e_verifiedamt"));
                vo.setEntryUnSettleAmt(row.getBigDecimal("e_unverifyamt"));
                vo.setEntryMaterialId(row.getLong("e_material.id"));
                vo.setEntryMeasureUnitId(row.getLong("e_measureunit.id"));
                vo.setEntryMeasureUnit(row.getDynamicObject("e_measureunit"));
                BigDecimal confirmQty = row.getBigDecimal("e_confirmqty");
                vo.setEntryQty(confirmQty);
                BigDecimal confirmBaseQty = row.getBigDecimal("e_confirmbaseqty");
                DynamicObject baseUnit = row.getDynamicObject("e_material.baseunit");
                if (confirmBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                    confirmBaseQty = convertRate.compareTo(BigDecimal.ONE) == 0 ? confirmQty : UnitConvertHelper.getBaseunitqty((BigDecimal)confirmQty, (BigDecimal)convertRate, (DynamicObject)baseUnit);
                }
                vo.setBaseUnitQty(confirmBaseQty);
                vo.setEntrySettledQty(row.getBigDecimal("e_verifiedqty"));
                vo.setEntryUnSettleQty(row.getBigDecimal("e_unverifyqty"));
                vo.setUnitCoefficient(convertRate);
                vo.setEntryBaseUnitId(row.getLong("e_material.baseunit.id"));
                vo.setEntryBaseUnit(baseUnit);
                vo.setEntrySouBillId(row.getLong("e_sourcebillentryid"));
                vo.setPresent(row.getBoolean("e_ispresent"));
                vo.setBaseCurrencyId(revcfmBill.getLong("basecurrency.id"));
                vo.setQuotation(revcfmBill.getString("quotation"));
                vo.setExchangeRate(revcfmBill.getBigDecimal("exchangerate"));
                vo.setPrecision(Integer.valueOf(revcfmBill.getInt("currency.amtprecision")));
                vo.setBasePrecision(Integer.valueOf(revcfmBill.getInt("basecurrency.amtprecision")));
                vo.setAllVerify(row.getBoolean("e_isallverify"));
                BigDecimal acttaxunitprice = row.getBigDecimal("e_acttaxunitprice");
                vo.setEntryEntityName(row.getDataEntityType().getName());
                vo.setPriceTax(acttaxunitprice);
                vo.setEntryMaterialVersion(row.getLong("e_materialversion.id"));
                vo.setEntryMaterialSpecType(row.getString("e_material.modelnum") != null ? row.getString("e_material.modelnum") : "");
                vo.setEntryMaterialAuxProp(row.getString("e_assistantattr") != null ? row.getString("e_assistantattr") : "");
                vo.setEntryMaterialConfigNumber(row.getLong("configuredcode.id"));
                vo.setEntryMaterialTrackNumber(row.getLong("tracknumber.id"));
                asstList.add(vo);
            }
        }
        return asstList;
    }

    @Override
    protected List<BillVerifyVO> getAsstListVO(DynamicObject[] assts) {
        return this.getMainListVO(assts);
    }

    @Override
    protected void disposeMainBill(List<VerifyRecordVO> voList, SettleSchemeVO scheme) {
        HashSet<Long> billIdSet = new HashSet<Long>(voList.size());
        for (VerifyRecordVO vo : voList) {
            billIdSet.add(vo.getMainBillId());
        }
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id,verifystatus,unverifyamt,exchangerate,amount,sourcebilltype,entry.id,entry.e_amount,entry.e_confirmamt,entry.e_verifiedamt,entry.e_unverifyamt,entry.e_verifiedqty,entry.e_unverifyqty,entry.e_sourcebillid,entry.e_sourcebillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        ArrayList<VerifyRecordVO> arPushList = new ArrayList<VerifyRecordVO>();
        HashMap<Long, DynamicObject> apBillMap = new HashMap<Long, DynamicObject>(apBills.length);
        for (DynamicObject bill : apBills) {
            apBillMap.put(bill.getLong("id"), bill);
        }
        apBills = null;
        boolean isSettle = scheme.isSettle();
        for (VerifyRecordVO vo : voList) {
            long billId = vo.getMainBillId();
            long billEntryId = vo.getMainBillEntryId();
            BigDecimal settleAmt = vo.getTotalSettleAmt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            DynamicObject bill = (DynamicObject)apBillMap.get(billId);
            DynamicObject asstEntry = null;
            DynamicObjectCollection collection = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : collection) {
                if (billEntryId != entry.getLong("id")) continue;
                asstEntry = entry;
                break;
            }
            if (asstEntry == null) continue;
            BigDecimal settleamt = vo.getTotalSettleAmt();
            BigDecimal verifyQty = vo.getVerifyQty();
            BigDecimal unverifyamount = bill.getBigDecimal("unverifyamt");
            BigDecimal verifyquantity = asstEntry.getBigDecimal("e_verifiedqty");
            BigDecimal entryAmount = asstEntry.getBigDecimal("e_confirmamt");
            BigDecimal unverifyquantity = asstEntry.getBigDecimal("e_unverifyqty");
            BigDecimal verifyamount = asstEntry.getBigDecimal("e_verifiedamt");
            BigDecimal e_unverifyamount = asstEntry.getBigDecimal("e_unverifyamt");
            if (scheme.isSettle()) {
                verifyquantity = verifyquantity.add(verifyQty);
                if ((unverifyquantity = unverifyquantity.subtract(verifyQty)).compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = BigDecimal.ZERO;
                    verifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.subtract(settleamt);
                    verifyamount = verifyamount.add(settleamt);
                }
            } else {
                verifyquantity = verifyquantity.subtract(verifyQty);
                unverifyquantity = unverifyquantity.add(verifyQty);
                if (verifyquantity.compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = BigDecimal.ZERO;
                    e_unverifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = verifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.add(settleamt);
                }
            }
            bill.set("unverifyamt", (Object)unverifyamount);
            asstEntry.set("e_verifiedqty", (Object)verifyquantity);
            asstEntry.set("e_unverifyqty", (Object)unverifyquantity);
            asstEntry.set("e_verifiedamt", (Object)verifyamount);
            asstEntry.set("e_unverifyamt", (Object)e_unverifyamount);
            bill.set("verifystatus", (Object)VerifyServiceHelper.getBillVerifyStatus(bill));
            if (!"ar_finarbill".equals(bill.get("sourcebilltype"))) continue;
            vo.setMainBillId(asstEntry.getLong("e_sourcebillid"));
            vo.setMainBillEntryId(asstEntry.getLong("e_sourcebillentryid"));
            arPushList.add(vo);
        }
        Collection objColl = apBillMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
        if (arPushList != null && arPushList.size() != 0) {
            ArFinVerifyHelper.dispose4MainBill(arPushList, scheme);
        }
        OpLogServiceHelper.addLog((String)(isSettle ? "verify" : "unverify"), (Object)scheme, (DynamicObject[])objColl.toArray(new DynamicObject[0]), (boolean)false);
    }

    @Override
    protected String getSettleRelation() {
        return VerifyRelationEnum.ARFINSELF.getValue();
    }
}

