/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.verify.ArSalManualVrifyService;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.ManualVerifyParam;

public class SalSelfManualVerifyService
extends ArSalManualVrifyService {
    @Override
    protected List<BillVerifyVO> getAsstVOList(DynamicObject[] asstRows, ManualVerifyParam manualParam) {
        ArrayList<BillVerifyVO> asstList = new ArrayList<BillVerifyVO>(64);
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstEntryIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            asstBillIdSet.add(asst.getLong("asst_id"));
            asstEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        String selector = "id,billentry.id,billentry.qty,billentry.ispresent,billentry.amountandtax,billentry.unverifyqty,billentry.actualtaxprice,billentry.baseqty";
        String orderBy = "biztime,billentry.material";
        DataSet asstDS = QueryServiceHelper.queryDataSet((String)"manual_reloadmain", (String)"im_saloutbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIdSet), new QFilter("billstatus", "=", (Object)"C"), new QFilter("billentry.id", "in", asstEntryIdSet)}, (String)orderBy);
        if (asstDS.hasNext()) {
            for (Row dataSetRow : asstDS) {
                for (DynamicObject asstRow : asstRows) {
                    long entryId = asstRow.getLong("asst_entryid");
                    if (entryId != dataSetRow.getLong("billentry.id")) continue;
                    BillVerifyVO vo = new BillVerifyVO();
                    vo.setOrgId(manualParam.getOrgId());
                    vo.setAsstActId(manualParam.getSupplierId());
                    vo.setAsstActType("bd_supplier");
                    vo.setId(asstRow.getLong("asst_id"));
                    vo.setBillNo(asstRow.getString("asst_billno"));
                    vo.setCurrencyId(asstRow.getLong("asst_currency.id"));
                    vo.setBizdate(asstRow.getDate("asst_bizdate"));
                    vo.setPrice(asstRow.getBigDecimal("asst_unitprice"));
                    vo.setEntryUnSettleQty(asstRow.getBigDecimal("asst_curverifyamt"));
                    vo.setEntryId(entryId);
                    vo.setEntryMaterialId(asstRow.getLong("asst_material.id"));
                    vo.setUnitCoefficient(asstRow.getBigDecimal("asst_convertrate"));
                    vo.setEntryMeasureUnitId(asstRow.getLong("asst_measureunit.id"));
                    vo.setEntryMeasureUnit(asstRow.getDynamicObject("asst_measureunit"));
                    vo.setEntryBaseUnitId(asstRow.getLong("asst_baseunit.id"));
                    vo.setEntryBaseUnit(asstRow.getDynamicObject("asst_baseunit"));
                    vo.setEntryQty(dataSetRow.getBigDecimal("billentry.qty"));
                    vo.setBaseUnitQty(dataSetRow.getBigDecimal("billentry.baseqty"));
                    vo.setEntryPayableAmt(dataSetRow.getBigDecimal("billentry.amountandtax"));
                    BigDecimal curVerifyQty = asstRow.getBigDecimal("asst_curverifyqty");
                    BigDecimal remainQty = dataSetRow.getBigDecimal("billentry.unverifyqty");
                    if (remainQty.abs().compareTo(curVerifyQty.abs()) < 0) {
                        curVerifyQty = remainQty;
                    }
                    vo.setEntryUnSettleQty(curVerifyQty);
                    vo.setBillType("im_saloutbill");
                    vo.setPresent(dataSetRow.getBoolean("billentry.ispresent").booleanValue());
                    vo.setQuotation(asstRow.getString("asst_quotation"));
                    vo.setExchangeRate(asstRow.getBigDecimal("asst_exchangerate"));
                    vo.setBaseCurrencyId(asstRow.getLong("asst_basecurrency.id"));
                    vo.setPriceTax(dataSetRow.getBigDecimal("billentry.actualtaxprice"));
                    vo.setPrecision(Integer.valueOf(asstRow.getInt("asst_currency.amtprecision")));
                    vo.setBasePrecision(Integer.valueOf(asstRow.getInt("asst_basecurrency.amtprecision")));
                    vo.setEntryEntityName(asstRow.getDataEntityType().getName());
                    vo.setEntryMaterialVersion(asstRow.getLong("asst_materialversion.id"));
                    vo.setEntryMaterialSpecType(asstRow.getString("asst_modelnum"));
                    vo.setEntryMaterialAuxProp(asstRow.getString("asst_assistantattr"));
                    vo.setEntryMaterialConfigNumber(asstRow.getLong("asst_configuredcode.id"));
                    vo.setEntryMaterialTrackNumber(asstRow.getLong("asst_tracknumber.id"));
                    asstList.add(vo);
                }
            }
        }
        return asstList;
    }
}

