/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.verify;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.KdtxRequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;

public class SimtoArVerifyByOpService {
    private static final Log logger = LogFactory.getLog(SimtoArVerifyByOpService.class);

    public void simAndArVerifyByOp(String verifyArgs) {
        logger.info("SimtoArVerifyService reveice data is " + verifyArgs);
        boolean enableConfig = VerifyServiceHelper.enablePreOriginalWfConfig(true);
        if (!enableConfig) {
            return;
        }
        Map sinIdsByOp = (Map)JSONObject.parseObject((String)verifyArgs, Map.class);
        long uniqueKey = DB.genGlobalLongId();
        for (Map.Entry entry : sinIdsByOp.entrySet()) {
            String opKey = (String)entry.getKey();
            List ids = (List)entry.getValue();
            this.existRedRecord(ids);
            if (ObjectUtils.isEmpty((Object)ids)) {
                return;
            }
            TXHandle tx = TX.required();
            Throwable throwable = null;
            try {
                try {
                    switch (opKey) {
                        case "billopen": {
                            CommonParam param = new CommonParam();
                            param.put((Object)"entitytype", (Object)"sim_original_bill");
                            param.put((Object)"ids", (Object)JSONObject.toJSONString((Object)ids));
                            param.put((Object)"operationKey", (Object)"issuepush");
                            logger.info("SimtoArVerifyService billopen execute WriteOffService interface start ");
                            SimtoArVerifyByOpService.execute("msmod_writeoff", "msmod_writeoff_generate_record", "mpscmm", "mscommon", "scm", "WriteOffService", ids.stream().map(String::valueOf).collect(Collectors.toList()), (Param)param, null, true);
                            logger.info("SimtoArVerifyService billopen execute WriteOffService interface end ");
                            break;
                        }
                        case "billred": 
                        case "billcancel": {
                            CommonParam param;
                            Map loadUpBillCancelMap = BOTPHelper.loadNearUpBillIds((String)"sim_original_bill", (String)"ar_finarbill", (Long[])ids.toArray(new Long[0]));
                            Map loadDownBillCancelMap = BOTPHelper.loadNearTarBillIds((String)"sim_original_bill", (String)"ar_finarbill", (Long[])ids.toArray(new Long[0]));
                            if (ObjectUtils.isEmpty((Object)loadUpBillCancelMap) && ObjectUtils.isEmpty((Object)loadDownBillCancelMap)) {
                                DynamicObjectCollection records = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,entry.e_iswrittenoff,entry.e_hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", (Object)ids)});
                                ArrayList<Long> recordIdList = new ArrayList<Long>(records.size());
                                for (DynamicObject record : records) {
                                    boolean isWrittenOff = record.getBoolean("entry.e_iswrittenoff");
                                    boolean hadWrittenOff = record.getBoolean("entry.e_hadwrittenoff");
                                    if (isWrittenOff || hadWrittenOff) continue;
                                    recordIdList.add(record.getLong("id"));
                                }
                                param = new CommonParam();
                                param.put((Object)"uniquekey", (Object)uniqueKey);
                                param.put((Object)"ids", recordIdList);
                                ECServiceHelper.beginAndRegisterWithBusInfo((String)"ar_original_verify", (String)"ar_original_unverifyimpl", (String)"fi", (String)"ar", (String)"ArOriginalDisposeUnVerifyECService", (Param)param, (String)"", new ArrayList(recordIdList));
                                break;
                            }
                            if (ObjectUtils.isEmpty((Object)loadUpBillCancelMap)) break;
                            Set originalIdSet = loadUpBillCancelMap.keySet();
                            DynamicObject[] recordCancelArray = BusinessDataServiceHelper.load((String)"ar_originalwfrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", originalIdSet)});
                            HashSet<Long> recordIdCancelSet = new HashSet<Long>(recordCancelArray.length);
                            for (DynamicObject record : recordCancelArray) {
                                recordIdCancelSet.add(record.getLong("id"));
                            }
                            logger.info("SimtoArVerifyService billcancel delete start ");
                            DeleteServiceHelper.delete((String)"ar_originalwfrecord", (QFilter[])new QFilter[]{new QFilter("id", "in", recordIdCancelSet)});
                            logger.info("SimtoArVerifyService billcancel delete end ");
                        }
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    private void existRedRecord(List<Long> ids) {
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"entry.e_hadwrittenoff,entry.assbillid,isvoucher", (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", ids)});
        for (DynamicObject record : records) {
            if (!record.getBoolean("isvoucher")) continue;
            ids.remove(record.getLong("entry.assbillid"));
        }
    }

    private static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String dbRoute, String serviceName, List<String> businessInfo, Param param, String bizId, boolean writeOff) throws Exception {
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session == null || StringUtils.isEmpty((CharSequence)KdtxRequestContext.get().getXid())) {
            ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)dbRoute));
            if (writeOff) {
                ECGlobalSession.setBusinessType((String)"WriteOffOpAction");
            } else {
                ECGlobalSession.setBusinessType((String)"UnWriteOffOpAction");
            }
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param, (String)branchScenesCode, (String)bizId);
        ECGlobalSession.setAsync((boolean)true);
    }
}

