/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.validator.AccrualSchemeUniqueValidator;
import kd.fi.arapcommon.enums.BillStatusEnum;

public class AccrualSchemeInsertOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("accrualmethod");
        list.add("accrualfactor");
        list.add("entryentity.mulbdfactor0");
        list.add("entryentity.mulbdfactor1");
        list.add("entryentity.mulbdfactor2");
        list.add("entryentity.range");
        list.add("entryentity.accrualrate");
        list.add("fieldmapentry.entityid");
        list.add("fieldmapentry.fieldkey");
        list.add("fieldmapentry.fieldname");
        list.add("policyentry.p_policy");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AccrualSchemeUniqueValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject base : e.getDataEntities()) {
            base.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            base.set("enable", (Object)1);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ar_policy");
        ArrayList<DynamicObject> baddebtResultList = new ArrayList<DynamicObject>(64);
        for (DynamicObject scheme : e.getDataEntities()) {
            DynamicObject[] baddebtResults;
            DynamicObject[] objs;
            baddebtResultList.clear();
            DynamicObjectCollection policys = scheme.getDynamicObjectCollection("policyentry");
            ArrayList<Long> policyPks = new ArrayList<Long>();
            for (DynamicObject[] policy : policys) {
                policyPks.add((Long)policy.getDynamicObject("p_policy").getPkValue());
            }
            for (DynamicObject obj : objs = BusinessDataServiceHelper.load((Object[])policyPks.toArray(), (DynamicObjectType)dt)) {
                obj.set("accrualscheme", (Object)scheme);
            }
            SaveServiceHelper.save((DynamicObject[])objs);
            QFilter qFilter = new QFilter("policyid", "in", policyPks);
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
            qFilter.and(new QFilter("isfirst", "=", (Object)Boolean.TRUE));
            for (DynamicObject baddebtResult : baddebtResults = BusinessDataServiceHelper.load((String)"ar_baddebtresult", (String)"period, policyid", (QFilter[])new QFilter[]{qFilter})) {
                DynamicObject policy = BusinessDataServiceHelper.loadSingleFromCache((Object)baddebtResult.getLong("policyid"), (String)"ar_policy", (String)"startperiod");
                Long startperiodPk = policy.getDynamicObject("startperiod").getLong("id");
                if (!startperiodPk.equals(baddebtResult.getDynamicObject("period").getLong("id"))) continue;
                baddebtResult.set("period", (Object)BaddebtHelper.getCurrentPeriod((String)scheme.getString("accrualfrequency"), (Object)startperiodPk));
                baddebtResultList.add(baddebtResult);
            }
            if (baddebtResultList.isEmpty()) continue;
            SaveServiceHelper.save((DynamicObject[])baddebtResultList.toArray(new DynamicObject[0]));
        }
    }
}

