/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.validator.PeriodAuditOrUnauditValidator;

public class ArBusBillAuditOp
extends ArBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("org");
        lst.add("bizdate");
        lst.add("bookdate");
        lst.add("writeoffbusiness");
        lst.add("srcfinbillid");
        lst.add("isperiod");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PeriodAuditOrUnauditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] busBills = e.getDataEntities();
        BookDateHelper.setBookDate((DynamicObject[])busBills, (boolean)true);
        this.setBookDate4WoffBill(busBills);
    }

    private void setBookDate4WoffBill(DynamicObject[] busBills) {
        HashSet<Long> finBillIds = new HashSet<Long>(busBills.length);
        ArrayList<DynamicObject> writeOffBus = new ArrayList<DynamicObject>(busBills.length);
        HashMap<Long, Date> finBookDates = new HashMap<Long, Date>(busBills.length);
        for (DynamicObject busBill : busBills) {
            Long srcfinbillid;
            boolean isWriteOff = busBill.getBoolean("writeoffbusiness");
            if (!isWriteOff || (srcfinbillid = Long.valueOf(busBill.getLong("srcfinbillid"))) == null || srcfinbillid == 0L) continue;
            finBillIds.add(srcfinbillid);
            writeOffBus.add(busBill);
        }
        if (finBillIds.size() == 0) {
            return;
        }
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", finBillIds)});
        for (DynamicObject finBill : finApBills) {
            finBookDates.put(finBill.getLong("id"), finBill.getDate("bookdate"));
        }
        if (finBookDates.size() == 0) {
            return;
        }
        for (DynamicObject busBill : writeOffBus) {
            Long srcfinbillid = busBill.getLong("srcfinbillid");
            Date bookDate = (Date)finBookDates.get(srcfinbillid);
            if (bookDate == null) continue;
            busBill.set("bookdate", (Object)bookDate);
        }
    }
}

