/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.arapcommon.journal.JournalService;

public class ArBusBillDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("isperiod");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        List<Long> pks = Stream.of(e.getDataEntities()).filter(b -> b.getBoolean("isperiod")).map(b -> b.getLong("id")).collect(Collectors.toList());
        if (!pks.isEmpty()) {
            QFilter qFilter = new QFilter("sourcebillid", "in", pks);
            DeleteServiceHelper.delete((String)"ar_baddebtreservebill", (QFilter[])new QFilter[]{qFilter});
            new JournalService().deleteJournals("ar_busbill", pks.toArray(new Long[0]));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ThreadPools.executeOnceIncludeRequestContext((String)"delete.disposeReserveBill", () -> {
            ArrayList<Long> srcPks = new ArrayList<Long>();
            for (DynamicObject busbill : e.getDataEntities()) {
                if (ObjectUtils.isEmpty((Object)busbill.getString("sourcebilltype")) || !"ar_busbill".equals(busbill.getString("sourcebilltype"))) continue;
                srcPks.add(busbill.getLong("sourcebillid"));
            }
            if (!srcPks.isEmpty()) {
                BaddebtHelper.disposeReserveBill(srcPks);
            }
        });
    }
}

