/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.validator.BusArBillImportValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.opplugin.ArApSuiteValidator;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.validator.AllEntriesIsDrawValidator;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.BusWoffBillQtyExcessValidator;
import kd.fi.arapcommon.validator.SupplierandMaterial4VmiValidator;

public class ArBusBillSaveOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(ArBusBillSaveOp.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private final String[] filedKeys = new String[]{"recamount", "reclocalamt", "amount", "localamt", "tax", "taxlocamt", "unwoffamt", "unwofflocamt", "unwoffnotaxamt", "unwoffnotaxlocamt", "unwofftax", "unwofftaxlocal", "invoicedamt", "invoicedlocamt", "uninvoicedamt", "uninvoicedlocamt", "unrelateinvamt", "unrelateinvlocamt", "relateinvamt", "relateinvlocamt", "invamt", "invlocamt"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if (!"true".equals(isAppend)) {
            e.addValidator((AbstractValidator)new BusArBillImportValidator());
        }
        e.addValidator((AbstractValidator)new SupplierandMaterial4VmiValidator());
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new AllEntriesIsDrawValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new ArApSuiteValidator());
        e.addValidator((AbstractValidator)new BusWoffBillQtyExcessValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        TaxHelper.recordTaxLog((DynamicObject[])e.getDataEntities(), (boolean)true);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] busArBills = e.getDataEntities();
        BookDateHelper.billSavesetBookDate((DynamicObject[])busArBills, (boolean)true);
        List customerBills = Arrays.stream(busArBills).filter(s -> ("1".equals(s.getString("billsrctype")) || "3".equals(s.getString("billsrctype"))) && "bd_customer".equals(s.getString("asstacttype"))).collect(Collectors.toList());
        if (customerBills != null && customerBills.size() > 0) {
            FinArBillHelper.setImptCustomers(customerBills);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        logger.info("ArBusBillSaveOp.beginOperationTransaction appendHeadAmt start");
        this.appendHeadAmt(dataEntities);
        logger.info("ArBusBillSaveOp.beginOperationTransaction appendHeadAmt end");
        ArApDataRepairHelper.repairBusArAmtField((DynamicObject[])dataEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendHeadAmt(DynamicObject[] datas) {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if ("true".equals(isAppend)) {
            try {
                lock.lock();
                for (DynamicObject data : datas) {
                    String amtJson = (String)ConfigCache.get((String)"appendentryrows", (String)data.getString("id"), String.class);
                    Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
                    if (amtJson != null) {
                        amtMap = (Map)SerializationUtils.fromJsonString((String)amtJson, Map.class);
                        for (String filedKey : this.filedKeys) {
                            data.set(filedKey, (Object)data.getBigDecimal(filedKey).add(amtMap.getOrDefault(filedKey, BigDecimal.ZERO)));
                        }
                    }
                    this.buildAmtMap(amtMap, data);
                    ConfigCache.put((String)"appendentryrows", (String)data.getString("id"), (Object)SerializationUtils.toJsonString(amtMap));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void buildAmtMap(Map<String, BigDecimal> amtMap, DynamicObject data) {
        for (String filedKey : this.filedKeys) {
            amtMap.put(filedKey, data.getBigDecimal(filedKey));
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List props = e.getFieldKeys();
        props.add("asstacttype");
        props.add("asstact");
        props.add("biztype");
        props.add("org");
        props.add("e_material");
        props.add("sourcebilltype");
        props.add("sourcebillid");
        props.add("isselfwoff");
        props.add("billsrctype");
        props.add("exchangerate");
        props.add("basecurrency");
        props.add("entry.e_material");
        props.add("entry.e_measureunit");
        props.add("entry.configuredcode");
        props.add("bizdate");
        props.add("isperiod");
        props.add("billtype");
        props.add("isincludetax");
        props.add("billno");
        props.add("bookdate");
        props.add("entry.e_invamt");
        props.add("invoicedamt");
        props.add("relateinvamt");
        props.add("invamt");
        props.add("recamount");
        props.add("amount");
        props.add("localamt");
        props.add("tax");
        props.add("taxlocamt");
        props.add("reclocalamt");
        props.add("unwoffamt");
        props.add("unwofflocamt");
        props.add("uninvoicedlocamt");
        props.add("invoicedlocamt");
        props.add("relateinvlocamt");
        props.add("unrelateinvlocamt");
        props.add("invlocamt");
        props.add("uninvoicedamt");
        props.add("unrelateinvamt");
        props.add("paymentcustomerid");
        props.add("unwofftaxlocal");
        props.add("unwofftax");
        props.add("unwoffnotaxlocamt");
        props.add("unwoffnotaxamt");
        props.add("entry.e_delivercustomerid");
        props.add("entry.e_invoicecustomerid");
        props.add("entry.e_invoicedqty");
        props.add("entry.e_invoicedamt");
        props.add("entry.e_invoicednotaxamt");
        props.add("entry.e_confirmedamt");
        props.add("entry.e_relateinvqty");
        props.add("entry.e_relateinvamt");
        props.add("entry.e_invqty");
        props.add("entry.e_invnotaxamt");
        props.add("entry.e_quantity");
        props.add("entry.e_amount");
        props.add("entry.e_recamount");
        props.add("entry.e_uninvoicedqty");
        props.add("entry.e_uninvoicedamt");
        props.add("entry.e_uninvnotaxamt");
        props.add("entry.e_unconfirmamt");
        props.add("entry.e_unrelateinvqty");
        props.add("entry.e_unrelateinvamt");
        props.add("entry.e_tax");
        props.add("entry.e_taxlocalamt");
        props.add("entry.e_discountamount");
        props.add("entry.e_discountlocalamt");
        props.add("entry.e_localamt");
        props.add("entry.e_reclocalamt");
        props.add("entry.e_unwoffamt");
        props.add("entry.e_unwofflocamt");
        props.add("entry.e_uninvoicedlocamt");
        props.add("entry.e_invoicedlocamt");
        props.add("entry.e_invnotaxlocalamt");
        props.add("entry.e_uninvnotaxlocalamt");
        props.add("entry.e_unrelateinvlocamt");
        props.add("entry.e_relateinvlocamt");
        props.add("entry.e_confirmedqty");
        props.add("entry.e_unconfirmqty");
        props.add("e_invnotaxlocamt");
        props.add("entry.e_invlocamt");
        props.add("sourcebilltype");
        props.add("isadjust");
        props.add("entry.seq");
        props.add("corebillid");
        props.add("corebillentryid");
        props.add("entry.e_srcid");
        props.add("entry.e_srcentryid");
        props.add("entry.e_ispresent");
        props.add("entry.e_unitprice");
    }
}

