/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.ar.validator.validatorService.ArValidatorService;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.service.helper.BusBillServiceHelper;
import kd.fi.arapcommon.validator.PeriodAuditOrUnauditValidator;

public class ArBusBillUnauditOp
extends ArBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("org");
        lst.add("isperiod");
        lst.add("isadjust");
        lst.add("sourcebillid");
        lst.add("srcfinbillid");
        lst.add("entry.e_quantity");
        lst.add("entry.e_srcentryid");
        lst.add("entry.e_srcbillid");
        lst.add("bizdate");
        lst.add("bookdate");
        lst.add("billsrctype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PeriodAuditOrUnauditValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ArrayList<Long> billIdList = new ArrayList<Long>(this.dataEntities.length);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Long billId = (Long)dataEntity.getBillPkId();
                    billIdList.add(billId);
                }
                Map batchDirtTargetBillMap = BOTPHelper.findDirtTargetBillMap((String)this.entityKey, (Long[])billIdList.toArray(new Long[0]));
                ArValidatorService vService = new ArValidatorService();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Long billId;
                    Map singleTarBillMap;
                    String errorMessage = vService.closeAccountValidate(dataEntity, "ar_busbill", "bookdate");
                    if (!"".equals(errorMessage)) {
                        this.addErrorMessage(dataEntity, errorMessage);
                    }
                    if ((singleTarBillMap = (Map)batchDirtTargetBillMap.get(billId = (Long)dataEntity.getBillPkId())) == null) continue;
                    singleTarBillMap.remove("ar_journal");
                    if (singleTarBillMap.size() <= 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ArBusBillUnauditOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        BusBillServiceHelper.getInstance().antiWriteOff(e.getDataEntities(), true);
    }
}

