/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.validator.BusArBillRelateAmountValidator;
import kd.fi.ar.validator.BusArBillSubmitAmountValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.opplugin.ArApSuiteValidator;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.opplugin.BillAppStatusValidator;
import kd.fi.arapcommon.opplugin.MustInputValidator;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.MtoValidator;

public class ArBusSubmitOp
extends ArapBaseOp {
    private Date currentDate = new Date();
    private MainEntityType reserveDT = null;
    private String userID = null;
    private static final int rowCountOneBatch = 2000;
    private Map<Object, DynamicObject[]> initInfoCache = new HashMap<Object, DynamicObject[]>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (!this.operateOption.getVariables().containsKey("iswoff")) {
            e.addValidator((AbstractValidator)new BillAppStatusValidator());
        }
        e.addValidator((AbstractValidator)new MustInputValidator());
        if (SystemParameterHelper.isForceValidateAmt()) {
            e.addValidator((AbstractValidator)new BusArBillSubmitAmountValidator());
        }
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new MtoValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new BusArBillRelateAmountValidator());
        e.addValidator((AbstractValidator)new ArApSuiteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List selectors = e.getFieldKeys();
        selectors.add("isperiod");
        selectors.add("bizdate");
        selectors.add("org");
        selectors.add("billno");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("currency");
        selectors.add("recamount");
        selectors.add("duedate");
        selectors.add("exchangerate");
        selectors.add("basecurrency");
        selectors.add("uninvoicedamt");
        selectors.add("uninvoicedlocamt");
        selectors.add("sourcebilltype");
        selectors.add("sourcebillid");
        selectors.add("isadjust");
        selectors.add("creator");
        selectors.add("imageno");
        selectors.add("createtime");
        selectors.add("e_unitprice");
        selectors.add("e_taxunitprice");
        selectors.add("e_ispresent");
        selectors.add("billsrctype");
        selectors.add("isincludetax");
        selectors.add("e_quantity");
        selectors.add("e_tax");
        selectors.add("e_amount");
        selectors.add("e_discountamount");
        selectors.add("e_recamount");
        if (SystemParameterHelper.isForceValidateAmt()) {
            selectors.addAll(BusArBillSubmitAmountValidator.getRequiredFields());
        }
        selectors.add("payproperty");
        selectors.add("linetype");
        selectors.add("bookdate");
        selectors.add("configuredcode");
        selectors.add("tracknumber");
        selectors.add("e_corebillno");
        selectors.add("e_corebillentryseq");
        selectors.add("e_corebilltype");
        selectors.add("corebillid");
        selectors.add("corebillentryid");
        selectors.add("e_material");
        selectors.add("localamt");
        selectors.add("amount");
        selectors.add("taxlocamt");
        selectors.add("tax");
        selectors.add("reclocalamt");
        selectors.add("unwofflocamt");
        selectors.add("unwoffamt");
        selectors.add("e_taxlocalamt");
        selectors.add("e_discountlocalamt");
        selectors.add("e_localamt");
        selectors.add("e_reclocalamt");
        selectors.add("e_unwofflocamt");
        selectors.add("e_unwoffamt");
        selectors.add("e_uninvoicedlocamt");
        selectors.add("e_uninvoicedamt");
        selectors.add("e_unitcoefficient");
        selectors.add("e_baseunitqty");
        selectors.add("e_baseunit");
        selectors.add("e_quantity");
        selectors.add("e_measureunit");
        selectors.add("invoicedamt");
        selectors.add("invoicedlocamt");
        selectors.add("relateinvamt");
        selectors.add("relateinvlocamt");
        selectors.add("invamt");
        selectors.add("invlocamt");
        selectors.add("unrelateinvamt");
        selectors.add("unrelateinvlocamt");
        selectors.add("entry.e_invoicedqty");
        selectors.add("entry.e_invoicedamt");
        selectors.add("entry.e_invoicedlocamt");
        selectors.add("entry.e_invoicednotaxamt");
        selectors.add("entry.e_invnotaxlocalamt");
        selectors.add("entry.e_confirmedamt");
        selectors.add("entry.e_relateinvqty");
        selectors.add("entry.e_relateinvamt");
        selectors.add("entry.e_relateinvlocamt");
        selectors.add("entry.e_invqty");
        selectors.add("entry.e_invnotaxamt");
        selectors.add("entry.e_invnotaxlocamt");
        selectors.add("entry.e_invamt");
        selectors.add("entry.e_invlocamt");
        selectors.add("entry.e_uninvoicedqty");
        selectors.add("entry.e_uninvnotaxamt");
        selectors.add("entry.e_uninvnotaxlocalamt");
        selectors.add("entry.e_unconfirmamt");
        selectors.add("entry.e_unrelateinvqty");
        selectors.add("entry.e_unrelateinvamt");
        selectors.add("entry.e_unrelateinvlocamt");
        selectors.add("exratetable");
        selectors.add("entry.e_confirmedqty");
        selectors.add("entry.e_unconfirmqty");
        selectors.add("entry.seq");
        selectors.add("entry.e_srcid");
        selectors.add("entry.e_srcentryid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bill : datas = e.getDataEntities()) {
            if (!StringUtils.isEmpty((String)bill.getString("billsrctype")) || !StringUtils.isNotEmpty((String)bill.getString("sourcebilltype"))) continue;
            bill.set("billsrctype", (Object)BillSrcTypeEnum.AUTO.getValue());
        }
        BookDateHelper.setBookDate((DynamicObject[])datas, (boolean)true);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArApDataRepairHelper.repairBusArAmtField((DynamicObject[])dataEntities);
        ArApHelper.baseUnitQtyCorrection((DynamicObject[])dataEntities, (String)"ar_busbill");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Object orgPk;
        DynamicObject[] inits;
        super.endOperationTransaction(e);
        this.reserveDT = EntityMetadataCache.getDataEntityType((String)"ar_baddebtreservebill");
        this.userID = String.valueOf(RequestContext.get().getCurrUserId());
        ArrayList<DynamicObject> reservableBusBills = new ArrayList<DynamicObject>();
        for (DynamicObject busBill : e.getDataEntities()) {
            if (!this.isEnableGenerateBaddebtReserve(busBill) || (inits = this.getInitInfo(orgPk = busBill.getDynamicObject("org").getPkValue())).length <= 0) continue;
            reservableBusBills.add(busBill);
        }
        if (!reservableBusBills.isEmpty()) {
            DynamicObject[] reserveBills = this.loadReserveBills(reservableBusBills);
            ArrayList<DynamicObject> reserveList = new ArrayList<DynamicObject>();
            for (DynamicObject busBill : reservableBusBills) {
                orgPk = busBill.getDynamicObject("org").getPkValue();
                for (DynamicObject init : inits = this.getInitInfo(orgPk)) {
                    DynamicObject matchedReserveBill = this.matchReserveBill(busBill, init, reserveBills);
                    reserveList.add(this.buildInitBaddebtReserve(busBill, init, matchedReserveBill));
                }
            }
            if (reserveList.size() > 0) {
                SaveServiceHelper.save((IDataEntityType)this.reserveDT, (Object[])reserveList.toArray());
            }
        }
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("entry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }

    private DynamicObject[] loadReserveBills(List<DynamicObject> busBills) {
        QFilter initFilter = new QFilter("initbaddebtid", "in", this.getAllInitIds(this.initInfoCache));
        QFilter sourceBillFilter = new QFilter("sourcebillid", "in", (Object)DynamicObjectHelper.getLongIds(busBills));
        DynamicObjectCollection reserveBillColls = QueryServiceHelper.query((String)"ar_baddebtreservebill", (String)"id", (QFilter[])new QFilter[]{initFilter, sourceBillFilter});
        List reserveBillIds = DynamicObjectHelper.getLongIds((Collection)reserveBillColls);
        DynamicObject[] reserveBills = BusinessDataServiceHelper.load((Object[])reserveBillIds.toArray(new Long[0]), (DynamicObjectType)this.reserveDT);
        return reserveBills;
    }

    private DynamicObject matchReserveBill(DynamicObject busBill, DynamicObject init, DynamicObject[] reserveBills) {
        DynamicObject matchedReserveBill = null;
        for (DynamicObject reserveBill : reserveBills) {
            if (!Objects.equals(reserveBill.get("sourcebillid"), busBill.getPkValue()) || !Objects.equals(reserveBill.get("initbaddebtid"), init.getPkValue())) continue;
            matchedReserveBill = reserveBill;
            break;
        }
        return matchedReserveBill;
    }

    private List<Long> getAllInitIds(Map<Object, DynamicObject[]> initInfoCacheMap) {
        ArrayList<Long> allInitIds = new ArrayList<Long>();
        for (DynamicObject[] initInfos : initInfoCacheMap.values()) {
            for (DynamicObject initInfo : initInfos) {
                allInitIds.add(initInfo.getLong("id"));
            }
        }
        return allInitIds;
    }

    private boolean isEnableGenerateBaddebtReserve(DynamicObject info) {
        return info.getBoolean("isperiod") && !info.getBoolean("isadjust");
    }

    private DynamicObject[] getInitInfo(Object orgPk) {
        DynamicObject[] targets = this.initInfoCache.get(orgPk);
        if (targets != null) {
            return targets;
        }
        QFilter orgFilter = new QFilter("org", "=", orgPk);
        QFilter fixFilter = new QFilter("isfinishinit", "=", (Object)Boolean.FALSE);
        QFilter policyFilter = new QFilter("baddebtpolicy", "=", (Object)"allowance");
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"ar_init", (String)"id, policytype, startperiod, baddebtpolicy, policyid", (QFilter[])new QFilter[]{orgFilter, fixFilter, policyFilter}, (String)"policytype");
        this.initInfoCache.put(orgPk, inits);
        return inits;
    }

    private DynamicObject buildInitBaddebtReserve(DynamicObject srcBill, DynamicObject init, DynamicObject destBill) {
        if (destBill == null) {
            destBill = new DynamicObject((DynamicObjectType)this.reserveDT);
            destBill.set("creator", (Object)Long.valueOf(this.userID));
            destBill.set("createtime", (Object)this.currentDate);
        }
        BaddebtHelper.buildBaseBaddebt((DynamicObject)srcBill, (DynamicObject)destBill);
        destBill.set("policytype", init.getDynamicObject("policytype").getPkValue());
        destBill.set("period", init.getDynamicObject("startperiod").getPkValue());
        destBill.set("initbaddebtid", init.getPkValue());
        destBill.set("exchangerate", (Object)srcBill.getBigDecimal("exchangerate"));
        destBill.set("basecurrency", srcBill.getDynamicObject("basecurrency").getPkValue());
        destBill.set("unsettleamt", (Object)srcBill.getBigDecimal("uninvoicedamt"));
        destBill.set("unsettlelocalamt", (Object)srcBill.getBigDecimal("uninvoicedlocamt"));
        destBill.set("billstatus", (Object)"B");
        return destBill;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ThreadPools.executeOnceIncludeRequestContext((String)"submit.disposeReserveBill", () -> {
            ArrayList<Long> srcPks = new ArrayList<Long>();
            for (DynamicObject busbill : e.getDataEntities()) {
                if (ObjectUtils.isEmpty((Object)busbill.getString("sourcebilltype")) || !"ar_busbill".equals(busbill.getString("sourcebilltype"))) continue;
                srcPks.add(busbill.getLong("sourcebillid"));
            }
            if (!srcPks.isEmpty()) {
                BaddebtHelper.disposeReserveBill(srcPks);
            }
        });
        TaxHelper.recordTaxLog((DynamicObject[])e.getDataEntities(), (boolean)true);
        this.removeCache(e.getDataEntities());
    }
}

