/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.ar.mservice.ArImportSettleService;
import kd.fi.arapcommon.validator.ImportSettleValidator;
import kd.fi.arapcommon.vo.ImportSettleParam;

public class ArImportSettleOp
extends AbstractOperationServicePlugIn {
    private final List<Object> failPks = new ArrayList<Object>(2);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List props = e.getFieldKeys();
        props.add("settleresult");
        props.add("mainasstactid");
        props.add("org");
        props.add("billno");
        props.add("settlerelation");
        props.add("mainbillid");
        props.add("mainbillnum");
        props.add("maincurrency");
        props.add("totalsettleamt");
        props.add("exchangerate");
        props.add("billentity");
        props.add("entry.billnum");
        props.add("entry.asstactid");
        props.add("entry.settleamt");
        props.add("entry.e_exchangerate");
        props.add("entry.e_billentity");
        props.add("entry.billid");
        props.add("entry.currency");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ImportSettleValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Object statusErr;
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] settleImport = e.getDataEntities();
        Map<Long, String> billNos = Arrays.stream(settleImport).collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("billno")));
        ArImportSettleService service = new ArImportSettleService();
        ImportSettleParam param = new ImportSettleParam();
        param.setDisposeImportBill(true);
        Map resultMap = service.execute(settleImport, param);
        Object excessErr = resultMap.get("excessErr");
        if (excessErr != null) {
            this.failPks.addAll((List)excessErr);
        }
        if ((statusErr = resultMap.get("statusErr")) != null) {
            this.failPks.addAll((List)statusErr);
        }
        if (this.failPks.size() > 0) {
            for (Object pk : this.failPks) {
                String billNo = billNos.get((Long)pk);
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo("101", ErrorLevel.Error, pk);
                operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u7684\u7ed3\u7b97\u91d1\u989d\u8d85\u989d\u6216\u5355\u636e\u72b6\u6001\u5f02\u5e38\u3002", (String)"ArImportSettleOp_0", (String)"fi-ar-opplugin", (Object[])new Object[]{billNo}));
                this.operationResult.addErrorInfo(operateErrorInfo);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.failPks.size() > 0) {
            this.operationResult.setSuccess(false);
            this.operationResult.getSuccessPkIds().removeAll(this.failPks);
        }
    }
}

