/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.ImportSettleSaveValidator;
import kd.fi.arapcommon.vo.ImportSettleVo;

public class ArImportSettleSaveOp
extends AbstractOperationServicePlugIn {
    private final Map<String, Object> dataCache = new HashMap<String, Object>(2);
    private final QueryUtil queryUtil = new QueryUtil();
    public static final String FINAPBILL = "billno,bizdate,org.number org,asstacttype,asstact.id asstact,currency.id,exchangerate,pricetaxtotal,detailentry.unlockamt unlockamt,basecurrency.id,exratetable.id,exratedate,quotation,id,billstatus";
    public static final String FINARBILL = "billno,bizdate,org.number org,asstacttype,asstact.id asstact,currency.id,exchangerate,recamount pricetaxtotal,entry.e_unlockamt unlockamt,basecurrency.id,exratetable.id,exratedate,quotation,id,billstatus";
    public static final String RECBILL = "billno,bizdate,payertype asstacttype,payer asstact,entry.e_settleorg.number org,currency.id,exchangerate,entry.e_receivableamt pricetaxtotal,entry.e_unsettledamt unlockamt,basecurrency.id,exratetable.id,exratedate,quotation,id,billstatus,entry.e_receivingtype";
    public static final String PAYBILL = "billno,bizdate,payeetype asstacttype,payee asstact,entry.settleorg.number org,currency.id,exchangerate,entry.e_payableamt pricetaxtotal,entry.e_unsettledamt unlockamt,basecurrency.id,exratetable.id,exratedate,payquotation quotation,id,billstatus,entry.e_paymenttype";
    public static final String RECEIVEBILL = "billno,bizdate,org.number org,asstacttype,asstact.id asstact,currency.id,exchangerate,recamount pricetaxtotal,entry.e_unsettledamt unlockamt,basecurrency.id,exratetable.id,exratedate,quotation,id,billstatus";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("org");
        lst.add("settlerelation");
        lst.add("mainbillnum");
        lst.add("mainbizdate");
        lst.add("mainasstacttype");
        lst.add("mainasstactid");
        lst.add("maincurrency");
        lst.add("exchangerate");
        lst.add("mainpayableamt");
        lst.add("totalunsettledamt");
        lst.add("totalsettleamt");
        lst.add("localtotalsettleamt");
        lst.add("basecurrency");
        lst.add("exratetable");
        lst.add("exratedate");
        lst.add("quotation");
        lst.add("mainbillid");
        lst.add("billentity");
        lst.add("entry.billnum");
        lst.add("entry.billdate");
        lst.add("entry.asstacttype");
        lst.add("entry.asstactid");
        lst.add("entry.currency");
        lst.add("entry.e_exchangerate");
        lst.add("entry.payableamt");
        lst.add("entry.unsettledamt");
        lst.add("entry.settleamt");
        lst.add("entry.localsettleamt");
        lst.add("entry.e_basecurrency");
        lst.add("entry.e_exratetable");
        lst.add("entry.e_exratedate");
        lst.add("entry.e_quotation");
        lst.add("entry.billid");
        lst.add("entry.e_billentity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List<DynamicObject> importBills = Arrays.stream(dataEntities).collect(Collectors.toList());
        Map<String, Set<String>> billNoTypeGroup = this.getBillNoGroupByType(importBills);
        Map<String, Map<String, ImportSettleVo>> billMapGroupByType = this.getAllBills(billNoTypeGroup);
        this.putBillInfo(importBills, billMapGroupByType);
        e.addValidator((AbstractValidator)new ImportSettleSaveValidator(billMapGroupByType));
    }

    private void putBillInfo(List<DynamicObject> importBills, Map<String, Map<String, ImportSettleVo>> billMapGroupByType) {
        for (DynamicObject bill : importBills) {
            String relatation = bill.getString("settlerelation");
            List entityByRelation = SettleRelationEnum.getEntityByRelation((String)relatation);
            String mainEntity = (String)entityByRelation.get(0);
            String asstEntity = (String)entityByRelation.get(1);
            bill.set("billentity", (Object)mainEntity);
            Map<String, ImportSettleVo> mainBills = billMapGroupByType.get(mainEntity);
            Map<String, ImportSettleVo> asstBills = billMapGroupByType.get(asstEntity);
            Map<String, ImportSettleVo> receiveBills = billMapGroupByType.get("ar_receivedbill");
            ImportSettleVo mainBillVo = mainBills.get(bill.getString("mainbillnum"));
            if (mainBillVo == null) continue;
            String mainQuotation = mainBillVo.getQuotation();
            BigDecimal totalsettleamt = bill.getBigDecimal("totalsettleamt");
            BigDecimal mainExchangeRate = mainBillVo.getExchangerate();
            int mainPrecision = mainBillVo.getPrecision();
            bill.set("mainbizdate", (Object)mainBillVo.getBizdate());
            bill.set("mainasstacttype", (Object)mainBillVo.getAsstacttype());
            bill.set("exchangerate", (Object)mainExchangeRate);
            bill.set("mainpayableamt", (Object)mainBillVo.getPricetaxtotal());
            bill.set("totalunsettledamt", (Object)mainBillVo.getCanSettleamt());
            bill.set("localtotalsettleamt", (Object)QuotationHelper.getLocamtByQuotation((String)mainQuotation, (BigDecimal)totalsettleamt, (BigDecimal)mainExchangeRate, (int)mainPrecision));
            bill.set("mainbillid", (Object)mainBillVo.getId());
            DynamicObject mainCurrency = this.getBaseData("bd_currency", mainBillVo.getCurrencyId());
            DynamicObject mainBaseCurrency = this.getBaseData("bd_currency", mainBillVo.getBaseCurrencyId());
            DynamicObject mainAsstact = this.getBaseData(mainBillVo.getAsstacttype(), mainBillVo.getAssttactNumber());
            if (mainCurrency != null) {
                bill.set("maincurrency", (Object)mainCurrency);
            }
            if (mainBaseCurrency != null) {
                bill.set("basecurrency", (Object)mainBaseCurrency);
            }
            if (mainAsstact != null) {
                bill.set("mainasstactid", (Object)mainAsstact);
            }
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject asstBill : entry) {
                asstBill.set("e_billentity", (Object)asstEntity);
                String asstBillNo = (String)asstBill.get("billnum");
                ImportSettleVo asstBillVo = asstBills.get(asstBillNo);
                if (asstBillVo == null && "recsettle".equals(relatation)) {
                    asstBillVo = receiveBills.get(asstBillNo);
                    asstBill.set("e_billentity", (Object)"ar_receivedbill");
                }
                if (asstBillVo == null) continue;
                String asstQuotation = asstBillVo.getQuotation();
                BigDecimal asstExchangeRate = asstBillVo.getExchangerate();
                BigDecimal settleamt = asstBill.getBigDecimal("settleamt");
                int asstPrecision = asstBillVo.getPrecision();
                asstBill.set("billdate", (Object)asstBillVo.getBizdate());
                asstBill.set("asstacttype", (Object)asstBillVo.getAsstacttype());
                asstBill.set("e_exchangerate", (Object)asstExchangeRate);
                asstBill.set("payableamt", (Object)asstBillVo.getPricetaxtotal());
                asstBill.set("unsettledamt", (Object)asstBillVo.getCanSettleamt());
                asstBill.set("settleamt", (Object)settleamt);
                asstBill.set("localsettleamt", (Object)QuotationHelper.getLocamtByQuotation((String)asstQuotation, (BigDecimal)settleamt, (BigDecimal)asstExchangeRate, (int)asstPrecision));
                asstBill.set("billid", (Object)asstBillVo.getId());
                DynamicObject asstCurrency = this.getBaseData("bd_currency", asstBillVo.getCurrencyId());
                DynamicObject asstAsstact = this.getBaseData(asstBillVo.getAsstacttype(), asstBillVo.getAssttactNumber());
                if (asstCurrency != null) {
                    asstBill.set("currency", (Object)asstCurrency);
                }
                if (asstAsstact == null) continue;
                asstBill.set("asstactid", (Object)asstAsstact);
            }
        }
    }

    private Map<String, Set<String>> getBillNoGroupByType(List<DynamicObject> importBills) {
        HashMap<String, Set<String>> billGroupByType = new HashMap<String, Set<String>>(2);
        Map<String, List<DynamicObject>> settlerelation = importBills.stream().collect(Collectors.groupingBy(v -> v.getString("settlerelation")));
        HashSet<String> finApBillNos = new HashSet<String>(2);
        HashSet<String> finArBillNos = new HashSet<String>(2);
        HashSet<String> recBillNos = new HashSet<String>(2);
        HashSet<String> payBillNos = new HashSet<String>(2);
        for (Map.Entry<String, List<DynamicObject>> entry : settlerelation.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            switch (key) {
                case "appaysettle": {
                    this.getSettleBillNo(value, finApBillNos, payBillNos);
                    break;
                }
                case "payself": {
                    this.getSettleBillNo(value, payBillNos, payBillNos);
                    break;
                }
                case "apself": {
                    this.getSettleBillNo(value, finApBillNos, finApBillNos);
                    break;
                }
                case "aparsettle": {
                    this.getSettleBillNo(value, finApBillNos, finArBillNos);
                    break;
                }
                case "payrecsettle": {
                    this.getSettleBillNo(value, payBillNos, recBillNos);
                    break;
                }
                case "aprecsettle": {
                    this.getSettleBillNo(value, finApBillNos, recBillNos);
                    break;
                }
                case "recsettle": {
                    this.getSettleBillNo(value, finArBillNos, recBillNos);
                    break;
                }
                case "arself": {
                    this.getSettleBillNo(value, finArBillNos, finArBillNos);
                    break;
                }
                case "arapsettle": {
                    this.getSettleBillNo(value, finArBillNos, finApBillNos);
                    break;
                }
                case "recself": {
                    this.getSettleBillNo(value, recBillNos, recBillNos);
                    break;
                }
                case "recpaysettle": {
                    this.getSettleBillNo(value, recBillNos, payBillNos);
                    break;
                }
                case "arpaysettle": {
                    this.getSettleBillNo(value, finArBillNos, payBillNos);
                }
            }
        }
        billGroupByType.put("apbill", finApBillNos);
        billGroupByType.put("arbill", finArBillNos);
        billGroupByType.put("paybill", payBillNos);
        billGroupByType.put("recbill", recBillNos);
        return billGroupByType;
    }

    private void getSettleBillNo(List<DynamicObject> importBillDatas, Set<String> mainBillNos, Set<String> asstBillNos) {
        for (DynamicObject importBill : importBillDatas) {
            mainBillNos.add(importBill.getString("mainbillnum"));
            DynamicObjectCollection asstEntry = (DynamicObjectCollection)importBill.get("entry");
            for (DynamicObject entry : asstEntry) {
                asstBillNos.add(entry.getString("billnum"));
            }
        }
    }

    private Map<String, Map<String, ImportSettleVo>> getAllBills(Map<String, Set<String>> billNoGroupByType) {
        HashMap<String, Map<String, ImportSettleVo>> bills = new HashMap<String, Map<String, ImportSettleVo>>(2);
        Set<String> finApBillNo = billNoGroupByType.get("apbill");
        Set<String> finArBillNo = billNoGroupByType.get("arbill");
        Set<String> payBillNo = billNoGroupByType.get("paybill");
        Set<String> recBillNo = billNoGroupByType.get("recbill");
        if (finApBillNo.size() > 0) {
            Map<String, ImportSettleVo> finApBills = this.getBatchBillMap(finApBillNo, "ap_finapbill", FINAPBILL);
            bills.put("ap_finapbill", finApBills);
        }
        if (finArBillNo.size() > 0) {
            Map<String, ImportSettleVo> finArBills = this.getBatchBillMap(finArBillNo, "ar_finarbill", FINARBILL);
            bills.put("ar_finarbill", finArBills);
        }
        if (payBillNo.size() > 0) {
            Map<String, ImportSettleVo> payBills = this.getBatchBillMap(payBillNo, "cas_paybill", PAYBILL);
            bills.put("cas_paybill", payBills);
        }
        if (recBillNo.size() > 0) {
            Map<String, ImportSettleVo> recBills = this.getBatchBillMap(recBillNo, "cas_recbill", RECBILL);
            bills.put("cas_recbill", recBills);
            Map<String, ImportSettleVo> receivedBills = this.getBatchBillMap(recBillNo, "ar_receivedbill", RECEIVEBILL);
            bills.put("ar_receivedbill", receivedBills);
        }
        return bills;
    }

    public Map<String, ImportSettleVo> getBatchBillMap(Set<String> billNos, String entity, String selector) {
        Map<String, ImportSettleVo> importSettleVoMap = new HashMap<String, ImportSettleVo>(8);
        if (ObjectUtils.isEmpty(billNos) || StringUtils.isEmpty((String)entity) || StringUtils.isEmpty((String)selector)) {
            return importSettleVoMap;
        }
        QFilter qFilter = new QFilter("billno", "in", billNos);
        if ("cas_paybill".equals(entity)) {
            qFilter.and(new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
        } else if ("cas_recbill".equals(entity)) {
            qFilter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entity, (String)selector, (QFilter[])qFilter.toArray());
        Map<String, List<DynamicObject>> importSettleVos = bills.stream().collect(Collectors.groupingBy(v -> v.getString("billno")));
        importSettleVoMap = this.mergeBillByNo(importSettleVos, entity);
        return importSettleVoMap;
    }

    private Map<String, ImportSettleVo> mergeBillByNo(Map<String, List<DynamicObject>> importSettleVos, String entity) {
        HashMap<String, ImportSettleVo> importSettleVoMap = new HashMap<String, ImportSettleVo>(8);
        for (Map.Entry<String, List<DynamicObject>> entry : importSettleVos.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            DynamicObject bill = value.get(0);
            Long baseCurrencyId = bill.getLong("basecurrency.id");
            String currencyKey = "currency_" + baseCurrencyId;
            Object precision = this.dataCache.get(currencyKey);
            if (ObjectUtils.isEmpty((Object)precision)) {
                DynamicObject basecurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)baseCurrencyId, (String)"bd_currency");
                precision = basecurrency.get("amtprecision");
                this.dataCache.put(currencyKey, precision);
            }
            ImportSettleVo importSettleVo = new ImportSettleVo();
            importSettleVo.setBillno(bill.getString("billno"));
            importSettleVo.setBizdate(bill.getDate("bizdate"));
            importSettleVo.setCurrencyId(Long.valueOf(bill.getLong("currency.id")));
            importSettleVo.setExchangerate(bill.getBigDecimal("exchangerate"));
            importSettleVo.setBaseCurrencyId(Long.valueOf(bill.getLong("basecurrency.id")));
            importSettleVo.setPrecision(((Integer)precision).intValue());
            importSettleVo.setExratetableId(Long.valueOf(bill.getLong("exratetable.id")));
            importSettleVo.setExrateDate(bill.getDate("exratedate"));
            importSettleVo.setId(Long.valueOf(bill.getLong("id")));
            importSettleVo.setOrgName(bill.getString("org"));
            importSettleVo.setAsstacttype(bill.getString("asstacttype"));
            importSettleVo.setAssttactNumber(Long.valueOf(bill.getLong("asstact")));
            importSettleVo.setQuotation(bill.getString("quotation"));
            importSettleVo.setStatus(bill.getString("billstatus"));
            importSettleVo.setPricetaxtotal(bill.getBigDecimal("pricetaxtotal"));
            BigDecimal canSettleAmt = BigDecimal.ZERO;
            for (DynamicObject entryrow : value) {
                canSettleAmt = canSettleAmt.add(entryrow.getBigDecimal("unlockamt"));
            }
            importSettleVo.setCanSettleamt(canSettleAmt);
            if ("cas_paybill".equals(entity) || "cas_recbill".equals(entity)) {
                BigDecimal pricetaxtotal = BigDecimal.ZERO;
                for (DynamicObject entryrow : value) {
                    pricetaxtotal = pricetaxtotal.add(entryrow.getBigDecimal("pricetaxtotal"));
                }
                importSettleVo.setPricetaxtotal(pricetaxtotal);
            }
            importSettleVoMap.put(bill.getString("billno"), importSettleVo);
        }
        return importSettleVoMap;
    }

    private DynamicObject getBaseData(String entityType, Long pk) {
        return this.queryUtil.getBaseDataByPk(pk.longValue(), entityType);
    }
}

