/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.validator.PolicyUniqueValidator;
import kd.fi.arapcommon.enums.BillStatusEnum;

public class ArPolicyMulOrgSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PolicyUniqueValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject setting = e.getDataEntities()[0];
        DynamicObjectCollection mulOrgs = setting.getDynamicObjectCollection("orgs");
        List<DynamicObject> policyList = this.buildPolicy(mulOrgs, setting);
        this.operationResult.setBillCount(policyList.size());
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("settlemodel", setting.getString("settlemodel"));
        OperationResult saveOpResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_policy", (DynamicObject[])policyList.toArray(new DynamicObject[policyList.size()]), (OperateOption)operate);
        if (!saveOpResult.isSuccess()) {
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(saveOpResult.getMessage());
            ValidateResultCollection vColl = this.operationResult.getValidateResult();
            vColl.getValidateErrors().addAll(saveOpResult.getValidateResult().getValidateErrors());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!this.operationResult.isSuccess()) {
            ArrayList successPks = new ArrayList();
            for (Object obj : this.operationResult.getSuccessPkIds()) {
                if (ObjectUtils.isEmpty(obj)) continue;
                successPks.add(obj);
            }
            this.operationResult.setSuccessPkIds(successPks);
        }
    }

    private List<DynamicObject> buildPolicy(DynamicObjectCollection mulOrgs, DynamicObject setting) {
        ArrayList<DynamicObject> policyList = new ArrayList<DynamicObject>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ar_policy");
        long userId = RequestContext.get().getCurrUserId();
        Date currentDate = new Date();
        for (DynamicObject mulOrg : mulOrgs) {
            DynamicObject policy = new DynamicObject((DynamicObjectType)dt);
            Long orgPk = mulOrg.getLong("fbasedataid_id");
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgPk, (String)"bos_org");
            policy.set("useorg", (Object)org);
            policy.set("org", (Object)org);
            policy.set("createorg", (Object)org);
            policy.set("creator", (Object)userId);
            policy.set("modifier", (Object)userId);
            policy.set("enable", (Object)1);
            policy.set("createtime", (Object)currentDate);
            policy.set("modifytime", (Object)currentDate);
            policy.set("currency", setting.get("currency"));
            policy.set("exratetable", setting.get("exratetable"));
            policy.set("periodtype", setting.get("periodtype"));
            policy.set("baddebtpolicy", setting.get("baddebtpolicy"));
            policy.set("startperiod", setting.get("startperiod"));
            policy.set("policytype", setting.get("policytype"));
            policy.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            policyList.add(policy);
        }
        return policyList;
    }
}

