/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class ArPolicySaveOp
extends AbstractOperationServicePlugIn {
    private MainEntityType dt = null;
    private String userID = null;
    private Date currentDate = new Date();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (!this.operateOption.containsVariable("status")) {
            for (DynamicObject base : e.getDataEntities()) {
                DynamicObject org = base.getDynamicObject("org");
                DynamicObject policytype = base.getDynamicObject("policytype");
                base.set("number", (Object)(org.getString("number") + "_" + policytype.getString("number")));
                base.set("name", (Object)(org.getLocaleString("name").getLocaleValue() + "_" + policytype.getLocaleString("name").getLocaleValue()));
                base.set("status", (Object)BillStatusEnum.AUDIT.getValue());
                base.set("enable", (Object)1);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] policys;
        super.endOperationTransaction(e);
        this.dt = EntityMetadataCache.getDataEntityType((String)"ar_init");
        this.userID = String.valueOf(RequestContext.get().getCurrUserId());
        ArrayList<DynamicObject> destList = new ArrayList<DynamicObject>();
        for (DynamicObject policy : policys = e.getDataEntities()) {
            boolean exists;
            QFilter qFilter = new QFilter("policyid", "=", policy.getPkValue());
            if (this.operateOption.containsVariable("status") && OperationStatus.EDIT.name().equals(this.operateOption.getVariableValue("status"))) {
                DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"id", (QFilter[])new QFilter[]{qFilter});
                init = BusinessDataServiceHelper.loadSingle((Object)init.getPkValue(), (String)"ar_init");
                init.set("standardcurrency", (Object)policy.getDynamicObject("currency"));
                init.set("exratetable", (Object)policy.getDynamicObject("exratetable"));
                init.set("periodtype", (Object)policy.getDynamicObject("periodtype"));
                DynamicObject period = policy.getDynamicObject("startperiod");
                init.set("startperiod", (Object)period);
                init.set("startdate", (Object)period.getDate("begindate"));
                init.set("baddebtpolicy", (Object)policy.getString("baddebtpolicy"));
                init.set("settlemodel", (Object)this.operateOption.getVariableValue("settlemodel"));
                destList.add(init);
            } else if (BillStatusEnum.AUDIT.getValue().equals(policy.getString("status")) && policy.getBoolean("enable") && !(exists = QueryServiceHelper.exists((String)"ar_init", (QFilter[])new QFilter[]{qFilter}))) {
                DynamicObject init = this.buildInit(policy);
                destList.add(init);
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("ar_003", this.operateOption.getVariableValue("settlemodel"));
            SystemParameterHelper.setSystemParameter((boolean)true, (long)policy.getLong("org.id"), paramMap);
        }
        if (!destList.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)this.dt, (Object[])destList.toArray());
        }
    }

    private DynamicObject buildInit(DynamicObject policy) {
        String settlemodel = this.operateOption.getVariableValue("settlemodel");
        DynamicObject init = new DynamicObject((DynamicObjectType)this.dt);
        init.set("org", (Object)policy.getDynamicObject("org"));
        init.set("policytype", (Object)policy.getDynamicObject("policytype"));
        init.set("standardcurrency", (Object)policy.getDynamicObject("currency"));
        init.set("exratetable", (Object)policy.getDynamicObject("exratetable"));
        init.set("periodtype", (Object)policy.getDynamicObject("periodtype"));
        DynamicObject period = policy.getDynamicObject("startperiod");
        init.set("startperiod", (Object)period);
        init.set("startdate", (Object)period.getDate("begindate"));
        init.set("baddebtpolicy", (Object)policy.getString("baddebtpolicy"));
        init.set("isfinishinit", (Object)Boolean.FALSE);
        init.set("policyid", policy.getPkValue());
        init.set("creator", (Object)Long.valueOf(this.userID));
        init.set("createtime", (Object)this.currentDate);
        init.set("settlemodel", (Object)(settlemodel == null ? "2" : settlemodel));
        return init;
    }
}

