/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.validator.RevInventoryCostValidator;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArRevInventoryCostAcquireOp
extends AbstractOperationServicePlugIn {
    protected static Log logger = LogFactory.getLog(ArRevInventoryCostAcquireOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        ArrayList<String> selectors = new ArrayList<String>(10);
        selectors.add("isvoucher");
        selectors.add("verifystatus");
        selectors.add("e_inventorycost");
        selectors.add("inventorycost");
        selectors.add("hadwrittenoff");
        selectors.add("iswrittenoff");
        e.getFieldKeys().addAll(selectors);
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RevInventoryCostValidator());
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<Long> revcfmIds = Arrays.asList(e.getDataEntities()).stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        List<Long> verifyRecordIds = this.executeVerifyInventoryCostAcquire(revcfmIds);
        Map revcfmCostMap = VerifyServiceHelper.getRevcfmInventoryCost(verifyRecordIds);
        if (EmptyUtils.isEmpty((Object)revcfmCostMap)) {
            return;
        }
        HashMap<Long, DynamicObject> revcfmEntityMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject entity2 : e.getDataEntities()) {
            revcfmEntityMap.put(entity2.getLong("id"), entity2);
        }
        for (Long id : revcfmIds) {
            Map rowCost = (Map)revcfmCostMap.get(id);
            if (EmptyUtils.isEmpty((Object)rowCost)) continue;
            this.setInventoryCost(rowCost, (DynamicObject)revcfmEntityMap.get(id));
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
    }

    private void setInventoryCost(Map<Long, BigDecimal> rowCost, DynamicObject dynamicObject) {
        DynamicObjectCollection rowEntityList = dynamicObject.getDynamicObjectCollection("entry");
        BigDecimal totalInventoryCost = BigDecimal.ZERO;
        for (DynamicObject rowEntity : rowEntityList) {
            long rowBillId = rowEntity.getLong("id");
            BigDecimal inventoryCost = rowCost.get(rowBillId);
            if (inventoryCost == null) continue;
            rowEntity.set("e_inventorycost", (Object)inventoryCost);
            totalInventoryCost = totalInventoryCost.add(inventoryCost);
        }
        dynamicObject.set("inventorycost", (Object)totalInventoryCost);
    }

    private List<Long> executeVerifyInventoryCostAcquire(List<Long> revcfmIds) {
        QFilter filter = new QFilter("entry.e_billid", "in", revcfmIds);
        filter.and(new QFilter("entry.e_billtype", "=", (Object)"ar_revcfmbill"));
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])revcfmIds.toArray(), (boolean)true);
        filter.and(commonFilter);
        DynamicObject[] dataList = BusinessDataServiceHelper.load((String)"cal_salwfrecord", (String)"id", (QFilter[])new QFilter[]{filter});
        List<Long> verifyRecordIds = Arrays.asList(dataList).stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        logger.info("ArRevInventoryCostAcquireOp verifyRecordIds::" + JSON.toJSONString(verifyRecordIds));
        OperationServiceHelper.executeOperate((String)"getinventorycost", (String)"cal_salwfrecord", (Object[])verifyRecordIds.toArray(), (OperateOption)OperateOption.create());
        return verifyRecordIds;
    }
}

