/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.mservice.verify.ArSaloutAutoVerifyService;
import kd.fi.ar.mservice.writtenoffverify.ArWrittenOffVerifyService;
import kd.fi.arapcommon.enums.ARVerifyStatusEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.service.verify.ArRevWrittenOffVerifyService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.RedVerifyRecordParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArRevcfmBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ArRevcfmBillAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("billno");
        fieldKeys.add("bizdate");
        fieldKeys.add("duedate");
        fieldKeys.add("asstacttype");
        fieldKeys.add("asstact");
        fieldKeys.add("billtype");
        fieldKeys.add("amount");
        fieldKeys.add("recamount");
        fieldKeys.add("currency");
        fieldKeys.add("exchangerate");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("e_amount");
        fieldKeys.add("e_localamt");
        fieldKeys.add("e_tax");
        fieldKeys.add("e_recamount");
        fieldKeys.add("e_reclocalamt");
        fieldKeys.add("e_material");
        fieldKeys.add("e_corebillno");
        fieldKeys.add("e_corebillentryseq");
        fieldKeys.add("e_corebilltype");
        fieldKeys.add("asstact");
        fieldKeys.add("verifystatus");
        fieldKeys.add("e_expenseitem");
        fieldKeys.add("e_measureunit");
        fieldKeys.add("e_verifiedamt");
        fieldKeys.add("e_unverifyamt");
        fieldKeys.add("e_quantity");
        fieldKeys.add("e_verifiedqty");
        fieldKeys.add("e_unverifyqty");
        fieldKeys.add("e_ispresent");
        fieldKeys.add("e_baseunit");
        fieldKeys.add("e_baseunitqty");
        fieldKeys.add("e_unitcoefficient");
        fieldKeys.add("e_unitprice");
        fieldKeys.add("e_actunitprice");
        fieldKeys.add("e_sourcebillid");
        fieldKeys.add("e_sourcebillentryid");
        fieldKeys.add("e_confirmamt");
        fieldKeys.add("e_confirmqty");
        fieldKeys.add("e_isallverify");
        fieldKeys.add("basecurrency");
        fieldKeys.add("e_acttaxunitprice");
        fieldKeys.add("bookdate");
        fieldKeys.add("remark");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("iswrittenoff");
        fieldKeys.add("quotation");
        fieldKeys.add("e_materialversion");
        fieldKeys.add("e_spectype");
        fieldKeys.add("e_assistantattr");
        fieldKeys.add("configuredcode");
        fieldKeys.add("tracknumber");
        fieldKeys.add("verifystatus");
        fieldKeys.add("e_corebillid");
        fieldKeys.add("e_corebillentryid");
        fieldKeys.add("linetype");
        fieldKeys.add("billsrctype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        BookDateHelper.setBookDate((DynamicObject[])entities, (boolean)true);
        this.writtenOffBillSetDate(entities);
        this.updateUnitCoefficient(e.getDataEntities());
    }

    private void writtenOffBillSetDate(DynamicObject[] entities) {
        Long sourceId;
        HashSet<Long> sourceRevcmBillIds = new HashSet<Long>(entities.length);
        for (DynamicObject entity : entities) {
            boolean isWrittenOff = entity.getBoolean("iswrittenoff");
            if (!isWrittenOff) continue;
            sourceId = entity.getLong("sourcebillid");
            sourceRevcmBillIds.add(sourceId);
        }
        if (sourceRevcmBillIds.size() != 0) {
            Map<Long, DynamicObject> sourceRevcBillToWOFinBillMap = this.getSourceRevCfmBillIdToWOFinBillMap(sourceRevcmBillIds);
            for (DynamicObject revcmBill : entities) {
                sourceId = revcmBill.getLong("sourcebillid");
                DynamicObject writtenOffFinBill = sourceRevcBillToWOFinBillMap.get(sourceId);
                if (writtenOffFinBill == null) continue;
                Date finBizDate = writtenOffFinBill.getDate("bizdate");
                Date finBookDate = writtenOffFinBill.getDate("bookdate");
                revcmBill.set("bizdate", (Object)finBizDate);
                revcmBill.set("bookdate", (Object)finBookDate);
            }
        }
    }

    private Map<Long, DynamicObject> getSourceRevCfmBillIdToWOFinBillMap(Set<Long> sourceRevCfmBillIds) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        if (EmptyUtils.isEmpty(sourceRevCfmBillIds)) {
            return result;
        }
        Map revCfmBillToSourceFinBillIdMap = BOTPHelper.findDirectSourceBillMap((String)"ar_revcfmbill", (String)"ar_finarbill", sourceRevCfmBillIds);
        HashSet allFinBillIds = new HashSet(16);
        for (Set value : revCfmBillToSourceFinBillIdMap.values()) {
            Set valueStr = value.stream().map(String::valueOf).collect(Collectors.toSet());
            allFinBillIds.addAll(valueStr);
        }
        if (EmptyUtils.isEmpty(allFinBillIds)) {
            return result;
        }
        DynamicObjectCollection writtenOffFinBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id, sourcebillid,bizdate,bookdate", (QFilter[])new QFilter[]{new QFilter("iswrittenoff", "=", (Object)Boolean.TRUE), new QFilter("sourcebillid", "in", allFinBillIds)});
        for (DynamicObject writtenFinBill : writtenOffFinBills) {
            long sourceBillId = writtenFinBill.getLong("sourcebillid");
            Set<Long> revCfmBillIds = this.finRevCfmBillId(revCfmBillToSourceFinBillIdMap, sourceBillId);
            if (revCfmBillIds.size() == 0) continue;
            for (Long revCfmBillId : revCfmBillIds) {
                result.put(revCfmBillId, writtenFinBill);
            }
        }
        return result;
    }

    private Set<Long> finRevCfmBillId(Map<Long, Set<Long>> revCfmBillToSourceFinBillIdMap, long sourceBillId) {
        HashSet<Long> revCfmBillIds = new HashSet<Long>(revCfmBillToSourceFinBillIdMap.size());
        for (Map.Entry<Long, Set<Long>> entry : revCfmBillToSourceFinBillIdMap.entrySet()) {
            if (!entry.getValue().contains(sourceBillId)) continue;
            revCfmBillIds.add(entry.getKey());
        }
        return revCfmBillIds;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        long start = System.currentTimeMillis();
        this.autoVerify(entities);
        long end = System.currentTimeMillis();
        logger.info("arautoverify spend " + (end - start));
        ArWrittenOffVerifyService writtenOffVerifyService = new ArWrittenOffVerifyService();
        for (DynamicObject entity2 : entities) {
            if (!entity2.getBoolean("iswrittenoff") || VerifyServiceHelper.getExcludeBillTypeNum().contains(entity2.getString("billtype.number"))) continue;
            RedVerifyRecordParam redVerifyRecordParam = new RedVerifyRecordParam();
            redVerifyRecordParam.setRemark(entity2.getString("remark"));
            redVerifyRecordParam.setBillId(entity2.getLong("id"));
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            orgIds.add(entity2.getLong("org.id"));
            long srcBillID = entity2.getLong("sourcebillid");
            redVerifyRecordParam.setOrgIds(orgIds);
            redVerifyRecordParam.setSourcebillId(srcBillID);
            redVerifyRecordParam.setBookDate(entity2.getDate("bookdate"));
            redVerifyRecordParam.setBizDate(entity2.getDate("bizdate"));
            List<Long> verifyRecordIds = this.getVerifyRecordIds(srcBillID);
            if (verifyRecordIds.size() > 0) {
                Long id = entity2.getLong("id");
                VerifyServiceHelper.writtenOffVs((RedVerifyRecordParam)redVerifyRecordParam, verifyRecordIds, (Long)id);
                continue;
            }
            writtenOffVerifyService.finGenerateRedVerifyRecord(redVerifyRecordParam, entities[0].getDataEntityType().getName());
            writtenOffVerifyService.finWrittenOffVerify(redVerifyRecordParam, entities[0].getDataEntityType().getName(), false);
        }
        List<DynamicObject> writeOffBills = Stream.of(entities).filter(entity -> entity.getBoolean("iswrittenoff")).collect(Collectors.toList());
        logger.info("ArRevcfmBillAuditOp.endOperationTransaction ArRevWriteOffVerify start");
        this.executeArRevWriteOffVerify(writeOffBills);
        logger.info("ArRevcfmBillAuditOp.endOperationTransaction ArRevWriteOffVerify end");
        ArrayList params = new ArrayList();
        ArApProcessParamsHelper.processRevcfmToSmParams(params, (DynamicObject[])entities, (boolean)true);
        Settle4ScmcHelper.disposeArRevcfmToSalOrder(params);
    }

    private void executeArRevWriteOffVerify(List<DynamicObject> writeOffBills) {
        ArRevWrittenOffVerifyService arRevWrittenOffVerifyService = new ArRevWrittenOffVerifyService(false);
        arRevWrittenOffVerifyService.writtenOffVerify(writeOffBills);
    }

    private void newVerify(RedVerifyRecordParam redVerifyRecordParam, List<Long> verifyRecordIds) {
        HashMap<String, Object> schemaMap = new HashMap<String, Object>(2);
        schemaMap.put("recordType", "cal_salwfrecord");
        schemaMap.put("recordPk", verifyRecordIds);
        schemaMap.put("caBillType", "ar_revcfmbill");
        schemaMap.put("bookDate", redVerifyRecordParam.getBookDate());
        schemaMap.put("bizDate", redVerifyRecordParam.getBizDate());
        schemaMap.put("remark", redVerifyRecordParam.getRemark());
        HashMap<Long, Long> caBillIdMapping = new HashMap<Long, Long>(2);
        caBillIdMapping.put(redVerifyRecordParam.getSourcebillId(), redVerifyRecordParam.getBillId());
        schemaMap.put("caBillIdMapping", caBillIdMapping);
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"chargeAgainstRecord", (Object[])new Object[]{schemaMap});
    }

    private List<Long> getVerifyRecordIds(Long id) {
        ArrayList<Long> verifyRecordIds = new ArrayList<Long>(2);
        QFilter asstFilter = new QFilter("entry.e_billid", "in", (Object)id);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])new Long[]{id}, (boolean)true);
        asstFilter.and(commonFilter);
        DataSet recordAssts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ar_verifyrecord", (String)"id,writeofftypeid", (QFilter[])new QFilter[]{asstFilter}, null);
        for (Row record : recordAssts) {
            Long writeoffTypeId = record.getLong("writeofftypeid");
            if (writeoffTypeId == null || writeoffTypeId == 0L) continue;
            verifyRecordIds.add(record.getLong("id"));
        }
        return verifyRecordIds;
    }

    /*
     * WARNING - void declaration
     */
    private void autoVerify(DynamicObject[] entities) {
        Set salOutBillIds;
        ArrayList<DynamicObject> arBills = new ArrayList<DynamicObject>(entities.length);
        HashSet<Long> arBillPks = new HashSet<Long>(entities.length);
        HashSet<Long> revBillPksHasSour = new HashSet<Long>(entities.length);
        HashSet<Long> revBillEntryIdsHasSour = new HashSet<Long>(entities.length);
        List finArBills = CommonVerifyServiceHelper.filterVerifyEntity((DynamicObject[])entities);
        for (DynamicObject entity : finArBills) {
            String verifyStatus = entity.getString("verifystatus");
            String sourceBillType = entity.getString("sourcebilltype");
            String string = entity.getString("billtype.number");
            if (ARVerifyStatusEnum.VERIFIED.getValue().equals(verifyStatus) || "ar_revcfmbill".equals(sourceBillType) || "sm_salorder".equals(sourceBillType)) continue;
            if (VerifyServiceHelper.getVerifyBillTypeNum().contains(string)) {
                arBills.add(entity);
                arBillPks.add(entity.getLong("id"));
            }
            if (StringUtils.isEmpty((String)sourceBillType) || VerifyServiceHelper.getExcludeBillTypeNum().contains(string)) continue;
            revBillPksHasSour.add(entity.getLong("id"));
            DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : entryColl) {
                revBillEntryIdsHasSour.add(dynamicObject.getLong("id"));
            }
        }
        if (revBillPksHasSour.size() > 0) {
            Map srcIdMap = BOTPHelper.loadNearUpBillIds((String)"ar_revcfmbill", (String)"entry", (Long[])revBillPksHasSour.toArray(new Long[0]), (Long[])revBillEntryIdsHasSour.toArray(new Long[0]), (String)"im_saloutbill");
            HashSet indirectSrcSalIds = new HashSet(16);
            HashSet<Long> logisticBillIds = new HashSet<Long>(16);
            for (Map.Entry entry : srcIdMap.entrySet()) {
                indirectSrcSalIds.addAll((Collection)entry.getValue());
            }
            if (indirectSrcSalIds.size() > 0) {
                DynamicObjectCollection logisticBills = QueryServiceHelper.query((String)"im_saloutbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", indirectSrcSalIds), new QFilter("billentry.logisticsbill", "=", (Object)Boolean.TRUE)});
                for (DynamicObject purBill : logisticBills) {
                    logisticBillIds.add(purBill.getLong("id"));
                }
            }
            if (srcIdMap != null && srcIdMap.size() > 0) {
                void var14_23;
                logger.info("ArRevcfmBillAuditOp-autoVerify-botp:" + srcIdMap);
                HashSet<Long> arBillIds = new HashSet<Long>(srcIdMap.size());
                HashSet<Long> hashSet = new HashSet<Long>(arBillIds.size());
                Set entrySet = srcIdMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    boolean partVerify = true;
                    List purBillIds = (List)entry.getValue();
                    for (Long purId : purBillIds) {
                        if (!logisticBillIds.contains(purId)) continue;
                        partVerify = false;
                        break;
                    }
                    if (!partVerify) continue;
                    arBillIds.add((Long)entry.getKey());
                    hashSet.addAll((Collection)entry.getValue());
                }
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setOnlyByBotp(true);
                this.doAutoVerify(hashSet, arBillIds, scheme);
                ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0030", null, (Object[])new Object[]{"ar_revcfmbill", arBillIds});
                arBillPks.removeAll(arBillIds);
                int n = arBills.size() - 1;
                while (var14_23 >= 0) {
                    DynamicObject arBill = (DynamicObject)arBills.get((int)var14_23);
                    long id = arBill.getLong("id");
                    if (arBillIds.contains(id)) {
                        arBills.remove((int)var14_23);
                    }
                    --var14_23;
                }
            }
        }
        if (arBillPks.size() > 0 && !(salOutBillIds = VerifyServiceHelper.getSalBillIdsByCoreBill((DynamicObject[])arBills.toArray(new DynamicObject[0]))).isEmpty()) {
            logger.info("ArRevcfmBillAuditOp-autoVerify-corebill:" + salOutBillIds + "-" + arBillPks);
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setOnlyByCoreBill(true);
            this.doAutoVerify(salOutBillIds, arBillPks, scheme);
        }
    }

    private void doAutoVerify(Set<Long> mainIds, Set<Long> asstIds, SettleSchemeVO scheme) {
        CommonVerifyServiceHelper.verifyAddMutexCtrlInTX(mainIds, (String)"im_saloutbill", asstIds, (String)"ar_revcfmbill", (boolean)true);
        ArSaloutAutoVerifyService verifyService = new ArSaloutAutoVerifyService("im_saloutbill", mainIds);
        verifyService.autoVerify(mainIds, asstIds, scheme);
    }

    private void updateUnitCoefficient(DynamicObject[] finBills) {
        HashMap<String, BigDecimal> covertRateCacheMap = new HashMap<String, BigDecimal>(2);
        for (DynamicObject finBill : finBills) {
            DynamicObjectCollection details = finBill.getDynamicObjectCollection("entry");
            for (DynamicObject detailRow : details) {
                if (BigDecimal.ZERO.compareTo(detailRow.getBigDecimal("e_unitcoefficient")) != 0) continue;
                DynamicObject material = detailRow.getDynamicObject("e_material");
                DynamicObject measureUnit = detailRow.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = null;
                BigDecimal covertRate = null;
                if (!ObjectUtils.isEmpty((Object)material)) {
                    String key;
                    baseUnit = material.getDynamicObject("baseunit");
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if ((covertRate = (BigDecimal)covertRateCacheMap.get(key = String.format("%s_%s_%s", material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id")))) == null) {
                        covertRate = InitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)measureUnit.getLong("id"), (Long)baseUnit.getLong("id"));
                        covertRate = covertRate == null ? BigDecimal.ONE : covertRate;
                        covertRateCacheMap.put(key, covertRate);
                    }
                } else {
                    covertRate = BigDecimal.ONE;
                }
                detailRow.set("e_unitcoefficient", (Object)covertRate);
            }
        }
    }
}

