/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.validator.VerifyInventoryCostValidator;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArVerifyInventoryCostAcquireOp
extends AbstractOperationServicePlugIn {
    protected static Log logger = LogFactory.getLog(ArVerifyInventoryCostAcquireOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new VerifyInventoryCostValidator());
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        ArrayList<String> selectors = new ArrayList<String>(10);
        selectors.add("verifybaseqty");
        selectors.add("org");
        selectors.add("e_qty");
        selectors.add("isvoucher");
        selectors.add("e_verifybaseqty");
        selectors.add("currency");
        selectors.add("basecurrency");
        selectors.add("inventorycost");
        selectors.add("e_inventorycost");
        selectors.add("entry");
        selectors.add("baseactualcost");
        selectors.add("e_baseactualcost");
        selectors.add("verifyrelation");
        selectors.add("e_iswrittenoff");
        selectors.add("e_hadwrittenoff");
        selectors.add("billid");
        selectors.add("writeofftypeid");
        selectors.add("producttype");
        selectors.add("pid");
        selectors.add("verifyseq");
        e.getFieldKeys().addAll(selectors);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> verifyRecordIds = new ArrayList<Long>(16);
        ArrayList<Long> mainBillIds = new ArrayList<Long>(16);
        HashMap<Long, Map> verifyRecordSeqMap = new HashMap<Long, Map>(16);
        HashMap<Long, Set> sameKeyMap = new HashMap<Long, Set>(16);
        for (DynamicObject data : dataEntities) {
            Integer verifyseq;
            Long l = data.getLong("id");
            DynamicObject wfType = data.getDynamicObject("writeofftypeid");
            if (wfType == null || wfType.getLong("id") == 0L || !data.containsProperty("producttype") || !"kitparent".equals(data.getString("producttype"))) {
                verifyRecordIds.add(l);
                mainBillIds.add(data.getLong("billid"));
                continue;
            }
            Long pid = data.getLong("pid");
            Map seqMap = verifyRecordSeqMap.computeIfAbsent(pid, v -> new HashMap(2));
            Long seqMapId = (Long)seqMap.get(verifyseq = Integer.valueOf(data.getInt("verifyseq")));
            if (seqMapId == null) {
                seqMap.put(verifyseq, l);
            } else {
                Set sameKeyIdSet = sameKeyMap.computeIfAbsent(seqMapId, v -> new HashSet(2));
                sameKeyIdSet.add(l);
                sameKeyMap.put(seqMapId, sameKeyIdSet);
            }
            verifyRecordSeqMap.put(pid, seqMap);
        }
        HashMap verifyActualCostMap = new HashMap(16);
        if (!verifyRecordIds.isEmpty()) {
            verifyActualCostMap.putAll(VerifyServiceHelper.getCostRecordActualCost(verifyRecordIds, mainBillIds));
            logger.info("ArVerifyInventoryCostAcquireOp old data, verifyActualCostMap:" + JSON.toJSONString(verifyActualCostMap));
        }
        if (!verifyRecordSeqMap.isEmpty()) {
            logger.info("ArVerifyInventoryCostAcquireOp verifyRecordSeqMap:" + JSON.toJSONString(verifyRecordSeqMap));
            DynamicObjectCollection childVerifyRecords = QueryServiceHelper.query((String)"cal_salwfrecord", (String)"id,pid,producttype,verifyseq", (QFilter[])new QFilter[]{new QFilter("pid", "in", verifyRecordSeqMap.keySet()), new QFilter("producttype", "=", (Object)"kitchild")});
            HashMap<Long, Set<Object>> parentAndChildIdMap = new HashMap<Long, Set<Object>>(16);
            for (DynamicObject dynamicObject : childVerifyRecords) {
                Long pid = dynamicObject.getLong("pid");
                Map seqMap = (Map)verifyRecordSeqMap.get(pid);
                Integer verifyseq = dynamicObject.getInt("verifyseq");
                Long parentId = (Long)seqMap.get(verifyseq);
                Set children = parentAndChildIdMap.computeIfAbsent(parentId, v -> new HashSet(2));
                Long childId = dynamicObject.getLong("id");
                children.add(childId);
                parentAndChildIdMap.put(parentId, children);
            }
            if (!sameKeyMap.isEmpty()) {
                for (Map.Entry entry : sameKeyMap.entrySet()) {
                    Long key = (Long)entry.getKey();
                    for (Long sameKeyId : (Set)entry.getValue()) {
                        parentAndChildIdMap.put(sameKeyId, (Set<Object>)parentAndChildIdMap.get(key));
                    }
                }
            }
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)"CalWriteOffParentCostService");){
                try {
                    logger.info("CalWriteOffParentCostService begin. Request param:" + JSON.toJSONString(parentAndChildIdMap));
                    Map invokeResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalWriteOffParentCostService", (String)"getParentCost", (Object[])new Object[]{parentAndChildIdMap});
                    logger.info("CalWriteOffParentCostService end. Response msg:" + JSON.toJSONString((Object)invokeResult));
                    verifyActualCostMap.putAll(invokeResult);
                }
                catch (Exception ex) {
                    tx.markRollback();
                    logger.error("CalWriteOffParentCostService invokeBizService ex.getMessage:" + ex.getMessage());
                    throw ex;
                }
            }
            catch (Throwable ex) {
                Throwable throwable2 = ex;
                throw ex;
            }
        }
        if (verifyActualCostMap.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dataEntities) {
            long verifyRecordId = dynamicObject.getLong("id");
            Map actualCost = (Map)verifyActualCostMap.get(verifyRecordId);
            if (EmptyUtils.isEmpty((Object)actualCost)) continue;
            int pricePrecition = this.getCurrencyPrecition(dynamicObject, true);
            BigDecimal baseUnitActualCost = ((BigDecimal)actualCost.get("baseUnitActualCost")).setScale(pricePrecition, RoundingMode.HALF_UP);
            dynamicObject.set("baseactualcost", (Object)baseUnitActualCost);
            int amtPrecition = this.getCurrencyPrecition(dynamicObject, false);
            BigDecimal mainInventoryCost = ((BigDecimal)actualCost.get("actualCost")).setScale(amtPrecition, RoundingMode.HALF_UP);
            dynamicObject.set("inventorycost", (Object)mainInventoryCost);
            this.setVerifyEntryInventoryCost(dynamicObject, baseUnitActualCost, mainInventoryCost);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private int getCurrencyPrecition(DynamicObject entity, boolean isPrice) {
        DynamicObject currency = entity.getDynamicObject("basecurrency");
        String precision = "amtprecision";
        if (isPrice) {
            precision = "priceprecision";
        }
        return currency.getInt(precision);
    }

    private void setVerifyEntryInventoryCost(DynamicObject entity, BigDecimal baseUnitActualCost, BigDecimal mainInventoryCost) {
        DynamicObjectCollection list = entity.getDynamicObjectCollection("entry");
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject entry = (DynamicObject)list.get(i);
            entry.set("e_baseactualcost", (Object)baseUnitActualCost);
            entry.set("e_inventorycost", (Object)mainInventoryCost);
        }
    }
}

