/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.consts.BillTypeConsts;
import kd.fi.ar.enums.ConfirmModeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class BaddebtConfirmOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(BaddebtConfirmOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject confirm = e.getDataEntities()[0];
        DynamicObjectCollection entries = confirm.getDynamicObjectCollection("entryentity");
        ArrayList<Long> pks = new ArrayList<Long>(entries.size());
        for (DynamicObject entry : entries) {
            pks.add(entry.getLong("g_sourcebillid"));
        }
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"org,currency,basecurrency,exratetable,exratedate,quotation,billno,billtype,bizdate,exchangerate,asstacttype,asstact,recamount,entry.e_unlockamt,entry.e_material,entry.e_expenseitem,entry.e_recamount,planentity.planduedate,planentity.plansettletype,planentity.planpricetax,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        if (finBills == null) {
            return;
        }
        List<DynamicObject> destBills = this.buildBaddebtLoss(finBills, confirm, pks);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_baddebtlossbill", (DynamicObject[])destBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)saveResult);
    }

    private List<DynamicObject> buildBaddebtLoss(DynamicObject[] srcBills, DynamicObject confirm, List<Long> pks) {
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>(8);
        int ar003 = ArApHelper.getArSettleParam((Object)srcBills[0].getDynamicObject("org").getPkValue());
        String ruleId = "628174474734245888";
        if (ar003 == 2) {
            ruleId = "742037039666467840";
        }
        Map<Long, DynamicObject> srcBillPkDoMap = Arrays.stream(srcBills).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String bizdate = confirm.getString("bizdate");
        if (StringUtils.isEmpty((String)bizdate)) {
            bizdate = new Date().toString();
        }
        paramMap.put("baddebtbizdate", bizdate);
        Map pushResultMap = BOTPHelper.push4Result((String)"ar_finarbill", (String)"ar_baddebtlossbill", (String)ruleId, pks, paramMap);
        Object convertResult = pushResultMap.get("convertResult");
        List badLossBills = new ArrayList(8);
        if (convertResult != null) {
            ErrorCode ec = new ErrorCode("botp", ResManager.loadKDString((String)"\u574f\u8d26\u635f\u5931\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"BaddebtConfirmOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        badLossBills = (List)pushResultMap.get("trgBills");
        String mode = confirm.getString("mode");
        logger.info("confirm mode = " + mode);
        long billtypeID = 0L;
        if (ConfirmModeEnum.head.name().equals(mode)) {
            billtypeID = BillTypeConsts.LOSS_HEAD;
        } else if (ConfirmModeEnum.planEntry.name().equals(mode)) {
            billtypeID = BillTypeConsts.LOSS_PLANENTRY;
        } else if (ConfirmModeEnum.entry.name().equals(mode)) {
            billtypeID = BillTypeConsts.LOSS_ENTRY;
        }
        DynamicObject finBill0 = srcBills[0];
        Date exratedate = finBill0.getDate("exratedate");
        for (DynamicObject finBill : srcBills) {
            Date exratedateTemp = finBill.getDate("exratedate");
            exratedate = exratedate.after(exratedateTemp) ? exratedate : exratedateTemp;
        }
        DynamicObjectCollection confirmEntries = confirm.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> idEntryMap = this.getEntryInfo(mode, confirmEntries);
        HashMap srcIdAndEntriesId = new HashMap(8);
        HashMap srcIdAndPlanEntriesId = new HashMap(8);
        HashMap<Long, Long> srcEntryIdAndId = new HashMap<Long, Long>(8);
        HashMap<Long, Long> srcplanEntryIdAndId = new HashMap<Long, Long>(8);
        for (DynamicObject finBill : srcBills) {
            Long finBillId = finBill.getLong("id");
            DynamicObjectCollection entries = finBill.getDynamicObjectCollection("entry");
            HashSet<Long> entryIds = new HashSet<Long>(8);
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                srcEntryIdAndId.put(entryId, finBillId);
                entryIds.add(entryId);
            }
            srcIdAndEntriesId.put(finBillId, entryIds);
            DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
            HashSet<Long> planEntryIds = new HashSet<Long>(8);
            for (DynamicObject entry : planEntries) {
                Long entryId = entry.getLong("id");
                srcplanEntryIdAndId.put(entryId, finBillId);
                planEntryIds.add(entryId);
            }
            srcIdAndPlanEntriesId.put(finBillId, planEntryIds);
        }
        for (DynamicObject destBill : badLossBills) {
            BigDecimal lossAmt;
            Long srcId;
            BigDecimal finBillLossAmt;
            Long srcId2;
            BigDecimal baddebtLocalAmt;
            BigDecimal badDebtAmtSum;
            BigDecimal baddebtAmt;
            DynamicObject confirmEntry;
            HashSet finBillIds = new HashSet(8);
            DynamicObjectCollection entriesTemp = destBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entriesTemp) {
                finBillIds.add(srcEntryIdAndId.get(entry.getLong("e_srcentryid")));
            }
            boolean isMultiSrc = finBillIds.size() > 1;
            DynamicObject srcBill = srcBillPkDoMap.get(destBill.getLong("sourcebillid"));
            MainEntityType mainType = (MainEntityType)destBill.getDataEntityType();
            BasedataProp basedataProp = (BasedataProp)mainType.findProperty("billtype");
            destBill.set("billtype", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)billtypeID, (DynamicObjectType)((DynamicObjectType)basedataProp.getComplexType((Object)destBill))));
            destBill.set("billtype_id", (Object)billtypeID);
            if (isMultiSrc) {
                destBill.set("exratedate", (Object)exratedate);
            } else {
                destBill.set("exratedate", (Object)srcBill.getDate("exratedate"));
            }
            if (EmptyUtils.isEmpty((Object)destBill.getString("settlestatus"))) {
                destBill.set("settlestatus", (Object)"unsettle");
            }
            destBill.set("sourcebilltype", srcBill.getDynamicObject("billtype").getPkValue());
            int localprecision = srcBill.getDynamicObject("basecurrency").getInt("amtprecision");
            BigDecimal exRate = confirm.getBigDecimal("exchangerate");
            String quotation = confirm.getString("quotation");
            destBill.set("exchangerate", (Object)exRate);
            destBill.set("quotation", (Object)quotation);
            if (isMultiSrc) {
                BigDecimal recAmtSum = BigDecimal.ZERO;
                StringBuilder srcBillNoBuilder = new StringBuilder();
                for (DynamicObject finBill : srcBills) {
                    recAmtSum = recAmtSum.add(finBill.getBigDecimal("recamount"));
                    if (srcBillNoBuilder.length() > 0 && !"".equals(srcBillNoBuilder.toString())) {
                        srcBillNoBuilder.append('\u3001');
                    }
                    srcBillNoBuilder.append(finBill.getString("billno"));
                }
                destBill.set("recamt", (Object)recAmtSum);
                String srcBillNo = srcBillNoBuilder.toString();
                if (srcBillNo.length() > 255) {
                    srcBillNo = srcBillNo.substring(0, 254);
                }
                destBill.set("sourcebillno", (Object)srcBillNo);
            }
            if (ConfirmModeEnum.head.name().equals(mode)) {
                BigDecimal baddebtAmt2;
                Object confirmEntry2;
                BigDecimal badDebtSumAmt = BigDecimal.ZERO;
                BigDecimal badDebtSumLocalAmt = BigDecimal.ZERO;
                DynamicObjectCollection entries = destBill.getDynamicObjectCollection("entry");
                ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(8);
                for (Long srcId3 : finBillIds) {
                    confirmEntry2 = idEntryMap.get(srcId3);
                    baddebtAmt2 = confirmEntry2.getBigDecimal("e_baddebtamt");
                    badDebtSumAmt = badDebtSumAmt.add(baddebtAmt2);
                    badDebtSumLocalAmt = badDebtSumLocalAmt.add(confirmEntry2.getBigDecimal("e_baddebtlocamt"));
                }
                for (Long srcId3 : finBillIds) {
                    confirmEntry2 = idEntryMap.get(srcId3);
                    baddebtAmt2 = confirmEntry2.getBigDecimal("e_baddebtamt");
                    if (ar003 == 1) {
                        detailList.addAll(this.decomposeAmt(baddebtAmt2, exRate, quotation, entries, false, localprecision, (Set)srcIdAndEntriesId.get(srcId3)));
                        continue;
                    }
                    DynamicObject srcFinBill = srcBillPkDoMap.get(srcId3);
                    detailList.addAll(this.decomposeAmtByShare(baddebtAmt2, exRate, quotation, entries, false, localprecision, (Set)srcIdAndEntriesId.get(srcId3), srcFinBill));
                }
                if (detailList.size() > 0) {
                    entries.clear();
                    for (DynamicObject detail : detailList) {
                        entries.add((Object)detail);
                    }
                }
                DynamicObjectCollection planEntries = destBill.getDynamicObjectCollection("planentry");
                Iterator<DynamicObject> planList = new ArrayList(8);
                for (Long srcId4 : finBillIds) {
                    confirmEntry = idEntryMap.get(srcId4);
                    baddebtAmt = confirmEntry.getBigDecimal("e_baddebtamt");
                    planList.addAll(BaddebtConfirmOp.decomposeAmt2Plan(baddebtAmt, exRate, quotation, planEntries, false, localprecision, (Set)srcIdAndPlanEntriesId.get(srcId4)));
                }
                if (planEntries.size() != planList.size()) {
                    planEntries.clear();
                    confirmEntry2 = planList.iterator();
                    while (confirmEntry2.hasNext()) {
                        DynamicObject plan = (DynamicObject)confirmEntry2.next();
                        planEntries.add((Object)plan);
                    }
                }
                Long srcBillId = destBill.getLong("sourcebillid");
                DynamicObject confirmEntry0 = idEntryMap.get(srcBillId);
                destBill.set("baddebtcause", (Object)confirmEntry0.getString("e_baddebtcause"));
                destBill.set("baddebtamt", (Object)badDebtSumAmt);
                destBill.set("baddebtlocamt", (Object)badDebtSumLocalAmt.setScale(localprecision, RoundingMode.HALF_UP));
                destBill.set("remark", (Object)confirmEntry0.getString("e_remark"));
            }
            if (ConfirmModeEnum.entry.name().equals(mode)) {
                DynamicObjectCollection destEntries = destBill.getDynamicObjectCollection("entry");
                ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(8);
                badDebtAmtSum = BigDecimal.ZERO;
                BigDecimal badDebtLocalAmtSum = BigDecimal.ZERO;
                HashMap<Long, BigDecimal> srcIdAndSrcLossAmtSum = new HashMap<Long, BigDecimal>(8);
                for (DynamicObject destEntry : destEntries) {
                    Iterator srcPk = destEntry.getLong("e_srcentryid");
                    confirmEntry = idEntryMap.get(srcPk);
                    baddebtAmt = confirmEntry.getBigDecimal("e_baddebtamt");
                    baddebtLocalAmt = confirmEntry.getBigDecimal("e_baddebtlocamt").setScale(localprecision, RoundingMode.HALF_UP);
                    badDebtAmtSum = badDebtAmtSum.add(baddebtAmt);
                    badDebtLocalAmtSum = badDebtLocalAmtSum.add(baddebtLocalAmt);
                    srcId2 = (Long)srcEntryIdAndId.get(srcPk);
                    finBillLossAmt = (BigDecimal)srcIdAndSrcLossAmtSum.get(srcId2);
                    if (finBillLossAmt != null) {
                        finBillLossAmt = finBillLossAmt.add(baddebtAmt);
                        srcIdAndSrcLossAmtSum.put(srcId2, finBillLossAmt);
                    } else {
                        srcIdAndSrcLossAmtSum.put(srcId2, baddebtAmt);
                    }
                    destEntry.set("e_baddebtcause", (Object)confirmEntry.getString("e_baddebtcause"));
                    destEntry.set("e_baddebtamt", (Object)baddebtAmt);
                    destEntry.set("e_baddebtlocamt", (Object)baddebtLocalAmt);
                    destEntry.set("e_remark", (Object)confirmEntry.getString("e_remark"));
                    destEntry.set("e_unlockamt", (Object)destEntry.getBigDecimal("e_baddebtamt"));
                    destEntry.set("e_lockedamt", (Object)BigDecimal.ZERO);
                    destEntry.set("e_unsettleamt", (Object)destEntry.getBigDecimal("e_baddebtamt"));
                    detailList.add(destEntry);
                }
                if (destEntries.size() != detailList.size()) {
                    destEntries.clear();
                    for (DynamicObject detail : detailList) {
                        destEntries.add((Object)detail);
                    }
                }
                destBill.set("baddebtamt", (Object)badDebtAmtSum);
                destBill.set("baddebtlocamt", (Object)badDebtLocalAmtSum);
                DynamicObjectCollection planEntries = destBill.getDynamicObjectCollection("planentry");
                ArrayList<DynamicObject> planList = new ArrayList<DynamicObject>(8);
                for (Map.Entry disposeData : srcIdAndSrcLossAmtSum.entrySet()) {
                    srcId = (Long)disposeData.getKey();
                    lossAmt = (BigDecimal)disposeData.getValue();
                    planList.addAll(BaddebtConfirmOp.decomposeAmt2Plan(lossAmt, exRate, quotation, planEntries, false, localprecision, (Set)srcIdAndPlanEntriesId.get(srcId)));
                }
                if (planEntries.size() != planList.size()) {
                    planEntries.clear();
                    for (DynamicObject plan : planList) {
                        planEntries.add((Object)plan);
                    }
                }
            }
            if (ConfirmModeEnum.planEntry.name().equals(mode)) {
                DynamicObjectCollection destPlanEntries = destBill.getDynamicObjectCollection("planentry");
                ArrayList<DynamicObject> planList = new ArrayList<DynamicObject>(8);
                badDebtAmtSum = BigDecimal.ZERO;
                BigDecimal badDebtLocalAmtSum = BigDecimal.ZERO;
                HashMap<Long, BigDecimal> srcIdAndSrcLossAmtSum = new HashMap<Long, BigDecimal>(8);
                for (DynamicObject destPlanEntry : destPlanEntries) {
                    Long srcPlanPk = destPlanEntry.getLong("p_srcplanentryid");
                    confirmEntry = idEntryMap.get(srcPlanPk);
                    baddebtAmt = confirmEntry.getBigDecimal("e_baddebtamt");
                    baddebtLocalAmt = confirmEntry.getBigDecimal("e_baddebtlocamt").setScale(localprecision, RoundingMode.HALF_UP);
                    badDebtAmtSum = badDebtAmtSum.add(baddebtAmt);
                    badDebtLocalAmtSum = badDebtLocalAmtSum.add(baddebtLocalAmt);
                    srcId2 = (Long)srcplanEntryIdAndId.get(srcPlanPk);
                    finBillLossAmt = (BigDecimal)srcIdAndSrcLossAmtSum.get(srcId2);
                    if (finBillLossAmt != null) {
                        finBillLossAmt = finBillLossAmt.add(baddebtAmt);
                        srcIdAndSrcLossAmtSum.put(srcId2, finBillLossAmt);
                    } else {
                        srcIdAndSrcLossAmtSum.put(srcId2, baddebtAmt);
                    }
                    destPlanEntry.set("p_baddebtcause", (Object)confirmEntry.getString("e_baddebtcause"));
                    destPlanEntry.set("p_baddebtamt", (Object)baddebtAmt);
                    destPlanEntry.set("p_baddebtlocamt", (Object)baddebtLocalAmt);
                    destPlanEntry.set("p_remark", (Object)confirmEntry.getString("e_remark"));
                    destPlanEntry.set("p_unlockamt", (Object)destPlanEntry.getBigDecimal("p_baddebtamt"));
                    destPlanEntry.set("p_lockedamt", (Object)BigDecimal.ZERO);
                    destPlanEntry.set("p_unsettleamt", (Object)destPlanEntry.getBigDecimal("p_baddebtamt"));
                    planList.add(destPlanEntry);
                }
                if (destPlanEntries.size() != planList.size()) {
                    destPlanEntries.clear();
                    for (DynamicObject detail : planList) {
                        destPlanEntries.add((Object)detail);
                    }
                }
                destBill.set("baddebtamt", (Object)badDebtAmtSum);
                destBill.set("baddebtlocamt", (Object)badDebtLocalAmtSum);
                DynamicObjectCollection entries = destBill.getDynamicObjectCollection("entry");
                ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(8);
                for (Map.Entry disposeData : srcIdAndSrcLossAmtSum.entrySet()) {
                    srcId = (Long)disposeData.getKey();
                    lossAmt = (BigDecimal)disposeData.getValue();
                    detailList.addAll(this.decomposeAmtByShare(lossAmt, exRate, quotation, entries, false, localprecision, (Set)srcIdAndEntriesId.get(srcId), srcBillPkDoMap.get(srcId)));
                }
                if (entries.size() != detailList.size()) {
                    entries.clear();
                    for (DynamicObject detail : detailList) {
                        entries.add((Object)detail);
                    }
                }
            }
            destBill.set("unsettleamt", (Object)destBill.getBigDecimal("baddebtamt"));
            results.add(destBill);
        }
        return results;
    }

    private List<DynamicObject> decomposeAmtByShare(BigDecimal disposeAmt, BigDecimal exRate, String quotation, DynamicObjectCollection entries, boolean isPeriod, int precision, Set<Long> srcEntriesId, DynamicObject srcFinBill) {
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(8);
        ArrayList<Object> targetEntries = new ArrayList<Object>(8);
        for (Object detail : entries) {
            Long l = detail.getLong("e_srcentryid");
            if (!srcEntriesId.contains(l)) continue;
            targetEntries.add(detail);
        }
        BigDecimal billUnlockAmount = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : targetEntries) {
            billUnlockAmount = billUnlockAmount.add(dynamicObject.getBigDecimal("e_unlockamt"));
        }
        boolean disposeAll = disposeAmt.compareTo(billUnlockAmount) == 0;
        DynamicObjectCollection dynamicObjectCollection = srcFinBill.getDynamicObjectCollection("entry");
        Map<Long, BigDecimal> entryIdAndRecamout = dynamicObjectCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBigDecimal("e_recamount")));
        BigDecimal billAmount = srcFinBill.getBigDecimal("recamount");
        BigDecimal remainDisposeAmount = disposeAmt;
        BigDecimal rowRemainDisposeAmt = BigDecimal.ZERO;
        int count = 0;
        for (DynamicObject dynamicObject : targetEntries) {
            BigDecimal entryAmount = entryIdAndRecamout.get(dynamicObject.getLong("e_srcentryid"));
            BigDecimal unLockAmt = dynamicObject.getBigDecimal("e_unlockamt");
            if (disposeAll) {
                dynamicObject.set("e_baddebtamt", (Object)unLockAmt);
            } else if (++count == targetEntries.size()) {
                dynamicObject.set("e_baddebtamt", (Object)remainDisposeAmount);
            } else {
                BigDecimal disposeRate = entryAmount.divide(billAmount, 10, RoundingMode.HALF_UP);
                BigDecimal rowDisposeAmount = disposeAmt.multiply(disposeRate).setScale(precision, RoundingMode.HALF_UP);
                if ((rowDisposeAmount = rowDisposeAmount.add(rowRemainDisposeAmt)).multiply(entryAmount).compareTo(BigDecimal.ZERO) > 0 && rowDisposeAmount.abs().compareTo(unLockAmt.abs()) > 0) {
                    dynamicObject.set("e_baddebtamt", (Object)unLockAmt);
                    rowRemainDisposeAmt = rowDisposeAmount.subtract(unLockAmt);
                    remainDisposeAmount = remainDisposeAmount.subtract(unLockAmt);
                } else {
                    dynamicObject.set("e_baddebtamt", (Object)rowDisposeAmount);
                    remainDisposeAmount = remainDisposeAmount.subtract(rowDisposeAmount);
                    rowRemainDisposeAmt = BigDecimal.ZERO;
                }
            }
            BigDecimal e_badDebtAmt = dynamicObject.getBigDecimal("e_baddebtamt");
            if (quotation.equals("0")) {
                dynamicObject.set("e_baddebtlocamt", (Object)e_badDebtAmt.multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
            } else {
                dynamicObject.set("e_baddebtlocamt", (Object)e_badDebtAmt.divide(exRate, precision, RoundingMode.HALF_UP));
            }
            if (!isPeriod) {
                dynamicObject.set("e_unlockamt", (Object)e_badDebtAmt);
                dynamicObject.set("e_lockedamt", (Object)BigDecimal.ZERO);
            }
            dynamicObject.set("e_unsettleamt", (Object)e_badDebtAmt);
            detailList.add(dynamicObject);
        }
        return detailList;
    }

    private List<DynamicObject> decomposeAmt(BigDecimal disposeAmt, BigDecimal exRate, String quotation, DynamicObjectCollection entries, boolean isPeriod, int precision, Set<Long> srcEntriesId) {
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
        BigDecimal decompAmt = disposeAmt;
        for (DynamicObject detail : entries) {
            BigDecimal applyAmt;
            Long srcEntryId = detail.getLong("e_srcentryid");
            if (!srcEntriesId.contains(srcEntryId) || (applyAmt = detail.getBigDecimal("e_unlockamt")).compareTo(BigDecimal.ZERO) <= 0) continue;
            if (applyAmt.compareTo(decompAmt) >= 0) {
                detail.set("e_baddebtamt", (Object)decompAmt);
                if (quotation.equals("0")) {
                    detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
                } else {
                    detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
                }
                if (!isPeriod) {
                    detail.set("e_unlockamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                    detail.set("e_lockedamt", (Object)BigDecimal.ZERO);
                }
                detail.set("e_unsettleamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                detailList.add(detail);
                break;
            }
            detail.set("e_baddebtamt", (Object)applyAmt);
            if (quotation.equals("0")) {
                detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
            } else {
                detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
            }
            if (!isPeriod) {
                detail.set("e_unlockamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                detail.set("e_lockedamt", (Object)BigDecimal.ZERO);
            }
            detail.set("e_unsettleamt", (Object)detail.getBigDecimal("e_baddebtamt"));
            decompAmt = decompAmt.subtract(applyAmt);
            detailList.add(detail);
        }
        return detailList;
    }

    public static List<DynamicObject> decomposeAmt2Plan(BigDecimal disposeAmt, BigDecimal exRate, String quotation, DynamicObjectCollection planEntries, boolean isPeriod, int precision, Set<Long> srcPlanEntriesId) {
        ArrayList<DynamicObject> planList = new ArrayList<DynamicObject>();
        BigDecimal decompAmt = disposeAmt;
        for (DynamicObject plan : planEntries) {
            BigDecimal applyAmt;
            Long srcEntryId = plan.getLong("p_srcplanentryid");
            if (!srcPlanEntriesId.contains(srcEntryId) || (applyAmt = plan.getBigDecimal("p_unlockamt")).compareTo(BigDecimal.ZERO) <= 0) continue;
            if (applyAmt.compareTo(decompAmt) >= 0) {
                plan.set("p_baddebtamt", (Object)decompAmt);
                if (quotation.equals("0")) {
                    plan.set("p_baddebtlocamt", (Object)plan.getBigDecimal("p_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
                } else {
                    plan.set("p_baddebtlocamt", (Object)plan.getBigDecimal("p_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
                }
                if (!isPeriod) {
                    plan.set("p_unlockamt", (Object)plan.getBigDecimal("p_baddebtamt"));
                    plan.set("p_lockedamt", (Object)BigDecimal.ZERO);
                }
                plan.set("p_unsettleamt", (Object)plan.getBigDecimal("p_baddebtamt"));
                planList.add(plan);
                break;
            }
            if (applyAmt.compareTo(decompAmt) >= 0) continue;
            plan.set("p_baddebtamt", (Object)applyAmt);
            if (quotation.equals("0")) {
                plan.set("p_baddebtlocamt", (Object)plan.getBigDecimal("p_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
            } else {
                plan.set("p_baddebtlocamt", (Object)plan.getBigDecimal("p_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
            }
            if (!isPeriod) {
                plan.set("p_unlockamt", (Object)plan.getBigDecimal("p_baddebtamt"));
                plan.set("p_lockedamt", (Object)BigDecimal.ZERO);
            }
            plan.set("p_unsettleamt", (Object)plan.getBigDecimal("p_baddebtamt"));
            decompAmt = decompAmt.subtract(applyAmt);
            planList.add(plan);
        }
        return planList;
    }

    private Map<Long, DynamicObject> getEntryInfo(String mode, DynamicObjectCollection confirmEntries) {
        if (ConfirmModeEnum.head.name().equals(mode)) {
            return confirmEntries.stream().collect(Collectors.toMap(entry -> entry.getLong("g_sourcebillid"), entry -> entry));
        }
        if (ConfirmModeEnum.planEntry.name().equals(mode)) {
            return confirmEntries.stream().collect(Collectors.toMap(entry -> entry.getLong("p_srcplanentryid"), entry -> entry));
        }
        if (ConfirmModeEnum.entry.name().equals(mode)) {
            return confirmEntries.stream().collect(Collectors.toMap(entry -> entry.getLong("e_srcentryid"), entry -> entry));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u574f\u8d26\u635f\u5931\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"BaddebtConfirmOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
    }
}

