/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.validator.CoordinationApAdjustValidator;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.business.price.FxCalculator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.util.StdConfig;

public class CoordinationApAdjustOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(CoordinationApAdjustOp.class);
    private static final String E_AMOUNT = "e_amount";
    private static final String E_LOCALAMT = "e_localamt";
    private static final String E_TAX = "e_tax";
    private static final String E_TAXLOCALAMT = "e_taxlocalamt";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CoordinationApAdjustValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("CoordinationApAdjustOp endOperationTransaction begin.");
        Tuple<List<Long>, Map<Long, Map<String, BigDecimal>>> tuple = this.getNeedAdjustFinApParams(e.getDataEntities());
        if (tuple == null) {
            return;
        }
        List needAdjustApBillIds = (List)tuple.item1;
        Map srcAp4ApAmountMap = (Map)tuple.item2;
        List<Object> adjustBillIds = this.pushAndSaveAdjustBill(needAdjustApBillIds, srcAp4ApAmountMap);
        this.executeAutoAudit(adjustBillIds);
        logger.info("CoordinationApAdjustOp endOperationTransaction end.");
    }

    private void executeAutoAudit(List<Object> adjustBillIds) {
        logger.info("CoordinationApAdjustOp executeAutoAudit begin.");
        String coordinationApAdjustBillStatus = StdConfig.get((String)"coordinationApAdjustBillStatus");
        logger.info("CoordinationApAdjustOp executeAutoAudit coordinationApAdjustBillStatus is : " + coordinationApAdjustBillStatus);
        if (ObjectUtils.isEmpty(adjustBillIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_ignoremodify", "false");
        List successPkIds = new ArrayList(2);
        if (ObjectUtils.isEmpty((Object)coordinationApAdjustBillStatus) || "B".equals(coordinationApAdjustBillStatus) || "C".equals(coordinationApAdjustBillStatus)) {
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])adjustBillIds.toArray(new Object[0]), (OperateOption)option);
            logger.info("CoordinationApAdjustOp executeAutoAudit submitResult errormessage is :" + submitResult.getMessage());
            successPkIds = submitResult.getSuccessPkIds();
        }
        if (!ObjectUtils.isEmpty(successPkIds) && (ObjectUtils.isEmpty((Object)coordinationApAdjustBillStatus) || "C".equals(coordinationApAdjustBillStatus))) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])successPkIds.toArray(new Object[0]), (OperateOption)option);
            logger.info("CoordinationApAdjustOp executeAutoAudit auditResult errormessage is :" + auditResult.getMessage());
        }
        logger.info("CoordinationApAdjustOp executeAutoAudit end.");
    }

    private List<Object> pushAndSaveAdjustBill(List<Long> needAdjustApBillIds, Map<Long, Map<String, BigDecimal>> srcAp4ApAmountMap) {
        if (ObjectUtils.isEmpty(needAdjustApBillIds) || ObjectUtils.isEmpty(srcAp4ApAmountMap)) {
            return new ArrayList<Object>(2);
        }
        logger.info("CoordinationApAdjustOp pushAndSaveAdjustBill begin.");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("adjusttype", "adjustinv");
        Map resultMap = BOTPHelper.push4Result((String)"ap_finapbill", (String)"ap_finapbill", (String)"646082310541694976", needAdjustApBillIds, paramMap);
        Object convertResult = resultMap.get("convertResult");
        List<DynamicObject> adjustApBills = new ArrayList(2);
        if (convertResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertResult;
            ErrorCode ec = new ErrorCode("botp", String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u53d1\u7968\u660e\u7ec6\u8c03\u6574\u5931\u8d25 : %s", (String)"CoordinationApAdjustOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), result.getMessage()));
            throw new KDBizException(ec, new Object[0]);
        }
        adjustApBills = (List)resultMap.get("trgBills");
        logger.info("CoordinationApAdjustOp pushAndSaveAdjustBill adjustApBills size is  : " + adjustApBills.size());
        if (ObjectUtils.isEmpty(adjustApBills)) {
            return new ArrayList<Object>(2);
        }
        HashMap<Long, Boolean> relationPayMap = new HashMap<Long, Boolean>(8);
        for (DynamicObject adjustApBill : adjustApBills) {
            int localCurrencyPrecison = 2;
            DynamicObject baseCurrency = adjustApBill.getDynamicObject("basecurrency");
            if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
                localCurrencyPrecison = baseCurrency.getInt("amtprecision");
            }
            BigDecimal exchangeRate = adjustApBill.getBigDecimal("exchangerate");
            String quotation = adjustApBill.getString("quotation");
            if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                quotation = "0";
            }
            boolean isfx = adjustApBill.getBoolean("isfx");
            boolean isfxpricetaxtotal = adjustApBill.getBoolean("isfxpricetaxtotal");
            DynamicObjectCollection detailEntry = adjustApBill.getDynamicObjectCollection("detailentry");
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal taxLocAmt = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal amountBase = BigDecimal.ZERO;
            BigDecimal priceTaxTotal = BigDecimal.ZERO;
            BigDecimal priceTaxTotalLocal = BigDecimal.ZERO;
            BigDecimal adjustAmount = BigDecimal.ZERO;
            BigDecimal adjustLocalAmount = BigDecimal.ZERO;
            Iterator iterator = detailEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject detail = (DynamicObject)iterator.next();
                long eSrcEntryId = Long.parseLong(detail.getString("e_sourcebillentryid"));
                Map<String, BigDecimal> amountAndTaxMap = srcAp4ApAmountMap.get(eSrcEntryId);
                if (ObjectUtils.isEmpty(amountAndTaxMap)) {
                    iterator.remove();
                    continue;
                }
                BigDecimal e_tax = amountAndTaxMap.get(E_TAX);
                BigDecimal e_taxlocalamt = amountAndTaxMap.get(E_TAXLOCALAMT);
                BigDecimal e_amount = amountAndTaxMap.get(E_AMOUNT);
                BigDecimal e_amountbase = amountAndTaxMap.get(E_LOCALAMT);
                BigDecimal e_priceTaxTotal = e_tax.add(e_amount);
                BigDecimal e_pricetaxtotalbase = e_taxlocalamt.add(e_amountbase);
                BigDecimal e_adjustamount = detail.getBigDecimal("e_adjustamount");
                FxCalculator fxCalculator = new FxCalculator(e_tax, e_amount, e_priceTaxTotal, e_adjustamount, isfx, isfxpricetaxtotal, false, false, false, true);
                FXPriceLocalCalculator calculator = new FXPriceLocalCalculator(fxCalculator, exchangeRate, localCurrencyPrecison, quotation);
                calculator.calculate();
                detail.set(E_TAX, (Object)calculator.getTax());
                detail.set(E_TAXLOCALAMT, (Object)e_taxlocalamt);
                detail.set("e_adjustlocalamt", (Object)calculator.getAdjustamtlocal());
                detail.set(E_AMOUNT, (Object)calculator.getAmount());
                detail.set("e_unverifyamount", (Object)calculator.getAmount());
                detail.set("e_amountbase", (Object)e_amountbase);
                detail.set("e_pricetaxtotal", (Object)calculator.getPricetaxtotal());
                detail.set("unlockamt", (Object)calculator.getPricetaxtotal());
                detail.set("unsettleamt", (Object)calculator.getPricetaxtotal());
                detail.set("e_uninvoicedamt", (Object)calculator.getPricetaxtotal());
                detail.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
                detail.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
                tax = tax.add(calculator.getTax());
                taxLocAmt = taxLocAmt.add(e_taxlocalamt);
                amount = amount.add(calculator.getAmount());
                amountBase = amountBase.add(e_amountbase);
                priceTaxTotal = priceTaxTotal.add(calculator.getPricetaxtotal());
                priceTaxTotalLocal = priceTaxTotalLocal.add(e_pricetaxtotalbase);
                adjustAmount = adjustAmount.add(calculator.getAdjustamt());
                adjustLocalAmount = adjustLocalAmount.add(calculator.getAdjustamtlocal());
            }
            adjustApBill.set("tax", (Object)tax);
            adjustApBill.set("taxlocamt", (Object)taxLocAmt);
            adjustApBill.set("amount", (Object)amount);
            adjustApBill.set("unverifyamount", (Object)amount);
            adjustApBill.set("amountbase", (Object)amountBase);
            adjustApBill.set("pricetaxtotal", (Object)priceTaxTotal);
            adjustApBill.set("unsettleamount", (Object)priceTaxTotal);
            adjustApBill.set("uninvoicedamt", (Object)priceTaxTotal);
            adjustApBill.set("pricetaxtotalbase", (Object)priceTaxTotalLocal);
            adjustApBill.set("unsettleamountbase", (Object)priceTaxTotalLocal);
            adjustApBill.set("adjustamount", (Object)adjustAmount);
            adjustApBill.set("adjustlocalamt", (Object)adjustLocalAmount);
            adjustApBill.set("billsrctype", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue());
            String asstactType = adjustApBill.getString("asstacttype");
            DynamicObject asstact = adjustApBill.getDynamicObject("asstact");
            if (!"bd_supplier".equals(asstactType) && !"bd_customer".equals(asstactType) || asstact == null) continue;
            Boolean relationPay = (Boolean)relationPayMap.get(asstact.getLong("id"));
            if (relationPay == null) {
                DynamicObject tempAsstact = BusinessDataServiceHelper.loadSingleFromCache((String)asstactType, (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstact.getLong("id"))});
                relationPay = tempAsstact != null && tempAsstact.getDynamicObject("internal_company") != null ? Boolean.TRUE : Boolean.FALSE;
                relationPayMap.put(asstact.getLong("id"), relationPay);
            }
            adjustApBill.set("relationpay", (Object)relationPay);
        }
        PlanSplitAndBuilder.splitAndBuild((DynamicObject[])adjustApBills.toArray(new DynamicObject[0]));
        this.setHeadDueDate(adjustApBills);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_finapbill", (DynamicObject[])adjustApBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)saveResult);
        logger.info("CoordinationApAdjustOp pushAndSaveAdjustBill end.");
        return saveResult.getSuccessPkIds();
    }

    private void setHeadDueDate(List<DynamicObject> bills) {
        for (DynamicObject bill : bills) {
            Date planMaxDuedate = bill.getDate("duedate");
            DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                Date planEntryDueDate = planEntry.getDate("planduedate");
                if (planMaxDuedate == null) {
                    planMaxDuedate = planEntryDueDate;
                    continue;
                }
                if (planEntryDueDate == null) continue;
                planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
            }
            bill.set("duedate", (Object)planMaxDuedate);
        }
    }

    private Tuple<List<Long>, Map<Long, Map<String, BigDecimal>>> getNeedAdjustFinApParams(DynamicObject[] dataEntities) {
        logger.info("CoordinationApAdjustOp getNeedAdjustFinApParams begin.");
        HashMap srcAr4ArAmountMap = new HashMap(8);
        ArrayList<Long> sourceBillIds = new ArrayList<Long>(8);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection entry = data.getDynamicObjectCollection("entry");
            for (DynamicObject detail : entry) {
                HashMap<String, BigDecimal> detailAmtMap = new HashMap<String, BigDecimal>(2);
                detailAmtMap.put(E_AMOUNT, detail.getBigDecimal(E_AMOUNT));
                detailAmtMap.put(E_LOCALAMT, detail.getBigDecimal(E_LOCALAMT));
                detailAmtMap.put(E_TAX, detail.getBigDecimal(E_TAX));
                detailAmtMap.put(E_TAXLOCALAMT, detail.getBigDecimal(E_TAXLOCALAMT));
                srcAr4ArAmountMap.put(detail.getLong("e_srcentryid"), detailAmtMap);
            }
            sourceBillIds.add(Long.parseLong(data.getString("sourcebillid")));
        }
        Object[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,sourcebilltype,entry.e_srcentryid,entry.e_srcid,asstacttype,asstact", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
        if (ObjectUtils.isEmpty((Object[])finArBills)) {
            return null;
        }
        ArrayList<Long> arCoorApBillIds = new ArrayList<Long>(8);
        ArrayList<Long> needAdjustApBillIds = new ArrayList<Long>(8);
        HashMap<Long, Map> srcAp4ApAmountMap = new HashMap<Long, Map>(8);
        HashMap<Long, Long> asstact4InternalMap = new HashMap<Long, Long>(8);
        for (Object finArBill : finArBills) {
            DynamicObject interCompany;
            DynamicObject asstact;
            long asstactId;
            Long internalId;
            if ("ap_finapbill".equals(finArBill.getString("sourcebilltype"))) {
                DynamicObjectCollection entry = finArBill.getDynamicObjectCollection("entry");
                for (DynamicObject detail : entry) {
                    long entryId = detail.getLong("id");
                    long apBillId = detail.getLong("e_srcid");
                    long apEntryId = detail.getLong("e_srcentryid");
                    Map arAdjustAmountMap = (Map)srcAr4ArAmountMap.get(entryId);
                    if (ObjectUtils.isEmpty((Object)arAdjustAmountMap)) continue;
                    needAdjustApBillIds.add(apBillId);
                    srcAp4ApAmountMap.put(apEntryId, arAdjustAmountMap);
                }
                continue;
            }
            arCoorApBillIds.add(finArBill.getLong("id"));
            String asstactType = finArBill.getString("asstacttype");
            if (!"bd_supplier".equals(asstactType) && !"bd_customer".equals(asstactType) || (internalId = (Long)asstact4InternalMap.get(asstactId = finArBill.getLong("asstact.id"))) != null || (asstact = BusinessDataServiceHelper.loadSingle((Object)asstactId, (String)asstactType, (String)"id,internal_company")) == null || (interCompany = asstact.getDynamicObject("internal_company")) == null) continue;
            asstact4InternalMap.put(asstactId, interCompany.getLong("id"));
        }
        if (!arCoorApBillIds.isEmpty()) {
            DynamicObject[] finApBills;
            QFilter filter = new QFilter("sourcebilltype", "=", (Object)"ar_finarbill");
            filter.and(new QFilter("sourcebillid", "in", arCoorApBillIds));
            filter.and(new QFilter("org", "in", asstact4InternalMap.values()));
            for (DynamicObject finApBill : finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,detailentry.id,detailentry.e_sourcebillentryid,detailentry.e_sourcebillid", (QFilter[])new QFilter[]{filter})) {
                needAdjustApBillIds.add(finApBill.getLong("id"));
                DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detail : detailEntry) {
                    long finArEntryId = Long.parseLong(detail.getString("e_sourcebillentryid"));
                    Map arAdjustAmountMap = (Map)srcAr4ArAmountMap.get(finArEntryId);
                    if (ObjectUtils.isEmpty((Object)arAdjustAmountMap)) continue;
                    srcAp4ApAmountMap.put(detail.getLong("id"), arAdjustAmountMap);
                }
            }
        }
        logger.info("CoordinationApAdjustOp getNeedAdjustFinApParams needAdjustApBillIds is : " + needAdjustApBillIds);
        logger.info("CoordinationApAdjustOp getNeedAdjustFinApParams srcAp4ApAmountMap is : " + srcAp4ApAmountMap);
        logger.info("CoordinationApAdjustOp getNeedAdjustFinApParams end.");
        return Tuple.create(needAdjustApBillIds, srcAp4ApAmountMap);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("asstact");
        fieldKeys.add("asstacttype");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("billsrctype");
        fieldKeys.add("billstatus");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("e_srcid");
        fieldKeys.add("e_srcentryid");
        fieldKeys.add(E_TAX);
        fieldKeys.add(E_AMOUNT);
        fieldKeys.add(E_LOCALAMT);
        fieldKeys.add(E_TAXLOCALAMT);
    }
}

