/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public final class DeletePushArClearOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entry.e_srcbillid");
        e.getFieldKeys().add("sourcebilltype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        try (TraceSpan span = Tracer.create((String)"DeletePushArClearOp", (String)"beginOperationTransaction");){
            this.delArClearKey(e);
        }
    }

    private void delArClearKey(BeginOperationTransactionArgs e) {
        DynamicObject[] arBills = e.getDataEntities();
        if (arBills == null || arBills.length == 0) {
            return;
        }
        String srcBillType = arBills[0].getString("sourcebilltype");
        if (!"im_saloutbill".equals(srcBillType)) {
            return;
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>(arBills.length);
        for (DynamicObject bill : arBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            Object pkValue = bill.getPkValue();
            for (DynamicObject entry : entrys) {
                Long srcId = entry.getLong("e_srcbillid");
                if (srcId == 0L || pkValue == null || pkValue.equals(0L)) continue;
                String cacheKey = String.join((CharSequence)"_", "srcbillid", srcId.toString());
                cacheMap.put(cacheKey, pkValue.toString());
            }
        }
        IAppCache iAppCache = AppCache.get((String)"ar_push");
        this.removeCache(iAppCache, cacheMap);
    }

    private void removeCache(IAppCache iAppCache, Map<String, String> cacheMap) {
        for (Map.Entry<String, String> entry : cacheMap.entrySet()) {
            String cacheBillId;
            String cacheKey = entry.getKey();
            String pkValue = entry.getValue();
            if (!pkValue.equals(cacheBillId = (String)iAppCache.get(cacheKey, String.class))) continue;
            iAppCache.remove(cacheKey);
        }
    }
}

