/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;

public class FinArBillAuditForRecbillOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinArBillAuditForRecbillOp.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OperationResult operationResult;
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        ArrayList<Long> srcBillIDs = new ArrayList<Long>(entities.length);
        HashMap<Long, Boolean> paramMap = new HashMap<Long, Boolean>(8);
        for (DynamicObject dy : entities) {
            Long orgId = dy.getLong("org.id");
            boolean autopush = paramMap.computeIfAbsent(orgId, ev -> SystemParameterHelper.getParameterBoolean((long)orgId, (String)"ar_011"));
            if (!autopush) continue;
            String billstatus = dy.getString("billstatus");
            String paymode = dy.getString("paymode");
            if (!"C".equals(billstatus) || !"CASH".equals(paymode)) continue;
            srcBillIDs.add((Long)dy.getPkValue());
        }
        if (!srcBillIDs.isEmpty() && !(operationResult = OperationServiceHelper.executeOperate((String)"pushandsave", (String)"ar_finarbill", (Object[])srcBillIDs.toArray(), (OperateOption)OperateOption.create())).isSuccess()) {
            List reports = operationResult.getAllErrorInfo();
            StringBuilder str = new StringBuilder();
            for (OperateErrorInfo error : reports) {
                str.append(error.getMessage());
            }
            logger.info(str.toString());
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("paymode");
        e.getFieldKeys().add("billstatus");
    }
}

