/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.validator.FinArBillDeleteValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.FinArBillPlanHelper;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.writeback.helper.ArTransferWBFinBillServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.BillVerifyAndSettleRecordValidator;

public class FinArBillDeleteOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinArBillDeleteOp.class);
    private static final int rowCountOneBatch = 2000;
    private final List<Long> busPks = new LinkedList<Long>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinArBillDeleteValidator());
        e.addValidator((AbstractValidator)new BillVerifyAndSettleRecordValidator(true));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        logger.info("FinArBillDeleteOp.beginOperationTransaction start");
        logger.info("FinArBillDeleteOp.beginOperationTransaction executeBaddebtDelete start");
        this.executeBaddebtDelete(bills);
        logger.info("FinArBillDeleteOp.beginOperationTransaction executeBaddebtDelete end");
        logger.info("FinArBillDeleteOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        logger.info("FinArBillDeleteOp.endOperationTransaction start");
        logger.info("FinArBillDeleteOp.endOperationTransaction writeBackSrcBillLockAmt start");
        List<DynamicObject> transferBills = Arrays.stream(bills).filter(bill -> bill.getBoolean("istransfer")).collect(Collectors.toList());
        this.writeBackSrcBillLockAmt(transferBills);
        logger.info("FinArBillDeleteOp.endOperationTransaction writeBackSrcBillLockAmt end");
        logger.info("FinArBillDeleteOp.endOperationTransaction buildBusPks start");
        for (DynamicObject bill2 : bills) {
            ArrayList srcPks;
            Map linkBills;
            HashSet target;
            if (ObjectUtils.isEmpty((Object)bill2.getString("sourcebilltype")) || (target = (HashSet)(linkBills = BFTrackerServiceHelper.findSourceBills((String)"ar_finarbill", (Long[])new Long[]{bill2.getLong("id")})).get("ar_busbill")) == null || (srcPks = new ArrayList(target)).isEmpty()) continue;
            this.busPks.addAll(srcPks);
        }
        logger.info("FinArBillDeleteOp.endOperationTransaction buildBusPks end");
        logger.info("FinArBillDeleteOp.endOperationTransaction end");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        logger.info("FinArBillDeleteOp.afterExecuteOperationTransaction start");
        if (!this.busPks.isEmpty()) {
            ThreadPools.executeOnceIncludeRequestContext((String)"delete.disposeReserveBill", () -> BaddebtHelper.disposeReserveBill(this.busPks));
        }
        this.removeCache(e.getDataEntities());
        logger.info("FinArBillDeleteOp.endOperationTransaction end");
    }

    private void writeBackSrcBillLockAmt(List<DynamicObject> transferBills) {
        if (ObjectUtils.isEmpty(transferBills)) {
            return;
        }
        HashSet<Long> srcFinArBillIds = new HashSet<Long>(64);
        for (DynamicObject transferBill : transferBills) {
            DynamicObjectCollection detailEntry = transferBill.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : detailEntry) {
                srcFinArBillIds.add(dynamicObject.getLong("e_srcid"));
            }
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(srcFinArBillIds, (String)"ar_finarbill", (boolean)false);
        Date upgradeTime = UpgradeConfigHelper.getUpgradeTime((String)"BIZ_V5.0.023_DataUpgrade");
        upgradeTime = upgradeTime == null ? DateUtils.parseDate((String)"2023-07-10", (String)"yyyy-MM-dd") : upgradeTime;
        ArrayList<DynamicObject> oldWriteBackBills = new ArrayList<DynamicObject>(64);
        ArrayList<DynamicObject> newWriteBackBills = new ArrayList<DynamicObject>(64);
        for (DynamicObject dynamicObject : transferBills) {
            if (dynamicObject.getDate("createtime").compareTo(upgradeTime) >= 0) {
                newWriteBackBills.add(dynamicObject);
                continue;
            }
            oldWriteBackBills.add(dynamicObject);
        }
        if (!oldWriteBackBills.isEmpty()) {
            this.writeBackSrcBillLockAmtOld(oldWriteBackBills);
        }
        if (newWriteBackBills.isEmpty()) {
            return;
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(64);
        for (DynamicObject needDisposeBill : newWriteBackBills) {
            DynamicObjectCollection detailEntry = needDisposeBill.getDynamicObjectCollection("entry");
            for (DynamicObject detailRow : detailEntry) {
                srcBillIds.add(detailRow.getLong("e_srcid"));
            }
        }
        String string = String.join((CharSequence)",", FinArBillHandleHelper.getLockWBSelector());
        Object[] srcBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)string, (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
        if (ObjectUtils.isEmpty((Object[])srcBills)) {
            return;
        }
        Map srcBillsGroupByOrg = Arrays.stream(srcBills).collect(Collectors.groupingBy(bill -> bill.getLong("org.id"), HashMap::new, Collectors.toList()));
        for (Map.Entry srcBillEntrySet : srcBillsGroupByOrg.entrySet()) {
            List sourceBills = (List)srcBillEntrySet.getValue();
            ArTransferWBFinBillServiceHelper.inverseWriteBack((DynamicObject[])sourceBills.toArray(new DynamicObject[0]), newWriteBackBills);
        }
    }

    private void writeBackSrcBillLockAmtOld(List<DynamicObject> oldReleaseUpBills) {
        for (DynamicObject bill : oldReleaseUpBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long srcBillId = entry.getLong("e_srcid");
                long srcEntryId = entry.getLong("e_srcentryid");
                BigDecimal amount = entry.getBigDecimal("e_recamount");
                FinArBillHandleHelper.disposeLockedAmt((long)srcBillId, (long)srcEntryId, (BigDecimal)amount, (Boolean)Boolean.FALSE);
                FinArBillPlanHelper.unLockPlan((long)srcBillId, (Object)srcEntryId, (BigDecimal)amount);
            }
        }
    }

    private void executeBaddebtDelete(DynamicObject[] bills) {
        Object[] destBills;
        QFilter qFilter;
        LinkedList<Object> pks = new LinkedList<Object>();
        LinkedList<Object> pks4period = new LinkedList<Object>();
        for (DynamicObject bill : bills) {
            if (bill.getBoolean("isperiod")) {
                pks4period.add(bill.getPkValue());
            }
            if (!bill.getBoolean("isbaddebt") || bill.getBigDecimal("baddebtamt").compareTo(BigDecimal.ZERO) <= 0) continue;
            pks.add(bill.getPkValue());
        }
        if (!pks4period.isEmpty()) {
            qFilter = new QFilter("sourcebillid", "in", pks4period);
            DeleteServiceHelper.delete((String)"ar_baddebtreservebill", (QFilter[])new QFilter[]{qFilter});
            new JournalService().deleteJournals("ar_finarbill", pks4period.toArray(new Long[0]));
        }
        if (pks.size() > 0 && !ObjectUtils.isEmpty((Object[])(destBills = BusinessDataServiceHelper.load((String)"ar_baddebtlossbill", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("sourcebillid", "in", pks)})))) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationServiceHelper.executeOperate((String)"delete4period", (String)"ar_baddebtlossbill", (Object[])StringUtils.getPks((DynamicObject[])destBills), (OperateOption)option);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(10);
        props.add("org");
        props.add("billtype");
        props.add("sourcebillid");
        props.add("sourcebilltype");
        props.add("recamount");
        props.add("entry");
        props.add("e_srcid");
        props.add("e_srcentryid");
        props.add("e_recamount");
        props.add("e_reclocalamt");
        props.add("istransfer");
        props.add("isbaddebt");
        props.add("baddebtamt");
        props.add("isperiod");
        props.add("imageno");
        props.add("p_sourcebillid");
        props.add("p_sourcebillentryid");
        props.add("createtime");
        props.add("iswrittenoff");
        props.addAll(FinArBillHandleHelper.getLockWBSelector());
        fieldKeys.addAll(props);
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("entry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }
}

