/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.writeback.helper.ArPremiumWBFinBillServiceHelper;

public class FinArBillNoprotocolDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinArBillNoprotocolDeleteOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        logger.info("FinArBillNoprotocolDeleteOp.endOperationTransaction start");
        logger.info("FinArBillNoprotocolDeleteOp.endOperationTransaction premiumDeleteDispose start");
        this.premiumDeleteDispose(bills);
        logger.info("FinArBillNoprotocolDeleteOp.endOperationTransaction premiumDeleteDispose end");
    }

    private void premiumDeleteDispose(DynamicObject[] bills) {
        ArrayList<DynamicObject> premiumBills = new ArrayList<DynamicObject>(bills.length);
        ArrayList<Long> premiumSourceBillIds = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            if (!bill.getBoolean("ispremium")) continue;
            premiumBills.add(bill);
            premiumSourceBillIds.add(bill.getLong("sourcebillid"));
        }
        if (!premiumSourceBillIds.isEmpty()) {
            QFilter[] sourceBillFilters = new QFilter[]{new QFilter("id", "in", premiumSourceBillIds)};
            List selectors = FinArBillHandleHelper.getLockWBSelector();
            DynamicObject[] sourceFinBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", selectors), (QFilter[])sourceBillFilters);
            HashMap<Object, DynamicObject> sourceFinBillsMap = new HashMap<Object, DynamicObject>(sourceFinBills.length);
            for (DynamicObject finBill : sourceFinBills) {
                sourceFinBillsMap.put(finBill.getPkValue(), finBill);
            }
            for (DynamicObject premiumBill : premiumBills) {
                Long sourceBillId = premiumBill.getLong("sourcebillid");
                DynamicObject sourceFinBill = (DynamicObject)sourceFinBillsMap.get(sourceBillId);
                ArPremiumWBFinBillServiceHelper.deleteWriteBack((DynamicObject)sourceFinBill, (DynamicObject)premiumBill);
            }
            SaveServiceHelper.save((DynamicObject[])sourceFinBills);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("sourcebilltype");
        keys.add("sourcebillid");
        keys.add("recamount");
        keys.add("ispremium");
        keys.add("settleversion");
        keys.addAll(FinArBillHandleHelper.getLockWBSelector());
    }
}

