/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.consts.BillTypeConsts;
import kd.fi.ar.enums.BillStatusEnum;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.mservice.ArReceiveAutoSettleService;
import kd.fi.ar.mservice.ArReceiveSettleService;
import kd.fi.ar.mservice.SettleServiceHelper;
import kd.fi.ar.validator.FinArAdjustValidator;
import kd.fi.ar.validator.FinArBillInvApplyValidator;
import kd.fi.ar.validator.FinArBillSubmitAmountValidator;
import kd.fi.ar.validator.FinArBillSubmitValidator;
import kd.fi.ar.validator.FinArSubmitPremiumValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApRecOrPayBillHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.opplugin.BillAppStatusValidator;
import kd.fi.arapcommon.opplugin.FinBillCheckAmtValidator;
import kd.fi.arapcommon.opplugin.FinBillPreInfoValidator;
import kd.fi.arapcommon.opplugin.MustInputValidator;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.service.helper.TxSettleServiceHelper;
import kd.fi.arapcommon.service.plan.split.entity.DimensionMapping;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitMappingServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.writeback.helper.FinArExitPremiumWBServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.MtoValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;
import kd.fi.arapcommon.validator.paysecurity.FinArExcessBusValidator;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import org.apache.commons.lang.StringUtils;

public class FinArBillSubmitOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinArBillSubmitOp.class);
    private static final int rowCountOneBatch = 2000;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinArBillSubmitValidator());
        e.addValidator((AbstractValidator)new BillAppStatusValidator());
        e.addValidator((AbstractValidator)new MustInputValidator());
        e.addValidator((AbstractValidator)new FinBillCheckAmtValidator(true));
        if (SystemParameterHelper.isForceValidateAmt()) {
            e.addValidator((AbstractValidator)new FinArBillSubmitAmountValidator());
        }
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new MtoValidator());
        e.addValidator((AbstractValidator)new FinArAdjustValidator());
        e.addValidator((AbstractValidator)new FinBillPreInfoValidator(true));
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new FinArBillInvApplyValidator());
        e.addValidator((AbstractValidator)new FinArSubmitPremiumValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        HashMap orgMap = new HashMap();
        DynamicObject[] entities = e.getDataEntities();
        this.removeEmptyPlanEntry(entities);
        ArApHelper.sortPlanDueDate((DynamicObject[])entities);
        this.setInvoicedAmt(entities);
        BookDateHelper.setBookDate((DynamicObject[])entities, (boolean)true);
        this.setAdjustType(entities);
        ArApRecOrPayBillHelper.removeEmptyPreEntry((DynamicObject[])entities);
        ArApRecOrPayBillHelper.sortPreEntryByDate((DynamicObject[])entities);
        for (DynamicObject bill : entities) {
            if (ObjectUtils.isEmpty((Object)bill.getDate("acctagecalcdate"))) {
                FinArBillHelper.setAcctAgeCalcDate((DynamicObject)bill, orgMap);
            }
            if (kd.fi.arapcommon.util.StringUtils.isEmpty((String)bill.getString("billsrctype")) && kd.fi.arapcommon.util.StringUtils.isNotEmpty((String)bill.getString("sourcebilltype"))) {
                bill.set("billsrctype", (Object)BillSrcTypeEnum.AUTO.getValue());
            }
            String asstactType = bill.getString("asstacttype");
            DynamicObject payAsstact = bill.getDynamicObject("paymentcustomerid");
            if (payAsstact != null || !"bd_customer".equals(asstactType)) continue;
            DynamicObject asstact = bill.getDynamicObject("asstact");
            bill.set("paymentcustomerid", (Object)asstact);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArApDataRepairHelper.repaireFinArAmtField((DynamicObject[])dataEntities);
        ArApHelper.baseUnitQtyCorrection((DynamicObject[])dataEntities, (String)"ar_finarbill");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinArBillSubmitOp.endOperationTransaction start");
        logger.info("FinArBillSubmitOp.endOperationTransaction executeBaddebt start");
        this.executeBaddebt(entities);
        logger.info("FinArBillSubmitOp.endOperationTransaction executeBaddebt end");
        logger.info("FinArBillSubmitOp.endOperationTransaction submitAutoSettle start");
        this.submitAutoSettle(entities);
        logger.info("FinArBillSubmitOp.endOperationTransaction submitAutoSettle end");
        this.busQtyAndAmtValidator(entities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ThreadPools.executeOnceIncludeRequestContext((String)"submit.disposeReserveBill", () -> {
            ArrayList srcPks = new ArrayList();
            for (DynamicObject finbill : e.getDataEntities()) {
                ArrayList busPks;
                Map linkBills;
                Set key;
                if (ObjectUtils.isEmpty((Object)finbill.getString("sourcebilltype")) || !(key = (linkBills = BFTrackerServiceHelper.findSourceBills((String)"ar_finarbill", (Long[])new Long[]{finbill.getLong("id")})).keySet()).contains("ar_busbill") || (busPks = new ArrayList((Collection)linkBills.get("ar_busbill"))).isEmpty()) continue;
                srcPks.addAll(busPks);
            }
            if (!srcPks.isEmpty()) {
                BaddebtHelper.disposeReserveBill(srcPks);
            }
        });
        TaxHelper.recordTaxLog((DynamicObject[])e.getDataEntities(), (boolean)true);
        this.removeCache(e.getDataEntities());
    }

    private void executeBaddebt(DynamicObject[] entities) {
        MainEntityType reserveDT = EntityMetadataCache.getDataEntityType((String)"ar_baddebtreservebill");
        ArrayList<DynamicObject> destList = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> reserveList = new ArrayList<DynamicObject>(1);
        QFilter fixFilter = new QFilter("isfinishinit", "=", (Object)Boolean.FALSE);
        fixFilter.and(new QFilter("baddebtpolicy", "=", (Object)"allowance"));
        HashMap<Long, DynamicObject[]> orgMap = new HashMap<Long, DynamicObject[]>();
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        for (DynamicObject info : entities) {
            QFilter qFilter = new QFilter("sourcebillid", "=", info.getPkValue());
            if (info.getBoolean("isbaddebt") && info.getBigDecimal("baddebtamt").compareTo(BigDecimal.ZERO) > 0) {
                DynamicObject baddebt = QueryServiceHelper.queryOne((String)"ar_baddebtlossbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (baddebt != null) {
                    OperationServiceHelper.executeOperate((String)"delete4period", (String)"ar_baddebtlossbill", (Object[])new Object[]{baddebt.getLong("id")}, (OperateOption)option);
                }
                baddebt = this.buildInitLossBill(info);
                destList.add(baddebt);
            }
            if (!info.getBoolean("isperiod")) continue;
            if (BigDecimal.ZERO.compareTo(info.getBigDecimal("recamount")) == 0) break;
            long orgPk = (Long)info.getDynamicObject("org").getPkValue();
            QFilter orgFilter = new QFilter("org", "=", (Object)orgPk);
            DynamicObject[] inits = null;
            if (!orgMap.containsKey(orgPk)) {
                inits = BusinessDataServiceHelper.load((String)"ar_init", (String)"id, policytype, startperiod, baddebtpolicy, policyid", (QFilter[])new QFilter[]{orgFilter, fixFilter}, (String)"policytype");
                orgMap.put(orgPk, inits);
            } else {
                inits = (DynamicObject[])orgMap.get(orgPk);
            }
            for (DynamicObject init : inits) {
                QFilter initFilter = new QFilter("initbaddebtid", "=", init.getPkValue());
                DynamicObject reserve = QueryServiceHelper.queryOne((String)"ar_baddebtreservebill", (String)"id", (QFilter[])new QFilter[]{qFilter, initFilter});
                if (reserve == null) {
                    reserve = this.buildInitBaddebtReserve(info, init, null);
                } else {
                    reserve = BusinessDataServiceHelper.loadSingle((Object)reserve.getLong("id"), (String)"ar_baddebtreservebill");
                    reserve = this.buildInitBaddebtReserve(info, init, reserve);
                }
                reserveList.add(reserve);
            }
        }
        if (reserveList.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)reserveDT, (Object[])reserveList.toArray());
        }
        if (destList.size() > 0) {
            OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_baddebtlossbill", (DynamicObject[])destList.toArray(new DynamicObject[0]), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)opResult);
        }
    }

    private void setAdjustType(DynamicObject[] datas) {
        for (DynamicObject data : datas) {
            BigDecimal priceTaxToTAL = data.getBigDecimal("recamount");
            DynamicObject billtye = data.getDynamicObject("billtype");
            String adjusttype = data.getString("adjusttype");
            if (!"arfin_borrowar_BT_S".equals(billtye.getString("number")) || !kd.fi.arapcommon.util.StringUtils.isEmpty((String)adjusttype)) continue;
            if (priceTaxToTAL.compareTo(BigDecimal.ZERO) > 0) {
                data.set("adjusttype", (Object)"overdue");
                continue;
            }
            if (priceTaxToTAL.compareTo(BigDecimal.ZERO) < 0) {
                data.set("adjusttype", (Object)"buckle");
                continue;
            }
            data.set("adjusttype", (Object)"adjustinv");
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(50);
        props.add("billtype");
        props.add("org");
        props.add("asstacttype");
        props.add("billstatus");
        props.add("asstact");
        props.add("bizdate");
        props.add("billno");
        props.add("currency");
        props.add("basecurrency");
        props.add("quotation");
        props.add("exchangerate");
        props.add("exratetable");
        props.add("recamount");
        props.add("e_srcid");
        props.add("e_srcentryid");
        props.add("unsettleamount");
        props.add("unsettlelocalamt");
        props.add("isbaddebt");
        props.add("baddebtamt");
        props.add("baddebtcause");
        props.add("planentity.seq");
        props.add("planentity.planduedate");
        props.add("planentity.planpricetax");
        props.add("entry.e_material");
        props.add("entry.e_measureunit");
        props.add("entry.e_expenseitem");
        props.add("sourcebilltype");
        props.add("sourcebillid");
        props.add("isperiod");
        props.add("e_recamount");
        props.add("e_invoicedamt");
        props.add("e_uninvoicedamt");
        props.add("uninvoicedamt");
        props.add("invoicedamt");
        props.add("duedate");
        props.add("acctagecalcdate");
        props.add("imageno");
        props.add("creator");
        props.add("modifier");
        props.add("createtime");
        props.add("modifytime");
        props.add("relationpay");
        props.add("e_taxunitprice");
        props.add("e_unitprice");
        props.add("e_ispresent");
        props.add("billsrctype");
        props.add("isincludetax");
        props.add("e_quantity");
        props.add("e_tax");
        props.add("e_amount");
        props.add("e_discountamount");
        if (SystemParameterHelper.isForceValidateAmt()) {
            props.addAll(FinArBillSubmitAmountValidator.getRequiredFields());
        }
        props.add("payproperty");
        props.add("linetype");
        props.add("bookdate");
        props.add("entry.e_invoicedqty");
        props.add("entry.e_uninvoicedqty");
        props.add("entry.seq");
        props.add("configuredcode");
        props.add("tracknumber");
        props.add("e_confirmedqty");
        props.add("e_unconfirmqty");
        props.add("e_confirmedamt");
        props.add("e_unconfirmamt");
        props.add("e_corebillno");
        props.add("e_corebillentryseq");
        props.add("adjusttype");
        props.add("e_corebilltype");
        props.add("corebillid");
        props.add("corebillentryid");
        props.add("y_billid");
        props.add("y_settleamt");
        props.add("y_billtype");
        props.add("y_amount");
        props.add("y_billno");
        props.add("y_date");
        props.add("y_billentryid");
        props.add("preentry.seq");
        props.add("localamt");
        props.add("amount");
        props.add("taxlocamt");
        props.add("tax");
        props.add("reclocalamt");
        props.add("adjustlocalamt");
        props.add("adjustamount");
        props.add("uninvoicedlocalamt");
        props.add("e_taxlocalamt");
        props.add("e_discountlocalamt");
        props.add("e_localamt");
        props.add("e_reclocalamt");
        props.add("e_unsettlelocalamt");
        props.add("e_unsettleamt");
        props.add("e_uninvoicedlocalamt");
        props.add("e_adjustlocalamt");
        props.add("e_adjustamount");
        props.add("planpricetaxloc");
        props.add("unplansettlelocamt");
        props.add("unplansettleamt");
        props.add("e_unitcoefficient");
        props.add("e_baseunitqty");
        props.add("e_baseunit");
        props.add("e_quantity");
        props.add("project");
        props.add("e_contract");
        props.add("paycond");
        props.add("splitscheme");
        props.add("planmaterial");
        props.add("planexpenseitem");
        props.add("plancorebillno");
        props.add("planproject");
        props.add("plancontract");
        props.add("paymentcustomerid");
        props.add("quotation");
        props.add("istransfer");
        props.add("settleamount");
        props.add("settlelocalamt");
        props.add("unverifyamount");
        props.add("entry.e_lockedamt");
        props.add("entry.e_settledamt");
        props.add("entry.e_settledlocalamt");
        props.add("entry.e_verifiedqty");
        props.add("entry.e_verifybaseqty");
        props.add("entry.e_verifiedamt");
        props.add("entry.e_unlockamt");
        props.add("entry.e_unverifyqty");
        props.add("entry.e_unverifybaseqty");
        props.add("entry.e_unverifyamt");
        props.add("entry.e_confirmedbaseqty");
        props.add("entry.e_unconfirmbaseqty");
        props.add("entry.e_splitdimensionid");
        props.add("planentity.planlockedamt");
        props.add("planentity.plansettledamt");
        props.add("planentity.plansettledlocamt");
        props.add("planentity.unplanlockamt");
        props.add("planentity.p_splitdimensionid");
        props.add("planentity.p_recrate");
        props.add("ispremium");
        props.add("premiumamt");
        props.add("iswrittenoff");
        List dimensionMappings = PlanSplitMappingServiceHelper.getDimensionMappings((boolean)true);
        for (DimensionMapping dimensionMapping : dimensionMappings) {
            props.add(dimensionMapping.getDetailEntryKey());
            props.add(dimensionMapping.getPlanEntryKey());
        }
        props.addAll(PlanSplitSchemeServiceHelper.getNeedProperties((boolean)true));
        props.addAll(FinArBillHandleHelper.getSelector());
        fieldKeys.addAll(props);
    }

    private DynamicObject buildInitLossBill(DynamicObject srcBill) {
        int ar003 = ArApHelper.getArSettleParam((Object)srcBill.getDynamicObject("org").getPkValue());
        String ruleId = "628174474734245888";
        if (ar003 == 2) {
            ruleId = "742037039666467840";
        }
        DynamicObject[] destBills = BOTPHelper.push((String)"ar_finarbill", (String)"ar_baddebtlossbill", (String)ruleId, (DynamicObject)srcBill, (String)ResManager.loadKDString((String)"\u5e94\u6536\u5355\u4e0b\u63a8\u574f\u8d26\u635f\u5931\u5355\u5931\u8d25\u3002", (String)"FinArBillSubmitOp_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        DynamicObject destBill = destBills[0];
        MainEntityType mainType = (MainEntityType)destBill.getDataEntityType();
        BasedataProp basedataProp = (BasedataProp)mainType.findProperty("billtype");
        destBill.set("billtype", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)BillTypeConsts.LOSS_HEAD, (DynamicObjectType)((DynamicObjectType)basedataProp.getComplexType((Object)destBill))));
        destBill.set("billtype_id", (Object)BillTypeConsts.LOSS_HEAD);
        if (EmptyUtils.isEmpty((Object)destBill.getDate("bizdate"))) {
            destBill.set("bizdate", (Object)srcBill.getDate("bizdate"));
        }
        if (EmptyUtils.isEmpty((Object)destBill.getString("settlestatus"))) {
            destBill.set("settlestatus", (Object)"unsettle");
        }
        destBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        destBill.set("sourcebilltype", srcBill.getDynamicObject("billtype").getPkValue());
        int precision = srcBill.getDynamicObject("basecurrency").getInt("amtprecision");
        String quotation = srcBill.getString("quotation");
        BigDecimal baddebtAmt = srcBill.getBigDecimal("baddebtamt");
        BigDecimal exRate = srcBill.getBigDecimal("exchangerate");
        destBill.set("baddebtamt", (Object)baddebtAmt);
        destBill.set("baddebtcause", (Object)srcBill.getString("baddebtcause"));
        if ("1".equals(quotation)) {
            destBill.set("baddebtlocamt", (Object)baddebtAmt.divide(exRate, precision, RoundingMode.HALF_UP));
        } else {
            destBill.set("baddebtlocamt", (Object)baddebtAmt.multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
        }
        destBill.set("unsettleamt", (Object)baddebtAmt);
        destBill.set("isperiod", (Object)Boolean.TRUE);
        DynamicObjectCollection detailEntries = destBill.getDynamicObjectCollection("entry");
        BaddebtHelper.resolveDetailEntry((BigDecimal)baddebtAmt, (BigDecimal)exRate, (String)quotation, (DynamicObjectCollection)detailEntries, (boolean)true, (int)precision);
        for (DynamicObject entry : detailEntries) {
            entry.set("e_unlockamt", (Object)entry.getBigDecimal("e_baddebtamt"));
        }
        DynamicObjectCollection planEntries = destBill.getDynamicObjectCollection("planentry");
        BaddebtHelper.resolvePlanEntry((BigDecimal)baddebtAmt, (BigDecimal)exRate, (String)quotation, (DynamicObjectCollection)planEntries, (boolean)true, (int)precision);
        for (DynamicObject planEntry : planEntries) {
            planEntry.set("p_unlockamt", (Object)planEntry.getBigDecimal("p_baddebtamt"));
        }
        return destBill;
    }

    private DynamicObject buildInitBaddebtReserve(DynamicObject srcBill, DynamicObject init, DynamicObject destBill) {
        if (destBill == null) {
            MainEntityType reserveDT = EntityMetadataCache.getDataEntityType((String)"ar_baddebtreservebill");
            String userID = String.valueOf(RequestContext.get().getCurrUserId());
            destBill = new DynamicObject((DynamicObjectType)reserveDT);
            destBill.set("creator", (Object)Long.valueOf(userID));
            destBill.set("createtime", (Object)new Date());
        }
        BaddebtHelper.buildBaseBaddebt((DynamicObject)srcBill, (DynamicObject)destBill);
        destBill.set("policytype", init.getDynamicObject("policytype").getPkValue());
        destBill.set("period", init.getDynamicObject("startperiod").getPkValue());
        destBill.set("initbaddebtid", init.getPkValue());
        destBill.set("exchangerate", (Object)srcBill.getBigDecimal("exchangerate"));
        destBill.set("basecurrency", srcBill.getDynamicObject("basecurrency").getPkValue());
        destBill.set("unsettleamt", (Object)srcBill.getBigDecimal("unsettleamount"));
        destBill.set("unsettlelocalamt", (Object)srcBill.getBigDecimal("unsettlelocalamt"));
        destBill.set("billstatus", (Object)"B");
        return destBill;
    }

    private void setInvoicedAmt(DynamicObject[] finBills) {
        for (DynamicObject bill : finBills) {
            Object recAmount;
            BigDecimal rowRecAmount;
            DynamicObjectCollection entry;
            String sourceBillType = bill.getString("sourcebilltype");
            if ("ar_invoice".equals(sourceBillType)) {
                entry = bill.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry) {
                    rowRecAmount = row.getBigDecimal("e_recamount");
                    row.set("e_invoicedamt", (Object)rowRecAmount);
                    row.set("e_uninvoicedamt", (Object)BigDecimal.ZERO);
                }
                recAmount = bill.getBigDecimal("recamount");
                bill.set("invoicedamt", recAmount);
                bill.set("uninvoicedamt", (Object)BigDecimal.ZERO);
                continue;
            }
            if (bill.getBigDecimal("invoicedamt").compareTo(BigDecimal.ZERO) != 0 || bill.getBigDecimal("uninvoicedamt").compareTo(BigDecimal.ZERO) != 0) continue;
            entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                rowRecAmount = row.getBigDecimal("e_recamount");
                BigDecimal rowRecLocalAmt = row.getBigDecimal("e_reclocalamt");
                row.set("e_invoicedamt", (Object)BigDecimal.ZERO);
                row.set("e_uninvoicedamt", (Object)rowRecAmount);
                row.set("e_uninvoicedlocalamt", (Object)rowRecLocalAmt);
            }
            recAmount = bill.getBigDecimal("recamount");
            BigDecimal recLocalAmt = bill.getBigDecimal("reclocalamt");
            bill.set("invoicedamt", (Object)BigDecimal.ZERO);
            bill.set("uninvoicedamt", recAmount);
            bill.set("uninvoicedlocalamt", (Object)recLocalAmt);
        }
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("entry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }

    private void submitAutoSettle(DynamicObject[] dataEntities) {
        Map<Long, List<DynamicObject>> dataMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(data -> data.getLong("org.id")));
        ArrayList<DynamicObject> submitSettleDatas = null;
        HashMap<Long, Boolean> paramMap = new HashMap<Long, Boolean>(8);
        for (Map.Entry<Long, List<DynamicObject>> entry : dataMap.entrySet()) {
            long orgId = entry.getKey();
            boolean submitSettle = paramMap.computeIfAbsent(orgId, e -> SystemParameterHelper.getARBooleanParam((long)orgId, (String)"ar_016"));
            if (!submitSettle) continue;
            List<DynamicObject> value = entry.getValue();
            if (submitSettleDatas == null) {
                submitSettleDatas = new ArrayList<DynamicObject>(value.size());
            }
            submitSettleDatas.addAll(value);
        }
        if (submitSettleDatas != null && !submitSettleDatas.isEmpty()) {
            BigDecimal disposeAmount;
            ArrayList<Long> existHasPremiumBillIds;
            ArrayList<DynamicObject> needSettleBillList = new ArrayList<DynamicObject>(1);
            ArrayList<DynamicObject> settleByPreEntryBillList = new ArrayList<DynamicObject>(submitSettleDatas.size());
            ArrayList<DynamicObject> settleByCoreBillBillList = new ArrayList<DynamicObject>(submitSettleDatas.size());
            List orgIds = submitSettleDatas.stream().map(bill -> bill.getLong("org.id")).distinct().collect(Collectors.toList());
            Map appParametersMap = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.TRUE, orgIds, (String[])new String[]{"ar_013", "ar_003"});
            block1: for (DynamicObject dynamicObject : submitSettleDatas) {
                long l = dynamicObject.getLong("org.id");
                Map orgParametersMap = (Map)appParametersMap.get(l);
                boolean isPeriod = dynamicObject.getBoolean("isperiod");
                DynamicObjectCollection preEntries = dynamicObject.getDynamicObjectCollection("preentry");
                if (!ObjectUtils.isEmpty((Object)preEntries)) {
                    settleByPreEntryBillList.add(dynamicObject);
                    needSettleBillList.add(dynamicObject);
                }
                DynamicObjectCollection detailEntries = dynamicObject.getDynamicObjectCollection("entry");
                for (DynamicObject detailEntry : detailEntries) {
                    String corebillno = detailEntry.getString("e_corebillno");
                    if (!kd.fi.arapcommon.util.StringUtils.isNotEmpty((String)corebillno) || isPeriod || orgParametersMap == null || !((Boolean)orgParametersMap.get("ar_013")).booleanValue()) continue;
                    settleByCoreBillBillList.add(dynamicObject);
                    needSettleBillList.add(dynamicObject);
                    continue block1;
                }
            }
            if (!needSettleBillList.isEmpty()) {
                existHasPremiumBillIds = new ArrayList<Long>(8);
                for (DynamicObject dynamicObject : needSettleBillList) {
                    BigDecimal disposeAmount2 = dynamicObject.getBigDecimal("premiumamt");
                    if (disposeAmount2.compareTo(BigDecimal.ZERO) == 0) continue;
                    existHasPremiumBillIds.add(dynamicObject.getLong("id"));
                }
                if (existHasPremiumBillIds.size() > 0) {
                    DynamicObject[] dynamicObjectArray;
                    for (DynamicObject finArBill : dynamicObjectArray = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", FinArBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", existHasPremiumBillIds)})) {
                        disposeAmount = finArBill.getBigDecimal("premiumamt");
                        FinArExitPremiumWBServiceHelper.occupy((DynamicObject)finArBill, (BigDecimal)disposeAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
                }
            }
            if (!settleByPreEntryBillList.isEmpty()) {
                this.doSettleByPreEntry(settleByPreEntryBillList);
            }
            if (!settleByCoreBillBillList.isEmpty()) {
                String settleModel;
                HashMap<String, List> needCoreSettleByModelMap = new HashMap<String, List>(8);
                for (DynamicObject dynamicObject : settleByCoreBillBillList) {
                    long orgId = dynamicObject.getLong("org.id");
                    Map orgParametersMap = (Map)appParametersMap.get(orgId);
                    if (ObjectUtils.isEmpty((Object)orgParametersMap)) continue;
                    settleModel = (String)orgParametersMap.get("ar_003");
                    List tempFinApBills = needCoreSettleByModelMap.getOrDefault(settleModel, new ArrayList(64));
                    tempFinApBills.add(dynamicObject);
                    needCoreSettleByModelMap.put(settleModel, tempFinApBills);
                }
                Map map = SettleServiceHelper.getRecedBillIdsByCoreBill(settleByCoreBillBillList, (Map)appParametersMap);
                Map map2 = SettleServiceHelper.getRecBillIdsByCoreBill(settleByCoreBillBillList, (Map)appParametersMap);
                ArReceiveAutoSettleService service = new ArReceiveAutoSettleService();
                for (Map.Entry entrySet : needCoreSettleByModelMap.entrySet()) {
                    SettleSchemeVO scheme;
                    settleModel = (String)entrySet.getKey();
                    List finArBills = (List)entrySet.getValue();
                    Set arBillIds = finArBills.stream().map(apBill -> apBill.getLong("id")).collect(Collectors.toSet());
                    Set recedBillIds = (Set)map.get(settleModel);
                    Set recBillIds = (Set)map2.get(settleModel);
                    if (!ObjectUtils.isEmpty((Object)recedBillIds)) {
                        CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)recedBillIds, (String)"ar_receivedbill", (boolean)true);
                        scheme = new SettleSchemeVO();
                        scheme.setOnlyByCoreBill(true);
                        service.batchAutoSettle(arBillIds, "ar_receivedbill", recedBillIds, scheme);
                    }
                    if (ObjectUtils.isEmpty((Object)recBillIds)) continue;
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)recBillIds, (String)"cas_recbill", (boolean)true);
                    TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(recBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                    scheme = new SettleSchemeVO();
                    scheme.setOnlyByCoreBill(true);
                    service.batchAutoSettle(arBillIds, "cas_recbill", recBillIds, scheme);
                }
            }
            if (!needSettleBillList.isEmpty()) {
                existHasPremiumBillIds = new ArrayList(8);
                for (DynamicObject dynamicObject : needSettleBillList) {
                    BigDecimal disposeAmount3 = dynamicObject.getBigDecimal("premiumamt");
                    if (disposeAmount3.compareTo(BigDecimal.ZERO) == 0) continue;
                    existHasPremiumBillIds.add(dynamicObject.getLong("id"));
                }
                if (existHasPremiumBillIds.size() > 0) {
                    DynamicObject[] dynamicObjectArray;
                    for (DynamicObject finArBill : dynamicObjectArray = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", FinArBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", existHasPremiumBillIds)})) {
                        disposeAmount = finArBill.getBigDecimal("premiumamt");
                        FinArExitPremiumWBServiceHelper.release((DynamicObject)finArBill, (BigDecimal)disposeAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
                }
            }
        }
    }

    private void doSettleByPreEntry(List<DynamicObject> settleByPreEntryBillList) {
        Object[] receivedArr;
        HashMap<String, HashSet<Long>> preInfoMap = new HashMap<String, HashSet<Long>>(settleByPreEntryBillList.size());
        for (DynamicObject bill : settleByPreEntryBillList) {
            DynamicObjectCollection preEntry = bill.getDynamicObjectCollection("preentry");
            for (DynamicObject row : preEntry) {
                long preBillId = row.getLong("y_billid");
                String preBillType = row.getString("y_billtype");
                BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                HashSet<Long> ids = (HashSet<Long>)preInfoMap.get(preBillType);
                if (ids == null) {
                    ids = new HashSet<Long>(2);
                }
                ids.add(preBillId);
                preInfoMap.put(preBillType, ids);
            }
        }
        HashMap<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        HashMap<Long, Map<Long, BigDecimal>> asstOrgAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        Set recIds = (Set)preInfoMap.get("cas_recbill");
        Set receivedIds = (Set)preInfoMap.get("ar_receivedbill");
        Object[] recArr = this.recValidateBeforeSettle(recIds, asstUnsettleAmtMap, asstOrgAmtMap, settleByPreEntryBillList);
        Object[] recMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])recArr, (Object[])(receivedArr = this.receivedValidateBeforeSettle(receivedIds, asstUnsettleAmtMap, asstOrgAmtMap, settleByPreEntryBillList)));
        if (ObjectUtils.isEmpty((Object[])recMergeArr)) {
            return;
        }
        List tempVOs = RecBillHandlerHelper.getAsstListVO((DynamicObject[])recMergeArr);
        Map<Long, List<BillSettleVO>> entryIdVOMap = tempVOs.stream().collect(Collectors.groupingBy(BillSettleVO::getEntryId));
        if (!ObjectUtils.isEmpty(asstUnsettleAmtMap)) {
            Map<Long, List<DynamicObject>> collect = settleByPreEntryBillList.stream().collect(Collectors.groupingBy(finBill -> finBill.getLong("org.id")));
            Map orgSettleEntry = ArApHelper.batchGetArSettleParam(collect.keySet());
            ArReceiveSettleService service = new ArReceiveSettleService();
            for (Map.Entry<Long, List<DynamicObject>> entry : collect.entrySet()) {
                DynamicObject[] mainArr;
                Long orgId = entry.getKey();
                int settleEntry = (Integer)orgSettleEntry.get(orgId);
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setSettle(true);
                scheme.setSettleEntryParam(settleEntry);
                scheme.setMatchServiceClass("kd.fi.arapcommon.service.match.PreEntrySettleMatchService");
                ArrayList<BillSettleVO> asstListVO = new ArrayList<BillSettleVO>(1);
                for (DynamicObject finBill2 : settleByPreEntryBillList) {
                    BigDecimal canSettleAmt;
                    long asstId;
                    long id = finBill2.getLong("id");
                    String mainBillno = finBill2.getString("billno");
                    int rowIndex = 1;
                    boolean isMergeRows = ((DynamicObject)finBill2.getDynamicObjectCollection("preentry").get(0)).getLong("y_billentryid") != 0L ? Boolean.TRUE : Boolean.FALSE;
                    if (isMergeRows) {
                        for (DynamicObject row : finBill2.getDynamicObjectCollection("preentry")) {
                            asstId = row.getLong("y_billid");
                            long asstEntryId = row.getLong("y_billentryid");
                            String asstBillno = row.getString("y_billno");
                            BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                            canSettleAmt = (BigDecimal)((Map)asstUnsettleAmtMap.get(asstId)).get(asstEntryId);
                            if (canSettleAmt.abs().compareTo(settleAmt.abs()) < 0) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884\u6536\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillAuditOp_4", (String)"fi-ar-opplugin", (Object[])new Object[0]), mainBillno, rowIndex, asstBillno));
                            }
                            BillSettleVO tempVO = entryIdVOMap.get(asstEntryId).get(0);
                            BillSettleVO billSettleVO = (BillSettleVO)tempVO.clone();
                            billSettleVO.setEntryUnSettleAmt(settleAmt);
                            HashMap<String, Long> resultExtMap = new HashMap<String, Long>(1);
                            resultExtMap.put("billId", id);
                            resultExtMap.putAll(tempVO.getExtFields());
                            billSettleVO.setExtFields(resultExtMap);
                            asstListVO.add(billSettleVO);
                            ++rowIndex;
                            canSettleAmt = canSettleAmt.subtract(settleAmt);
                            ((Map)asstUnsettleAmtMap.get(asstId)).put(asstEntryId, canSettleAmt);
                            Map orgIdAmtMap = (Map)asstOrgAmtMap.get(asstId);
                            BigDecimal billCanSettleAmt = (BigDecimal)orgIdAmtMap.get(orgId);
                            orgIdAmtMap.put(orgId, billCanSettleAmt.subtract(settleAmt));
                            asstOrgAmtMap.put(asstId, orgIdAmtMap);
                        }
                        continue;
                    }
                    for (DynamicObject row : finBill2.getDynamicObjectCollection("preentry")) {
                        asstId = row.getLong("y_billid");
                        String asstBillno = row.getString("y_billno");
                        BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                        if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        Map entryIdAmtMap = (Map)asstUnsettleAmtMap.get(asstId);
                        Map orgIdAmtMap = (Map)asstOrgAmtMap.get(asstId);
                        canSettleAmt = (BigDecimal)orgIdAmtMap.get(orgId);
                        if (canSettleAmt.abs().compareTo(settleAmt.abs()) < 0) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884\u6536\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillAuditOp_4", (String)"fi-ar-opplugin", (Object[])new Object[0]), mainBillno, rowIndex, asstBillno));
                        }
                        for (Map.Entry entry2 : entryIdAmtMap.entrySet()) {
                            HashMap<String, Long> resultExtMap;
                            BillSettleVO newVO;
                            BigDecimal entryCanSettleAmt;
                            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) break;
                            long entryId = (Long)entry2.getKey();
                            BillSettleVO tempVO = entryIdVOMap.get(entryId).get(0);
                            long entryOrgId = tempVO.getOrgId();
                            if (entryOrgId != orgId || (entryCanSettleAmt = (BigDecimal)entry2.getValue()).compareTo(BigDecimal.ZERO) == 0) continue;
                            if (settleAmt.abs().compareTo(entryCanSettleAmt.abs()) <= 0) {
                                newVO = (BillSettleVO)tempVO.clone();
                                newVO.setEntryUnSettleAmt(settleAmt);
                                resultExtMap = new HashMap<String, Long>(1);
                                resultExtMap.put("billId", id);
                                resultExtMap.putAll(tempVO.getExtFields());
                                newVO.setExtFields(resultExtMap);
                                asstListVO.add(newVO);
                                ++rowIndex;
                                orgIdAmtMap.put(orgId, canSettleAmt.subtract(settleAmt));
                                entryCanSettleAmt = entryCanSettleAmt.subtract(settleAmt);
                                settleAmt = BigDecimal.ZERO;
                                entry2.setValue(entryCanSettleAmt);
                                continue;
                            }
                            newVO = (BillSettleVO)tempVO.clone();
                            newVO.setEntryUnSettleAmt(entryCanSettleAmt);
                            resultExtMap = new HashMap(1);
                            resultExtMap.put("billId", id);
                            resultExtMap.putAll(tempVO.getExtFields());
                            newVO.setExtFields(resultExtMap);
                            asstListVO.add(newVO);
                            ++rowIndex;
                            orgIdAmtMap.put(orgId, BigDecimal.ZERO);
                            settleAmt = settleAmt.subtract((BigDecimal)entry2.getValue());
                            entry2.setValue(BigDecimal.ZERO);
                        }
                        asstOrgAmtMap.put(asstId, orgIdAmtMap);
                    }
                }
                if (ObjectUtils.isEmpty(asstListVO)) continue;
                Set mainBillIds = entry.getValue().stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
                for (DynamicObject obj : mainArr = FinArBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)})) {
                    DynamicObjectCollection detailEntry = obj.getDynamicObjectCollection("entry");
                    for (DynamicObject row : detailEntry) {
                        row.set("e_settledamt", row.get("e_lockedamt"));
                        row.set("e_unsettleamt", row.get("e_unlockamt"));
                    }
                    DynamicObjectCollection planEntry = obj.getDynamicObjectCollection("planentity");
                    for (DynamicObject row : planEntry) {
                        row.set("plansettledamt", row.get("planlockedamt"));
                        row.set("unplansettleamt", row.get("unplanlockamt"));
                    }
                }
                List mainListVO = FinArBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
                for (BillSettleVO settleVO : mainListVO) {
                    Map extFields = settleVO.getExtFields();
                    extFields.put("billId", settleVO.getId());
                    settleVO.setExtFields(extFields);
                }
                service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.AUTO.getValue());
            }
        }
    }

    private DynamicObject[] recValidateBeforeSettle(Set<Long> recIds, Map<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap, Map<Long, Map<Long, BigDecimal>> asstOrgAmtMap, List<DynamicObject> settleByPreEntryBillList) {
        if (ObjectUtils.isEmpty(recIds)) {
            return null;
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(recIds, (String)"cas_recbill", (boolean)true);
        TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(recIds.stream().map(String::valueOf).collect(Collectors.toList()));
        Object[] assts = RecBillHandlerHelper.loadRec((QFilter[])new QFilter[]{new QFilter("id", "in", recIds)});
        HashSet<Long> asstIds = new HashSet<Long>(recIds.size());
        for (Object asst : assts) {
            long id = asst.getLong("id");
            HashMap<Long, BigDecimal> orgUnSettleAmtMap = new HashMap<Long, BigDecimal>(2);
            DynamicObjectCollection entry = asst.getDynamicObjectCollection("entry");
            LinkedHashMap<Long, BigDecimal> entryIdAmtMap = new LinkedHashMap<Long, BigDecimal>(1);
            for (DynamicObject row : entry) {
                DynamicObject receivingType = row.getDynamicObject("e_receivingtype");
                long entryOrgId = row.getLong("e_settleorg.id");
                if (ObjectUtils.isEmpty((Object)receivingType) || !receivingType.getBoolean("ispartreceivable") || !"101".equals(receivingType.getString("biztype"))) continue;
                long entryId = row.getLong("id");
                BigDecimal unSettleAmt = row.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                entryIdAmtMap.put(entryId, unSettleAmt);
                BigDecimal orgUnSettleAmt = (BigDecimal)orgUnSettleAmtMap.get(entryOrgId);
                if (orgUnSettleAmt == null) {
                    orgUnSettleAmt = BigDecimal.ZERO;
                }
                orgUnSettleAmt = orgUnSettleAmt.add(unSettleAmt);
                orgUnSettleAmtMap.put(entryOrgId, orgUnSettleAmt);
            }
            asstUnsettleAmtMap.put(id, entryIdAmtMap);
            asstOrgAmtMap.put(id, orgUnSettleAmtMap);
            asstIds.add(id);
        }
        if (ObjectUtils.isEmpty((Object[])assts) || recIds.size() != assts.length) {
            for (DynamicObject finBill : settleByPreEntryBillList) {
                DynamicObjectCollection preEntry = finBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    long preBillId = row.getLong("y_billid");
                    String preBillType = row.getString("y_billtype");
                    if (asstIds.contains(preBillId) || !"cas_recbill".equals(preBillType)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884\u6536\u6b3e\u5355%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillSubmitOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), finBill.getString("billno"), row.getString("y_billno")));
                }
            }
        }
        return assts;
    }

    private DynamicObject[] receivedValidateBeforeSettle(Set<Long> receivedIds, Map<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap, Map<Long, Map<Long, BigDecimal>> asstOrgAmtMap, List<DynamicObject> settleByPreEntryBillList) {
        if (ObjectUtils.isEmpty(receivedIds)) {
            return null;
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(receivedIds, (String)"ar_receivedbill", (boolean)true);
        Object[] assts = RecBillHandlerHelper.loadReced((QFilter[])new QFilter[]{new QFilter("id", "in", receivedIds)});
        HashSet<Long> asstIds = new HashSet<Long>(receivedIds.size());
        for (Object asst : assts) {
            long id = asst.getLong("id");
            DynamicObjectCollection entry = asst.getDynamicObjectCollection("entry");
            LinkedHashMap<Long, BigDecimal> entryIdAmtMap = new LinkedHashMap<Long, BigDecimal>(1);
            HashMap<Long, BigDecimal> orgUnSettleAmtMap = new HashMap<Long, BigDecimal>(2);
            BigDecimal orgUnSettleAmt = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                long entryId = row.getLong("id");
                BigDecimal unSettleAmt = row.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                entryIdAmtMap.put(entryId, unSettleAmt);
                orgUnSettleAmt = orgUnSettleAmt.add(unSettleAmt);
            }
            orgUnSettleAmtMap.put(asst.getLong("org.id"), orgUnSettleAmt);
            asstOrgAmtMap.put(id, orgUnSettleAmtMap);
            asstUnsettleAmtMap.put(id, entryIdAmtMap);
            asstIds.add(id);
        }
        if (ObjectUtils.isEmpty((Object[])assts) || receivedIds.size() != assts.length) {
            for (DynamicObject finBill : settleByPreEntryBillList) {
                DynamicObjectCollection preEntry = finBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    long preBillId = row.getLong("y_billid");
                    String preBillType = row.getString("y_billtype");
                    if (asstIds.contains(preBillId) || !"ar_receivedbill".equals(preBillType)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884\u6536\u6b3e\u5355%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillSubmitOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), finBill.getString("billno"), row.getString("y_billno")));
                }
            }
        }
        return assts;
    }

    private void removeEmptyPlanEntry(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            DynamicObjectCollection planEntryCol = bill.getDynamicObjectCollection("planentity");
            if (ObjectUtils.isEmpty((Object)planEntryCol)) continue;
            DynamicObject planEntry = (DynamicObject)planEntryCol.get(0);
            planEntryCol.removeIf(row -> row.getBigDecimal("planpricetax").compareTo(BigDecimal.ZERO) == 0);
            if (planEntryCol.size() != 0) continue;
            planEntryCol.add((Object)planEntry);
        }
    }

    private void busQtyAndAmtValidator(DynamicObject[] bills) {
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        for (DynamicObject bill : bills) {
            String sourceBillType = bill.getString("sourcebilltype");
            if (kd.fi.arapcommon.util.StringUtils.isEmpty((String)sourceBillType)) continue;
            billIds.add(bill.getLong("id"));
        }
        if (billIds.size() == 0) {
            return;
        }
        FinArExcessBusValidator validator = new FinArExcessBusValidator();
        List results = validator.validate(billIds, "submit");
        ArrayList<String> errMessage = new ArrayList<String>(16);
        for (BusValidatorResult result : results) {
            String message = result.getMessage();
            errMessage.add(message);
        }
        if (errMessage.size() > 0) {
            throw new KDBizException(StringUtils.join(errMessage, (String)"\n"));
        }
    }
}

