/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ar.validator.FinArTransferConfirmValidator;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.validator.DecimalScopeValidator;

public class FinArBillTransferConfirmOp
extends ArapBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinArTransferConfirmValidator());
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject transferInfo = e.getDataEntities()[0];
        List<AssignBillPushParam> paramList = this.dynamicObjectCovertParam(transferInfo);
        ArApServiceAPIFactory.getPushBillService((String)ServiceNameEnum.FINARTRANSFER.getValue()).assignBillEntryPush("ar_finarbill", "entry", paramList);
    }

    private List<AssignBillPushParam> dynamicObjectCovertParam(DynamicObject transferInfo) {
        BillModel billModel = BillModelFactory.getModel((String)"ar_finarbill");
        ArrayList<AssignBillPushParam> paramList = new ArrayList<AssignBillPushParam>(2);
        String transferType = transferInfo.getString("transfertype");
        DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entryentity");
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"ar_transferofcredit");
        Set headExtendFields = (Set)extendFieldMap.get("head");
        Set materialExtendFields = (Set)extendFieldMap.get("entry");
        Set planExtendFields = (Set)extendFieldMap.get("planentity");
        for (DynamicObject transRow : entry) {
            BigDecimal transAmount = transRow.getBigDecimal("e_transamount");
            BigDecimal transTax = transRow.getBigDecimal("e_transtax");
            if (BigDecimal.ZERO.compareTo(transAmount) == 0 && BigDecimal.ZERO.compareTo(transTax) == 0) continue;
            AssignBillPushParam pushParam = new AssignBillPushParam(transRow.getLong("e_srcfinbillid"), transRow.getLong("e_srcentryid"));
            pushParam.setTransferType(transferType);
            HashMap<String, Object> tarFieldValueMap = new HashMap<String, Object>(16);
            tarFieldValueMap.put(billModel.HEAD_BILLTYPE, transferInfo.getDynamicObject("billtype"));
            tarFieldValueMap.put(billModel.HEAD_ASSTACTTYPE, transferInfo.getString("asstacttype"));
            tarFieldValueMap.put(billModel.HEAD_ASSTACT, transferInfo.getDynamicObject("asstact"));
            tarFieldValueMap.put(billModel.HEAD_REMARK, transferInfo.getString("remark"));
            tarFieldValueMap.put(billModel.HEAD_BIZDATE, transferInfo.getDate("bizdate"));
            tarFieldValueMap.put(billModel.HEAD_DUEDATE, transferInfo.getDate("duedate"));
            tarFieldValueMap.put(billModel.HEAD_EXCHANGERATE, transferInfo.getBigDecimal("head_exchangerate"));
            tarFieldValueMap.put(billModel.HEAD_PAYCOND, transferInfo.getDynamicObject("paycond"));
            tarFieldValueMap.put(billModel.HEAD_SETTLEMENTTYPE, transferInfo.getDynamicObject("settlementtype"));
            tarFieldValueMap.put(billModel.HEAD_SALESORG, transferInfo.getDynamicObject("salesorg"));
            tarFieldValueMap.put(billModel.HEAD_SALESMAN, transferInfo.getDynamicObject("salesman"));
            tarFieldValueMap.put(billModel.HEAD_SALESGROUP, transferInfo.getDynamicObject("salesgroup"));
            tarFieldValueMap.put(billModel.E_QUANTITY, transRow.getBigDecimal("e_quantity"));
            tarFieldValueMap.put(billModel.E_TAXRATEID, transRow.getDynamicObject("taxrateid"));
            tarFieldValueMap.put(billModel.E_AMOUNT, transAmount);
            tarFieldValueMap.put(billModel.E_TAX, transTax);
            for (String headExtendField : headExtendFields) {
                tarFieldValueMap.put(headExtendField, transferInfo.get(headExtendField));
            }
            for (String materialExtendField : materialExtendFields) {
                tarFieldValueMap.put(materialExtendField, transRow.get(materialExtendField));
            }
            pushParam.setTarFieldValueMap(tarFieldValueMap);
            paramList.add(pushParam);
        }
        AssignBillPushParam pushParam = (AssignBillPushParam)paramList.get(0);
        DynamicObjectCollection planEntry = transferInfo.getDynamicObjectCollection("planentity");
        ArrayList planEntryParams = new ArrayList(planEntry.size());
        for (DynamicObject planRow : planEntry) {
            HashMap<String, Object> tarPlanFieldValueMap = new HashMap<String, Object>(16);
            tarPlanFieldValueMap.put("p_billno", planRow.get("p_billno"));
            tarPlanFieldValueMap.put("p_billid", planRow.get("p_billid"));
            tarPlanFieldValueMap.put("p_entryid", planRow.get("p_entryid"));
            tarPlanFieldValueMap.put("p_transpricetaxtotal", planRow.get("p_transpricetaxtotal"));
            tarPlanFieldValueMap.put("p_splitdimensionid", planRow.get("p_splitdimensionid"));
            tarPlanFieldValueMap.put("p_recrate", planRow.get("p_recrate"));
            for (String fieldName : planExtendFields) {
                tarPlanFieldValueMap.put(fieldName, planRow.get(fieldName));
            }
            planEntryParams.add(tarPlanFieldValueMap);
        }
        pushParam.setTarInvEntrys(planEntryParams);
        return paramList;
    }
}

