/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ar.mservice.ArReceiveAutoSettleService;
import kd.fi.ar.validator.FinArBillUnSubmitValidator;
import kd.fi.arapcommon.enums.ARSettleStatusEnum;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;

public class FinArBillUnSubmitOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinArBillUnSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("settlestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinArBillUnSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinArBillUnSubmitOp.beginOperationTransaction start");
        List<DynamicObject> needExecuteUnSettleBills = Arrays.stream(entities).filter(entity -> !ARSettleStatusEnum.UNSETTLE.getValue().equals(entity.getString("settlestatus"))).collect(Collectors.toList());
        if (needExecuteUnSettleBills.size() > 0) {
            Set idSet = Arrays.stream(entities).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
            CommonSettleServiceHelper.settleAddMutexCtrlInTX(idSet, (String)this.billEntityType.getName(), (boolean)false);
            ArReceiveAutoSettleService iService = new ArReceiveAutoSettleService();
            iService.unAutoSettle(needExecuteUnSettleBills.toArray(new DynamicObject[0]));
        }
        logger.info("FinArBillUnSubmitOp.beginOperationTransaction end");
    }
}

