/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.invoice.FinArToInvoiceDiffAmtService;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class FinArInvoiceDiffAmtOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String[] selectArry;
        super.onPreparePropertys(e);
        List props = e.getFieldKeys();
        for (String select : selectArry = this.getSelectors().split(",")) {
            props.add(select);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                ArrayList<Long> finArOrgIds = new ArrayList<Long>(dataEntities.length);
                ArrayList<Long> finArIds = new ArrayList<Long>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject arBill = dataEntity.getDataEntity();
                    finArOrgIds.add(arBill.getLong("org.id"));
                    finArIds.add(arBill.getLong("id"));
                }
                DynamicObject[] revcfBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"isvoucher,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", finArIds).and("sourcebilltype", "=", (Object)"ar_finarbill")});
                DynamicObject[] invoiceBills = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"invoicestatus,sourcebillid", (QFilter[])new QFilter[]{new QFilter("entry.e_sourcebillid", "in", finArIds).and("sourcebilltype", "=", (Object)"ar_finarbill").and("invoicestatus", "=", (Object)"1")});
                Map ar026Map = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, finArOrgIds, (String)"ar_026");
                DynamicObjectCollection closeAccounts = QueryServiceHelper.query((String)"ar_closeaccount", (String)"org,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", finArOrgIds)});
                HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(64);
                for (DynamicObject closeAccount : closeAccounts) {
                    long orgId = closeAccount.getLong("org");
                    Date currentDate = closeAccount.getDate("currentdate");
                    if (currentDateMap.containsKey(orgId)) continue;
                    currentDateMap.put(orgId, currentDate);
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Long orgId;
                    Object ar026;
                    DynamicObject arBill = dataEntity.getDataEntity();
                    String settleStatus = arBill.getString("settlestatus");
                    boolean isVoucher = arBill.getBoolean("isvoucher");
                    if (!"unsettle".equals(settleStatus)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ed3\u7b97\u5355\u636e\u4e0d\u80fd\u53c2\u4e0e\u8c03\u5dee\u3002", (String)"FinArInvoiceDiffAmtOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    }
                    if (isVoucher) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u4e0d\u80fd\u53c2\u4e0e\u8c03\u5dee\u3002", (String)"FinArInvoiceDiffAmtOp_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    }
                    if ((ar026 = ar026Map.get(orgId = Long.valueOf(arBill.getLong("org.id")))) == null || !((Boolean)ar026).booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u8c03\u5dee\u53c2\u6570\u672a\u6253\u5f00\u3002", (String)"FinArInvoiceDiffAmtOp_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    Date closeCurrDate = (Date)currentDateMap.get(orgId);
                    Date bookDate = arBill.getDate("bookdate");
                    if (closeCurrDate == null || bookDate.compareTo(closeCurrDate) < 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5e94\u5927\u4e8e\u5173\u8d26\u65e5\u671f\u3002", (String)"FinArInvoiceDiffAmtOp_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection entrys = arBill.getDynamicObjectCollection("entry");
                    for (DynamicObject[] entry : entrys) {
                        BigDecimal recAmt = entry.getBigDecimal("e_recamount");
                        BigDecimal invAmt = entry.getBigDecimal("e_invoicedamt");
                        BigDecimal recLocalAmt = entry.getBigDecimal("e_reclocalamt");
                        BigDecimal invLocalAmt = entry.getBigDecimal("e_invoicedlocalamt");
                        if (recAmt.compareTo(invAmt) == 0 && recLocalAmt.compareTo(invLocalAmt) == 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u884c\u6bcf\u884c\u5e94\u6536\u91d1\u989d\u5e94\u7b49\u4e8e\u5df2\u5173\u8054\u5f00\u7968\u91d1\u989d,\u5e94\u6536\u91d1\u989d\u672c\u5e01\u5e94\u7b49\u4e8e\u5df2\u5173\u8054\u5f00\u7968\u91d1\u989d\u672c\u5e01\u3002", (String)"FinArInvoiceDiffAmtOp_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    String finarId = arBill.getString("id");
                    if (revcfBills != null && revcfBills.length > 0) {
                        for (DynamicObject revcfBill : revcfBills) {
                            String srcId = revcfBill.getString("sourcebillid");
                            boolean recIsVoucher = revcfBill.getBoolean("isvoucher");
                            if (!recIsVoucher || !srcId.equals(finarId)) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u6536\u5355\u5173\u8054\u7684\u6536\u5165\u786e\u8ba4\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"FinArInvoiceDiffAmtOp_5", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                            break;
                        }
                    }
                    if (invoiceBills != null && invoiceBills.length > 0) {
                        boolean isExitInv = false;
                        for (DynamicObject invBill : invoiceBills) {
                            String srcId = invBill.getString("sourcebillid");
                            if (!srcId.equals(finarId)) continue;
                            isExitInv = true;
                            break;
                        }
                        if (isExitInv) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u7684\u5df2\u5f00\u7968\u7684\u5f00\u7968\u5355\u3002", (String)"FinArInvoiceDiffAmtOp_6", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u5f00\u7968\u5355\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"FinArInvoiceDiffAmtOp_7", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        FinArToInvoiceDiffAmtService diffAmtService = new FinArToInvoiceDiffAmtService();
        DynamicObject[] arBills = e.getDataEntities();
        diffAmtService.repairFinArTailData(arBills);
    }

    private String getSelectors() {
        return "billno,invoicedate,org,bookdate,settlestatus,basecurrency,currency,invoicecode,invoiceno,payproperty,e_issueinvrecamt,e_uninvoicedamt,e_invoicedamt,issueinvrecamt,uninvoicedamt,invoicedamt,e_recamount,e_quantity,e_invoicedqty,e_uninvoicedqty,e_invoicecode,e_invoiceno,invoicedlocalamt,uninvoicedlocalamt,issueinvreclocalamt,e_issueinvamt,e_issueinvtax,e_issueinvqty,e_invoicedlocalamt,e_uninvoicedlocalamt,e_issueinvlocalamt,e_issueinvlocaltax,e_issueinvreclocalamt,e_reclocalamt,e_settledamt,e_amount,e_localamt,e_tax,recamount,reclocalamt,amount,localamt,tax,e_confirmedamt,e_unverifyamt,e_unlockamt,e_unsettleamt,e_unsettlelocalamt,planpricetax,planpricetaxloc,unplanlockamt,unplansettleamt,unplansettlelocamt,unsettleamount,unsettlelocalamt,unverifyamount,isvoucher,e_taxlocalamt,taxlocamt,ispremium";
    }
}

